/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.wiki.ui;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.imageio.ImageIO;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.document.DocumentResource;
import org.simantics.wiki.ui.ReportFactory;
import org.simantics.wiki.ui.SimanticsImageDialect;

public class DefaultWikiReportFactory
implements ReportFactory {
    protected String markup = null;

    public DefaultWikiReportFactory(ReadGraph graph, Resource resource) {
    }

    @Override
    public ReportFactory.Report createReport(ReadGraph graph, Resource object) throws DatabaseException {
        DocumentResource DOC = DocumentResource.getInstance((ReadGraph)graph);
        this.markup = (String)graph.getPossibleRelatedValue(object, DOC.HasDocumentation, (Binding)Bindings.STRING);
        SimanticsImageDialect.INSTANCE.clearImages();
        final String finalMarkup = SimanticsImageDialect.INSTANCE.apply(graph, null, this.markup);
        Map<String, BufferedImage> images = SimanticsImageDialect.INSTANCE.getImages();
        final HashMap<String, byte[]> files = new HashMap<String, byte[]>();
        for (String filename : images.keySet()) {
            ByteArrayOutputStream baos = null;
            try {
                try {
                    baos = new ByteArrayOutputStream();
                    ImageIO.write((RenderedImage)images.get(filename), "png", baos);
                    files.put(filename, baos.toByteArray());
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        baos.close();
                    }
                    catch (IOException iOException) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                try {
                    baos.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                baos.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new ReportFactory.Report(){
            protected String identifier = UUID.randomUUID().toString();

            @Override
            public String getContent() {
                return finalMarkup;
            }

            @Override
            public byte[] getFile(String key) {
                return (byte[])files.get(key);
            }

            @Override
            public Set<String> getFiles() {
                return files.keySet();
            }

            @Override
            public String getIdentifier() {
                return this.identifier;
            }

            @Override
            public void setIdentifier(String identifier) {
                this.identifier = identifier;
            }
        };
    }
}

