/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.server.io;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.simantics.document.server.io.CommandContext;
import org.simantics.document.server.io.CommandContextMutable;

public class CommandContextImpl
implements CommandContextMutable {
    private Map<String, List<List<Object>>> data = new HashMap<String, List<List<Object>>>();

    @Override
    public boolean containsKey(String key) {
        return this.data.containsKey(key);
    }

    @Override
    public List<List<Object>> getRows(String key) {
        List<List<Object>> rows = this.data.get(key);
        if (rows != null) {
            return rows;
        }
        return Collections.emptyList();
    }

    @Override
    public CommandContextMutable putRow(String key, List<Object> row) {
        List<List<Object>> rows = this.ensureRowsAvailable(key);
        rows.add(row);
        return this;
    }

    @Override
    public String getString(String key) {
        List<List<Object>> rows = this.getRows(key);
        if (rows == null || rows.size() != 1) {
            return null;
        }
        List<Object> t = rows.get(0);
        if (t.size() != 2) {
            return null;
        }
        Object o = t.get(1);
        if (!(o instanceof String)) {
            return null;
        }
        return (String)o;
    }

    @Override
    public CommandContextMutable putString(String key, String value) {
        if (this.data.containsKey(key)) {
            this.data.remove(key);
        }
        List<List<Object>> rows = this.ensureRowsAvailable(key);
        ArrayList<String> t = new ArrayList<String>();
        t.add(key);
        t.add(value);
        rows.add(t);
        return this;
    }

    private List<List<Object>> ensureRowsAvailable(String key) {
        List<List<Object>> rows = this.data.get(key);
        if (rows == null) {
            rows = new ArrayList<List<Object>>();
            this.data.put(key, rows);
        }
        return rows;
    }

    @Override
    public Map<String, List<List<Object>>> getData() {
        return this.data;
    }

    @Override
    public CommandContextMutable merge(CommandContext context) {
        if (context != null) {
            Map<String, List<List<Object>>> from = context.getData();
            for (Map.Entry<String, List<List<Object>>> entry : from.entrySet()) {
                List<List<Object>> rows = this.ensureRowsAvailable(entry.getKey());
                rows.addAll((Collection<List<Object>>)entry.getValue());
            }
        }
        return this;
    }

    public static CommandContextMutable create() {
        return new CommandContextImpl();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, List<List<Object>>> entry : this.data.entrySet()) {
            sb.append(entry.getKey());
            sb.append(":");
            sb.append(entry.getValue());
            sb.append("\n");
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CommandContextImpl other = (CommandContextImpl)obj;
        return !(this.data == null ? other.data != null : !this.data.equals(other.data));
    }
}

