/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural.synchronization.base;

import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.structural.synchronization.base.CommandBuilder;
import org.simantics.structural.synchronization.base.ComponentBase;
import org.simantics.structural.synchronization.base.ModuleCallback;
import org.simantics.structural.synchronization.base.Solver;
import org.simantics.structural.synchronization.base.SynchronizationEventHandlerBase;

public class ModuleUpdateContext<T extends ComponentBase<T>> {
    private final SynchronizationEventHandlerBase<T> handler;
    public final T component;
    public CommandBuilder command;
    private ArrayList<Runnable> postUpdateActions;
    private THashMap<String, Variant> storedProperties;
    private int pendingRuleCount;
    public boolean stateLoadedFromUndo;

    public ModuleUpdateContext(SynchronizationEventHandlerBase<T> handler, T component) {
        this.handler = handler;
        this.component = component;
    }

    public void incPendingCount() {
        ++this.pendingRuleCount;
    }

    public void decPendingCount() {
        --this.pendingRuleCount;
        if (this.pendingRuleCount == 0) {
            this.command.apply(this.getSolver());
            if (this.getModuleId() <= 0) {
                this.setModuleId(this.getSolver().getId(this.getModuleName()));
                ((ComponentBase)this.component).setModuleId(this.getModuleId());
            }
            if (this.postUpdateActions != null) {
                for (Runnable action : this.postUpdateActions) {
                    action.run();
                }
                this.postUpdateActions = null;
            }
            this.handler.resolver.unmarkPending(this.component);
        }
    }

    public void addPostUpdateAction(Runnable action) {
        if (this.postUpdateActions == null) {
            this.postUpdateActions = new ArrayList(2);
        }
        this.postUpdateActions.add(action);
    }

    public int getModuleId() {
        return ((ComponentBase)this.component).getModuleId();
    }

    public SynchronizationEventHandlerBase<T> getHandler() {
        return this.handler;
    }

    public void setModuleId(int moduleId) {
        ((ComponentBase)this.component).setModuleId(moduleId);
    }

    public Solver getSolver() {
        return this.handler.solver;
    }

    public <S> S getConcreteSolver() {
        return (S)this.handler.solver.getConcreteSolver();
    }

    public String getModuleName() {
        return ((ComponentBase)this.component).solverComponentName;
    }

    public void setModuleName(String moduleName) {
        ((ComponentBase)this.component).solverComponentName = moduleName;
    }

    public void reportProblem(String description) {
        this.handler.reportProblem(description);
    }

    public void reportProblem(String description, Exception e) {
        this.handler.reportProblem(description, e);
    }

    public void resolveReference(String connectionPoint, ModuleCallback moduleCallback) {
        this.handler.resolver.resolveReference(this.component, connectionPoint, moduleCallback);
    }

    public void storeProperty(String name, Variant value) {
        if (this.storedProperties == null) {
            this.storedProperties = new THashMap();
        }
        this.storedProperties.put((Object)name, (Object)value);
    }

    public Variant getStoredProperty(String name) {
        if (this.storedProperties == null) {
            return null;
        }
        return (Variant)this.storedProperties.get((Object)name);
    }

    public void addPostSynchronizationAction(Runnable action) {
        this.handler.addPostSynchronizationAction(action);
    }

    public <C> C getConcreteCommand() {
        return (C)this.command.getConcrete();
    }

    public void setDidChanges() {
        this.handler.setDidChanges();
    }
}

