/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural.synchronization.base;

import gnu.trove.map.hash.THashMap;
import gnu.trove.procedure.TObjectObjectProcedure;
import gnu.trove.procedure.TObjectProcedure;
import gnu.trove.set.hash.THashSet;
import org.simantics.structural.synchronization.base.ComponentBase;
import org.simantics.structural.synchronization.base.ComponentFactory;
import org.simantics.structural.synchronization.base.Solver;
import org.simantics.structural.synchronization.base.StateUndoContextBase;

public abstract class MappingBase<T extends ComponentBase<T>> {
    transient THashMap<String, T> configurationByUid;
    transient THashSet<T> pendingRemoval = new THashSet();
    public transient StateUndoContextBase undoContext = this.createUndoContext();
    public transient ComponentFactory<T> componentFactory = this.createComponentFactory();
    public long currentRevision;
    private boolean trustUids;

    public abstract T getConfiguration();

    public MappingBase() {
        this(null, -1L, false);
    }

    public MappingBase(T configuration, boolean trustUids) {
        this(configuration, -1L, trustUids);
    }

    public MappingBase(T configuration, long currentRevision, boolean trustUids) {
        if (trustUids) {
            this.createConfigurationById(configuration);
        }
        this.currentRevision = currentRevision;
        this.trustUids = trustUids;
    }

    public abstract StateUndoContextBase createUndoContext();

    public abstract ComponentFactory<T> createComponentFactory();

    protected void createConfigurationById(T configuration) {
        THashMap configurationByUid = new THashMap();
        this.browseConfiguration(configurationByUid, configuration);
        this.configurationByUid = configurationByUid;
    }

    private void browseConfiguration(THashMap<String, T> configurationByUid, T configuration) {
        configurationByUid.put((Object)((ComponentBase)configuration).uid, configuration);
        for (ComponentBase child : ((ComponentBase)configuration).getChildren()) {
            this.browseConfiguration(configurationByUid, child);
            child.parent = configuration;
        }
    }

    public T detachOrCreateComponent(String uid) {
        ComponentBase result = (ComponentBase)this.configurationByUid.get((Object)uid);
        if (result == null) {
            result = this.componentFactory.create(uid);
            this.configurationByUid.put((Object)uid, (Object)result);
        } else if (result.getParent() == null) {
            this.pendingRemoval.remove((Object)result);
        } else {
            ((ComponentBase)result.getParent()).detachByUid(uid);
        }
        return (T)result;
    }

    public void addPendingRemoval(T component) {
        this.pendingRemoval.add(component);
    }

    public void printUidMap() {
        System.out.println("Component tree");
        System.out.print("    ");
        ((ComponentBase)this.getConfiguration()).printConfiguration(1);
        if (this.configurationByUid != null) {
            System.out.println("UIDs");
            this.configurationByUid.forEachEntry(new TObjectObjectProcedure<String, T>(){

                public boolean execute(String a, T b) {
                    System.out.println("    " + a + " (" + ((ComponentBase)b).solverComponentName + ", " + ((ComponentBase)b).componentId + ", " + ((ComponentBase)b).uid + ")");
                    return true;
                }
            });
        }
    }

    public void remove(final Solver solver, T component) {
        if (this.configurationByUid != null) {
            this.configurationByUid.remove((Object)((ComponentBase)component).uid);
        }
        if (((ComponentBase)component).getChildMap() != null) {
            ((ComponentBase)component).getChildMap().forEachValue(new TObjectProcedure<T>(){

                public boolean execute(T child) {
                    MappingBase.this.remove(solver, child);
                    return true;
                }
            });
        }
        if (((ComponentBase)component).componentId > 0) {
            if (!((ComponentBase)component).isComposite()) {
                this.undoContext.saveState(solver, ((ComponentBase)component).componentId, ((ComponentBase)component).uid);
            }
            solver.remove(((ComponentBase)component).componentId);
        }
    }

    public void removePending(final Solver solver) {
        this.pendingRemoval.forEach(new TObjectProcedure<T>(){

            public boolean execute(T component) {
                MappingBase.this.remove(solver, component);
                return true;
            }
        });
        this.pendingRemoval.clear();
    }

    public void setTrustUids(boolean trustUids) {
        if (trustUids != this.trustUids) {
            this.trustUids = trustUids;
            if (trustUids) {
                T configuration = this.getConfiguration();
                if (configuration != null) {
                    this.createConfigurationById(configuration);
                }
            } else {
                this.configurationByUid = null;
            }
        }
    }

    public boolean getTrustUids() {
        return this.trustUids;
    }
}

