/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural.synchronization;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.core.runtime.jobs.Job;
import org.simantics.datatypes.DatatypeResource;
import org.simantics.datatypes.literal.GUID;
import org.simantics.db.Metadata;
import org.simantics.db.MetadataI;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.Indexing;
import org.simantics.db.common.changeset.GenericChangeListener;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.event.ChangeListener;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.ActiveRuns;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.WriteInterface;
import org.simantics.db.service.GraphChangeListenerSupport;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.scl.reflection.OntologyVersions;
import org.simantics.simulation.experiment.IExperiment;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural.synchronization.ContinuousSynchronizationJob;
import org.simantics.structural.synchronization.ObjectIdentitySchedulingRule;
import org.simantics.structural2.genericrelations.ComponentsRelation;
import org.simantics.structural2.genericrelations.StructuralChanges;

public class StructuralChangeListener
extends GenericChangeListener<ComponentsRelation.StructuralChangesRequest, StructuralChanges> {
    public static final boolean DEBUG = true;
    private StructuralResource2 STR;
    private ConcurrentMap<IExperiment, Job> currentSyncJobs = new ConcurrentHashMap<IExperiment, Job>();

    public StructuralChangeListener(ReadGraph graph) {
        this.STR = StructuralResource2.getInstance((ReadGraph)graph);
        GraphChangeListenerSupport support = (GraphChangeListenerSupport)graph.getService(GraphChangeListenerSupport.class);
        support.addMetadataListener((ChangeListener)this);
    }

    public void dispose(Session session) {
        GraphChangeListenerSupport support = (GraphChangeListenerSupport)session.getService(GraphChangeListenerSupport.class);
        support.addMetadataListener((ChangeListener)this);
    }

    public boolean preEventRequest() {
        return !Indexing.isDependenciesIndexingDisabled();
    }

    public static GUID updateSynchronizationState(WriteGraph graph, Resource model) throws DatabaseException {
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        DatatypeResource DATA = DatatypeResource.getInstance((ReadGraph)graph);
        GUID newRevision = GUID.random();
        graph.claimLiteral(model, STR.structuralRevision, DATA.GUID, (Object)newRevision, GUID.BINDING);
        return newRevision;
    }

    public void onEvent(ReadGraph graph, MetadataI metadata, StructuralChanges event) throws DatabaseException {
        if (graph instanceof WriteGraph) {
            WriteGraph w = (WriteGraph)graph;
            w.addMetadata((Metadata)event);
            new Exception("StructuralChange listener event: " + event).printStackTrace();
        } else {
            new Exception("WARNING: StructuralChangeListener received non-WriteGraph event " + event);
        }
        for (final Resource model : event.modelChanges.keySet()) {
            final StructuralChanges.Change[] changes = (StructuralChanges.Change[])event.modelChanges.get(model);
            if (changes == null || changes.length == 0) continue;
            graph.sync((WriteInterface)new WriteRequest(((VirtualGraphSupport)graph.getService(VirtualGraphSupport.class)).getWorkspacePersistent("experiments")){

                boolean isRelevant(ReadGraph graph) throws DatabaseException {
                    String diagramURI = OntologyVersions.getInstance().currentVersion("http://www.simantics.org/Diagram-0.0/Diagram");
                    Resource diagram = graph.getResource(diagramURI);
                    StructuralChanges.Change[] changeArray = changes;
                    int n = changes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        StructuralChanges.Change c = changeArray[n2];
                        if (!(c instanceof StructuralChanges.ComponentModification) || !graph.isInstanceOf(((StructuralChanges.ComponentModification)c).component, diagram)) {
                            return true;
                        }
                        ++n2;
                    }
                    return false;
                }

                public void perform(WriteGraph graph) throws DatabaseException {
                    if (!this.isRelevant((ReadGraph)graph)) {
                        return;
                    }
                    GUID guid = (GUID)graph.getPossibleRelatedValue(model, ((StructuralChangeListener)StructuralChangeListener.this).STR.structuralRevision, GUID.BINDING);
                    if (guid != null && guid.isInvalid()) {
                        return;
                    }
                    StructuralChangeListener.updateSynchronizationState(graph, model);
                }
            });
            Collection runs = (Collection)graph.sync((ReadInterface)new ActiveRuns(model));
            for (Variable run : runs) {
                IExperiment experiment = (IExperiment)run.adapt(graph, IExperiment.class);
                if (experiment != null) {
                    ContinuousSynchronizationJob job = new ContinuousSynchronizationJob(experiment, this.currentSyncJobs);
                    if (this.currentSyncJobs.putIfAbsent(experiment, (Job)job) != null) continue;
                    job.setRule(new ObjectIdentitySchedulingRule(experiment));
                    job.schedule(50L);
                    continue;
                }
                System.err.println("No experiment for active run " + run.getURI(graph));
            }
            if (event.modelChanges.size() == 1) continue;
            System.err.println("There are changes to more than one model. The experiments may now be out of sync!");
        }
    }
}

