/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.debug.ui.internal;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.debug.ui.ResourceSearch;
import org.simantics.debug.ui.SearchResourceDialog;
import org.simantics.ui.workbench.action.ChooseActionRequest;
import org.simantics.utils.Container;
import org.simantics.utils.ui.action.IPriorityAction;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public class SearchResourceHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell = HandlerUtil.getActiveShellChecked((ExecutionEvent)event);
        Session session = Simantics.getSession();
        SearchResourceDialog rld = new SearchResourceDialog(session, false, shell, "Open Resource");
        rld.setResourceFilter(ResourceSearch.FILTER_RELATIONS);
        rld.setBlockOnOpen(true);
        rld.open();
        if (rld.getResult() == null) {
            return null;
        }
        String currentPerspectiveId = WorkbenchUtils.getCurrentPerspectiveId();
        Object[] objectArray = rld.getResult();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            Container rc = (Container)o;
            this.openPreferredEditor(session, (Resource)rc.get(), currentPerspectiveId);
            ++n2;
        }
        return null;
    }

    void openPreferredEditor(Session s, final Resource r, final String defaultPerspective) {
        s.asyncRequest((Read)new ReadRequest(){
            String resourceName;
            IPriorityAction[] actions;

            public void run(ReadGraph g) throws DatabaseException {
                this.resourceName = NameUtils.getSafeName((ReadGraph)g, (Resource)r);
                this.actions = ChooseActionRequest.findActions((ReadGraph)g, (Resource)r, (String)defaultPerspective);
                if (this.actions == null) {
                    return;
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IAction action = ChooseActionRequest.chooseAction(null, (IPriorityAction[])actions, (String)resourceName);
                        if (action == null) {
                            return;
                        }
                        action.run();
                    }
                });
            }
        });
    }
}

