/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.debug.ui.graph;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.Statement;
import org.simantics.db.common.uri.ResourceToPossibleURI;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ValidationException;
import org.simantics.db.request.Read;
import org.simantics.db.service.ClusteringSupport;
import org.simantics.debug.ui.GraphDebugger;
import org.simantics.debug.ui.internal.HashMultiMap;
import org.simantics.graphviz.Edge;
import org.simantics.graphviz.Graph;
import org.simantics.graphviz.IGraph;
import org.simantics.graphviz.IGraphPart;
import org.simantics.graphviz.Identifiable;
import org.simantics.graphviz.Node;
import org.simantics.graphviz.drawable.ViewerCanvas;
import org.simantics.graphviz.ui.GraphvizComponent2;
import org.simantics.layer0.Layer0;
import org.simantics.utils.datastructures.BijectionMap;
import org.simantics.utils.datastructures.MapList;
import org.simantics.utils.ui.ErrorLogger;

public class GraphicalDebugger
extends GraphDebugger {
    private Graph graph;
    private BijectionMap<Resource, Node> nodeMap = new BijectionMap();
    private MapList<Resource, Edge> edgeMap = new MapList();
    private Map<Edge, Resource> edgeMap2 = new HashMap<Edge, Resource>();
    private Set<Resource> processed = new HashSet<Resource>();
    private GraphvizComponent2 graphVizComponent;
    private int depth = 1;
    private Style style = Style.dot;

    public GraphicalDebugger(Composite parent, int style, Session session, Resource resource) {
        super(parent, style, session, resource);
    }

    @Override
    public void defaultInitializeUI() {
        this.setLayout((Layout)new GridLayout(2, false));
        this.setLayoutData(new GridData(4, 4, true, true));
        this.createResourceText(this);
        this.createDropLabel(this);
        this.createGraph(this);
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        if (depth < 1) {
            return;
        }
        if (depth == this.depth) {
            return;
        }
        this.depth = depth;
        this.refreshBrowser();
    }

    public Style getGraphStyle() {
        return this.style;
    }

    public void setGraphStyle(Style style) {
        if (this.style == style) {
            return;
        }
        this.style = style;
        this.refreshBrowser();
    }

    @Override
    protected void initializeCSS() {
    }

    @Override
    public Browser createBrowser(Composite parent) {
        return null;
    }

    public GraphvizComponent2 createGraph(Composite parent) {
        this.graph = new Graph();
        this.graph.setRankdir("LR");
        this.graphVizComponent = new GraphvizComponent2(parent, 0);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GraphicalDebugger.this.graphVizComponent.getCanvas().addMouseListener(new MouseListener(){

                    @Override
                    public void mouseReleased(MouseEvent arg0) {
                    }

                    @Override
                    public void mousePressed(MouseEvent arg0) {
                    }

                    @Override
                    public void mouseExited(MouseEvent arg0) {
                    }

                    @Override
                    public void mouseEntered(MouseEvent arg0) {
                    }

                    @Override
                    public void mouseClicked(MouseEvent arg0) {
                        if (arg0.getClickCount() > 1) {
                            Point p = arg0.getPoint();
                            GraphicalDebugger.this.pick(p);
                        }
                    }
                });
            }
        });
        GridDataFactory.fillDefaults().span(2, 1).grab(true, true).applyTo((Control)this.graphVizComponent);
        this.refreshBrowser();
        return this.graphVizComponent;
    }

    protected void pick(Point p) {
        Resource r;
        AffineTransform at = ((ViewerCanvas)this.graphVizComponent.getCanvas()).getTransform();
        Point2D.Double pickPoint = new Point2D.Double();
        try {
            at.inverseTransform(new Point2D.Double(p.x, p.y), pickPoint);
        }
        catch (NoninvertibleTransformException e) {
            return;
        }
        Collection parts = this.graphVizComponent.getDrawable().pick((Point2D)pickPoint);
        for (IGraphPart part : parts) {
            if (!(part instanceof Node) || (r = (Resource)this.nodeMap.getLeft((Object)((Node)part))) == null || r.equals(this.getDebuggerLocation())) continue;
            this.changeLocation(r);
            return;
        }
        for (IGraphPart part : parts) {
            if (!(part instanceof Edge) || (r = this.edgeMap2.get(part)) == null || r.equals(this.getDebuggerLocation())) continue;
            this.changeLocation(r);
            return;
        }
    }

    protected Node getOrCreate(Resource r) {
        Node n = (Node)this.nodeMap.getRight((Object)r);
        if (n == null) {
            n = new Node((IGraph)this.graph);
            if (!r.isPersistent()) {
                n.setShape("box");
                n.setFontColor("blue");
            }
            this.nodeMap.map((Object)r, (Object)n);
        }
        return n;
    }

    protected void appendLabel(Node node, String text) {
        String label = node.get("label");
        if (label == null || label.length() == 0) {
            label = text;
        } else {
            label = label.substring(1, label.length() - 1);
            label = String.valueOf(label) + "<br/>" + text;
        }
        label = "<" + label + ">";
        node.setLabel(label);
    }

    @Override
    protected synchronized void updateContent(ReadGraph g, Resource ... resources) throws DatabaseException {
        this.L0 = Layer0.getInstance((ReadGraph)g);
        this.graph = new Graph();
        this.graph.setRankdir("LR");
        this.nodeMap.clear();
        this.edgeMap.clear();
        this.edgeMap2.clear();
        this.processed.clear();
        this.createContent(g, this.depth, resources);
        this.graphVizComponent.setGraph(this.graph, this.style.toString());
    }

    private void createContent(ReadGraph g, int iter, Resource ... resources) throws DatabaseException {
        if (iter == 0) {
            return;
        }
        Resource[] resourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            Resource r = resourceArray[n2];
            if (r != null && !this.processed.contains(r)) {
                Node node = this.getResourceRef(g, r);
                if (r.equals(this.getDebuggerLocation())) {
                    node.setFillColor("#aaffaa");
                    node.setStyle("filled");
                }
                this.processed.add(r);
                String uri = null;
                try {
                    uri = (String)g.syncRequest((Read)new ResourceToPossibleURI(r));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    uri = "Cannot get URI: " + e.getMessage();
                }
                if (uri != null) {
                    this.appendLabel(node, "URI: " + uri);
                }
                Collection statements = g.getStatements(r, this.L0.IsWeaklyRelatedTo);
                HashMultiMap<Resource, Resource[]> map = new HashMultiMap<Resource, Resource[]>();
                for (Statement statement : statements) {
                    Resource predicate = null;
                    Object subject = null;
                    Resource obj = null;
                    try {
                        predicate = statement.getPredicate();
                        subject = statement.getSubject();
                        obj = statement.getObject();
                        map.add(predicate, new Resource[]{subject, obj});
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        ErrorLogger.defaultLogError((String)("Cannot find statement " + subject + " " + predicate + " " + obj), (Throwable)e);
                    }
                }
                ClusteringSupport support = (ClusteringSupport)g.getSession().getService(ClusteringSupport.class);
                this.appendLabel(node, " [" + r.getResourceId() + "-" + support.getCluster(r) + "]");
                boolean isOrderedSet = g.isInstanceOf(r, this.L0.OrderedSet);
                map.remove(r);
                Resource[] e = new Resource[]{this.L0.HasName, this.L0.InstanceOf, this.L0.Inherits, this.L0.SubrelationOf, this.L0.ConsistsOf, this.L0.PartOf};
                int obj = e.length;
                int subject = 0;
                while (subject < obj) {
                    Resource pred = e[subject];
                    if (map.containsKey(pred)) {
                        this.updatePred(node, g, r, pred, (List)map.remove(pred));
                    }
                    ++subject;
                }
                for (Statement stm : statements) {
                    if (!stm.getSubject().equals(stm.getObject())) continue;
                    this.updateTag(node, g, r, stm.getPredicate(), "Tag");
                    map.remove(stm.getPredicate());
                }
                for (Statement stm : statements) {
                    Resource inverse;
                    Resource predicate = stm.getPredicate();
                    if (g.isInstanceOf(stm.getPredicate(), this.L0.OrderedSet)) {
                        this.updateTag(node, g, r, stm.getPredicate(), "Ordered Set");
                        map.remove(stm.getPredicate());
                    }
                    if ((inverse = g.getPossibleInverse(predicate)) == null || !g.isInstanceOf(inverse, this.L0.OrderedSet)) continue;
                    map.remove(stm.getPredicate());
                }
                if (isOrderedSet) {
                    try {
                        this.updateOrderedSet(node, g, r);
                    }
                    catch (ValidationException stm) {
                        // empty catch block
                    }
                }
                Resource[] preds = map.keySet().toArray(new Resource[0]);
                final HashMap<Resource, String> strmap = new HashMap<Resource, String>(preds.length);
                Object object = preds;
                int n3 = preds.length;
                int inverse = 0;
                while (inverse < n3) {
                    Resource pred = object[inverse];
                    String str = GraphicalDebugger.htmlEscape(this.getResourceName(g, pred));
                    if (str == null) {
                        str = "<null>";
                    }
                    strmap.put(pred, str);
                    ++inverse;
                }
                Arrays.sort(preds, new Comparator<Resource>(){

                    @Override
                    public int compare(Resource o1, Resource o2) {
                        return ((String)strmap.get(o1)).compareTo((String)strmap.get(o2));
                    }
                });
                object = preds;
                n3 = preds.length;
                inverse = 0;
                while (inverse < n3) {
                    Resource pred = object[inverse];
                    if (g.isSubrelationOf(pred, this.L0.IsRelatedTo)) {
                        this.updatePred(node, g, r, pred, (List)map.get(pred));
                    }
                    ++inverse;
                }
                object = preds;
                n3 = preds.length;
                inverse = 0;
                while (inverse < n3) {
                    Resource pred = object[inverse];
                    if (!g.isSubrelationOf(pred, this.L0.IsRelatedTo)) {
                        this.updatePred(node, g, r, pred, (List)map.get(pred));
                    }
                    ++inverse;
                }
                Resource[] objects = new Resource[statements.size()];
                int i = 0;
                for (Statement stm : statements) {
                    objects[i] = stm.getObject();
                    ++i;
                }
                this.createContent(g, iter - 1, objects);
            }
            ++n2;
        }
    }

    private Node getResourceRef(ReadGraph graph, Resource r) throws DatabaseException {
        Node node = (Node)this.nodeMap.getRight((Object)r);
        if (node == null) {
            node = this.getOrCreate(r);
            this.appendLabel(node, GraphicalDebugger.htmlEscape(this.getResourceName(graph, r)));
        }
        return node;
    }

    private void updatePred(Node node, ReadGraph graph, Resource subj, Resource pred, List<Resource[]> stats) throws DatabaseException {
        NodeObject[] objects = new NodeObject[stats.size()];
        int i = 0;
        while (i < stats.size()) {
            Resource stmSubject = stats.get(i)[0];
            Resource object = stats.get(i)[1];
            objects[i] = new NodeObject();
            objects[i].r = object;
            objects[i].name = GraphicalDebugger.htmlEscape(this.getResourceName(graph, object));
            objects[i].node = this.getResourceRef(graph, object);
            if (!stmSubject.equals(subj)) {
                Node asserted = this.getResourceRef(graph, stmSubject);
                Edge e = new Edge((IGraph)this.graph, (Identifiable)objects[i].node, (Identifiable)asserted);
                e.setLabel("Asserted in");
                objects[i].node.setFillColor("#ffaaaa");
                objects[i].node.setStyle("filled");
            }
            ++i;
        }
        Arrays.sort(objects, new Comparator<NodeObject>(){

            @Override
            public int compare(NodeObject o1, NodeObject o2) {
                return o1.name.compareTo(o2.name);
            }
        });
        String predName = this.getResourceName(graph, pred);
        int i2 = 0;
        while (i2 < objects.length) {
            Edge e = new Edge((IGraph)this.graph, (Identifiable)node, (Identifiable)objects[i2].node);
            e.setLabel(predName);
            this.edgeMap.add((Object)pred, (Object)e);
            this.edgeMap2.put(e, pred);
            ++i2;
        }
    }

    private void updateTag(Node node, ReadGraph graph, Resource subj, Resource tag, String title) throws DatabaseException {
        Node ref = this.getResourceRef(graph, tag);
        Edge e = new Edge((IGraph)this.graph, (Identifiable)node, (Identifiable)ref);
        e.setLabel(title);
    }

    private void updateOrderedSet(Node node, ReadGraph graph, Resource subj) throws DatabaseException {
        ArrayList<Node> list = new ArrayList<Node>();
        Resource cur = subj;
        while (true) {
            try {
                cur = OrderedSetUtils.next((ReadGraph)graph, (Resource)subj, (Resource)cur);
            }
            catch (DatabaseException e) {
                Edge edge = new Edge((IGraph)this.graph, (Identifiable)node, (Identifiable)node);
                edge.setLabel("Broken Ordered Set");
            }
            if (cur.equals(subj)) break;
            list.add(this.getResourceRef(graph, cur));
        }
        int i = 0;
        while (i < list.size()) {
            Edge e = new Edge((IGraph)this.graph, (Identifiable)node, (Identifiable)list.get(i));
            e.setLabel("Oredered set item " + i);
            ++i;
        }
    }

    private class NodeObject {
        public String name;
        public Node node;
        public Resource r;

        private NodeObject() {
        }
    }

    public static enum Style {
        dot,
        neato,
        fdp,
        sfdp,
        twopi,
        circo;

    }
}

