/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.debug.ui;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Array;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.Bundle;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.util.ObjectUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.ResourceArray;
import org.simantics.db.common.procedure.adapter.DisposableListener;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.db.layer0.request.PossibleURI;
import org.simantics.db.layer0.request.ResourceURIToVariable;
import org.simantics.db.layer0.request.VariableURI;
import org.simantics.db.layer0.variable.AbstractChildVariable;
import org.simantics.db.layer0.variable.AbstractPropertyVariable;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableNode;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.debug.ui.internal.Activator;
import org.simantics.layer0.Layer0;
import org.simantics.structural2.variables.Connection;
import org.simantics.ui.dnd.LocalObjectTransfer;
import org.simantics.ui.dnd.ResourceReferenceTransfer;
import org.simantics.ui.dnd.ResourceTransferUtils;
import org.simantics.ui.utils.ResourceAdaptionUtils;
import org.simantics.utils.FileUtils;
import org.simantics.utils.bytes.Base64;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.ISelectionUtils;
import org.simantics.utils.ui.PathUtils;

public class VariableDebugger
extends Composite {
    private static final String DEFAULT_DEBUGGER_CSS_FILE = "debugger.css";
    private static final String DEFAULT_DEBUGGER_CSS_PATH = "css/debugger.css";
    private static int RESOURCE_NAME_MAX_LENGTH = 1000;
    private final Charset utf8 = Charset.forName("UTF-8");
    private final LocalResourceManager resourceManager;
    private String cssPath;
    private Text updateTriggerCounter;
    private Browser browser;
    private final ColorDescriptor green = ColorDescriptor.createFrom((RGB)new RGB(87, 188, 149));
    private final LinkedList<String> backHistory = new LinkedList();
    private final LinkedList<String> forwardHistory = new LinkedList();
    private String currentElement = null;
    private final Session session;
    private final CopyOnWriteArrayList<HistoryListener> historyListeners = new CopyOnWriteArrayList();
    protected Layer0 L0;
    protected boolean disposed;
    private PageContentListener pageContentListener;

    public VariableDebugger(Composite parent, int style, Session session, String initialURI) {
        super(parent, style);
        Assert.isNotNull((Object)session, (String)"session is null");
        this.session = session;
        this.currentElement = initialURI;
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        this.initializeCSS();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                VariableDebugger.this.disposed = true;
                PageContentListener l = VariableDebugger.this.pageContentListener;
                if (l != null) {
                    l.dispose();
                }
            }
        });
    }

    public void defaultInitializeUI() {
        this.setLayout((Layout)new GridLayout(4, false));
        this.setLayoutData(new GridData(4, 4, true, true));
        this.createDropLabel(this);
        this.createResourceText(this);
        this.createUpdateTriggerCounter(this);
        Browser browser = this.createBrowser(this);
        GridDataFactory.fillDefaults().span(4, 1).grab(true, true).applyTo((Control)browser);
    }

    protected void initializeCSS() {
        try {
            IPath absolutePath = PathUtils.getAbsolutePath((String)"org.simantics.debug.ui", (String)DEFAULT_DEBUGGER_CSS_PATH);
            if (absolutePath != null) {
                this.cssPath = absolutePath.toFile().toURI().toString();
            } else {
                File tempDir = FileUtils.getOrCreateTemporaryDirectory((boolean)false, (String[])new String[0]);
                File css = new File(tempDir, DEFAULT_DEBUGGER_CSS_FILE);
                if (!css.exists()) {
                    URL url = FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path(DEFAULT_DEBUGGER_CSS_PATH), null);
                    if (url == null) {
                        throw new FileNotFoundException("Could not find 'css/debugger.css' in bundle 'org.simantics.debug.ui'");
                    }
                    this.cssPath = FileUtils.copyResource((URL)url, (File)css, (boolean)true).toURI().toString();
                } else {
                    this.cssPath = css.toURI().toString();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            ErrorLogger.defaultLogWarning((Throwable)e);
        }
    }

    public Label createDropLabel(Composite parent) {
        final Label label = new Label(parent, 0x800800);
        label.setAlignment(0x1000000);
        label.setText("  Drag a resource or a variable here to examine it in this debugger!  ");
        label.setForeground(parent.getDisplay().getSystemColor(16));
        GridData data = new GridData(16384, 4, false, false);
        label.setLayoutData((Object)data);
        DropTarget dropTarget = new DropTarget((Control)label, 5);
        dropTarget.setTransfer(new Transfer[]{TextTransfer.getInstance(), ResourceReferenceTransfer.getInstance(), LocalObjectTransfer.getTransfer()});
        dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event) {
                event.detail = 4;
                label.setBackground((Color)VariableDebugger.this.resourceManager.get((DeviceResourceDescriptor)VariableDebugger.this.green));
            }

            public void dragLeave(DropTargetEvent event) {
                label.setBackground(null);
            }

            public void drop(DropTargetEvent event) {
                label.setBackground(null);
                try {
                    String uri = this.parseUri(event);
                    if (uri == null) {
                        event.detail = 0;
                        return;
                    }
                    VariableDebugger.this.changeLocation(uri);
                }
                catch (DatabaseException e) {
                    Logger.defaultLogError((Throwable)e);
                }
            }

            private String parseUri(DropTargetEvent event) throws DatabaseException {
                String uri;
                Variable v = this.parseVariable(event);
                String string = uri = v != null ? (String)VariableDebugger.this.session.sync((ReadInterface)new VariableURI(v)) : null;
                if (uri == null) {
                    Resource r = this.parseResource(event);
                    uri = r != null ? (String)VariableDebugger.this.session.sync((ReadInterface)new PossibleURI(r)) : null;
                }
                return uri;
            }

            private Variable parseVariable(DropTargetEvent event) {
                return (Variable)ISelectionUtils.getSinglePossibleKey((Object)event.data, (IHintContext.Key)SelectionHints.KEY_MAIN, Variable.class);
            }

            private Resource parseResource(DropTargetEvent event) throws DatabaseException {
                ResourceArray[] ra = null;
                if (event.data instanceof String) {
                    try {
                        SerialisationSupport support = (SerialisationSupport)VariableDebugger.this.session.getService(SerialisationSupport.class);
                        ra = ResourceTransferUtils.readStringTransferable((SerialisationSupport)support, (String)((String)event.data)).toResourceArrayArray();
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    catch (DatabaseException e) {
                        e.printStackTrace();
                    }
                } else {
                    ra = ResourceAdaptionUtils.toResourceArrays((Object)event.data);
                }
                if (ra != null && ra.length > 0) {
                    return ra[0].resources[ra[0].resources.length - 1];
                }
                return null;
            }
        });
        return label;
    }

    public void createResourceText(Composite parent) {
        final Text text = new Text(parent, 2048);
        GridData data = new GridData(4, 4, true, false);
        text.setLayoutData((Object)data);
        Button button = new Button(parent, 0);
        button.setText("Lookup");
        GridData data2 = new GridData(4, 4, false, false);
        button.setLayoutData((Object)data2);
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                try {
                    String uri = text.getText();
                    VariableDebugger.this.session.sync((ReadInterface)new ResourceURIToVariable(uri));
                    VariableDebugger.this.changeLocation(uri);
                }
                catch (DatabaseException e1) {
                    Logger.defaultLogError((Throwable)e1);
                }
            }
        });
    }

    protected Text createUpdateTriggerCounter(Composite parent) {
        Text label = new Text(parent, 0x800800);
        label.setEditable(false);
        label.setToolTipText("Amount of Screen/Listener Updates Received for Shown Variable");
        GridDataFactory.fillDefaults().align(4, 4).grab(false, false).hint(32, -1).applyTo((Control)label);
        this.updateTriggerCounter = label;
        return label;
    }

    public Browser createBrowser(Composite parent) {
        try {
            this.browser = new Browser(parent, 32768);
        }
        catch (SWTError e) {
            this.browser = new Browser(parent, 0);
        }
        this.browser.setLayoutData((Object)new GridData(4, 4, true, true));
        this.browser.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if ((e.stateMask & 0x10000) != 0) {
                    if (e.keyCode == 0x1000004) {
                        VariableDebugger.this.forward();
                    }
                    if (e.keyCode == 0x1000003) {
                        VariableDebugger.this.back();
                    }
                }
            }
        });
        this.browser.addLocationListener((LocationListener)new LocationAdapter(){

            public void changing(LocationEvent event) {
                String location = event.location;
                if (location.startsWith("simantics:browser")) {
                    location = "about:" + location.substring(17);
                }
                event.doit = false;
                if ("about:blank".equals(location)) {
                    event.doit = true;
                }
                if (location.startsWith("about:-link")) {
                    String target = location.replace("about:-link", "");
                    try {
                        byte[] bytes = Base64.decode((String)target);
                        String url = new String(bytes, VariableDebugger.this.utf8);
                        if (url.equals(VariableDebugger.this.currentElement)) {
                            event.doit = false;
                            return;
                        }
                        VariableDebugger.this.changeLocation(url);
                    }
                    catch (IOException e) {
                        ErrorLogger.defaultLogError((Throwable)e);
                    }
                } else if (!location.startsWith("about:-remove")) {
                    location.startsWith("about:-edit-value");
                }
            }
        });
        this.refreshBrowser();
        return this.browser;
    }

    public void refreshBrowser() {
        if (this.currentElement == null) {
            return;
        }
        if (this.pageContentListener != null) {
            this.pageContentListener.dispose();
        }
        this.pageContentListener = new PageContentListener();
        this.session.asyncRequest((Read)new UnaryRead<String, String>(this.currentElement){

            public String perform(ReadGraph graph) throws DatabaseException {
                String content = VariableDebugger.this.calculateContent(graph, (String)this.parameter);
                return content;
            }
        }, (Listener)this.pageContentListener);
    }

    public String getDebuggerLocation() {
        return this.currentElement;
    }

    public void changeLocation(String url) {
        if (this.currentElement != null) {
            this.backHistory.addLast(this.currentElement);
        }
        this.currentElement = url;
        this.forwardHistory.clear();
        this.refreshBrowser();
        this.fireHistoryChanged();
    }

    public void addHistoryListener(HistoryListener l) {
        this.historyListeners.add(l);
    }

    public void removeHistoryListener(HistoryListener l) {
        this.historyListeners.remove(l);
    }

    private void fireHistoryChanged() {
        for (HistoryListener l : this.historyListeners) {
            l.historyChanged();
        }
    }

    public boolean hasBackHistory() {
        return this.backHistory.isEmpty();
    }

    public boolean hasForwardHistory() {
        return this.forwardHistory.isEmpty();
    }

    public void back() {
        if (this.backHistory.isEmpty()) {
            return;
        }
        this.forwardHistory.addFirst(this.currentElement);
        this.currentElement = this.backHistory.removeLast();
        this.refreshBrowser();
        this.fireHistoryChanged();
    }

    public void forward() {
        if (this.forwardHistory.isEmpty()) {
            return;
        }
        this.backHistory.addLast(this.currentElement);
        this.currentElement = this.forwardHistory.removeFirst();
        this.refreshBrowser();
        this.fireHistoryChanged();
    }

    protected String toName(Object o) {
        Class<?> clazz = o.getClass();
        if (clazz.isArray()) {
            int length = Array.getLength(o);
            if (length > RESOURCE_NAME_MAX_LENGTH) {
                if (o instanceof byte[]) {
                    byte[] arr = (byte[])o;
                    byte[] arr2 = Arrays.copyOf(arr, RESOURCE_NAME_MAX_LENGTH);
                    return this.truncated("byte", Arrays.toString(arr2), arr.length);
                }
                if (o instanceof int[]) {
                    int[] arr = (int[])o;
                    int[] arr2 = Arrays.copyOf(arr, RESOURCE_NAME_MAX_LENGTH);
                    return this.truncated("int", Arrays.toString(arr2), arr.length);
                }
                if (o instanceof long[]) {
                    long[] arr = (long[])o;
                    long[] arr2 = Arrays.copyOf(arr, RESOURCE_NAME_MAX_LENGTH);
                    return this.truncated("long", Arrays.toString(arr2), arr.length);
                }
                if (o instanceof float[]) {
                    float[] arr = (float[])o;
                    float[] arr2 = Arrays.copyOf(arr, RESOURCE_NAME_MAX_LENGTH);
                    return this.truncated("float", Arrays.toString(arr2), arr.length);
                }
                if (o instanceof double[]) {
                    double[] arr = (double[])o;
                    double[] arr2 = Arrays.copyOf(arr, RESOURCE_NAME_MAX_LENGTH);
                    return this.truncated("double", Arrays.toString(arr2), arr.length);
                }
                if (o instanceof boolean[]) {
                    boolean[] arr = (boolean[])o;
                    boolean[] arr2 = Arrays.copyOf(arr, RESOURCE_NAME_MAX_LENGTH);
                    return this.truncated("boolean", Arrays.toString(arr2), arr.length);
                }
                if (o instanceof Object[]) {
                    Object[] arr = (Object[])o;
                    Object[] arr2 = Arrays.copyOf(arr, RESOURCE_NAME_MAX_LENGTH);
                    return this.truncated("Object", Arrays.toString(arr2), arr.length);
                }
                return "Unknown big array " + o.getClass();
            }
            return o.getClass().getComponentType() + "[" + length + "] = " + ObjectUtils.toString((Object)o);
        }
        return null;
    }

    protected String truncated(String type, String string, int originalLength) {
        return String.valueOf(type) + "[" + RESOURCE_NAME_MAX_LENGTH + "/" + originalLength + "] = " + string;
    }

    protected String getVariableName(ReadGraph graph, Variable r) {
        try {
            return r.getName(graph);
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    protected String getValue(ReadGraph graph, Object o) throws DatabaseException {
        Class<?> clazz = o.getClass();
        if (o instanceof Connection) {
            Connection c = (Connection)o;
            ArrayList<String> result = new ArrayList<String>();
            for (Variable v : c.getConnectionPoints(graph)) {
                result.add(v.getURI(graph));
            }
            return "conn " + o.getClass().getName() + " " + result.toString();
        }
        if (clazz.isArray()) {
            if (int[].class == clazz) {
                return Arrays.toString((int[])o);
            }
            if (float[].class == clazz) {
                return Arrays.toString((float[])o);
            }
            if (double[].class == clazz) {
                return Arrays.toString((double[])o);
            }
            if (long[].class == clazz) {
                return Arrays.toString((long[])o);
            }
            if (byte[].class == clazz) {
                return Arrays.toString((byte[])o);
            }
            if (boolean[].class == clazz) {
                return Arrays.toString((boolean[])o);
            }
            if (char[].class == clazz) {
                return Arrays.toString((char[])o);
            }
            return Arrays.toString((Object[])o);
        }
        return o.toString();
    }

    protected String getValue(ReadGraph graph, Variable r) {
        try {
            Object value = r.getValue(graph);
            if (value instanceof Resource) {
                return this.getResourceRef(graph, (Resource)value);
            }
            if (value instanceof Variable) {
                return this.getVariableRef(graph, (Variable)value);
            }
            return value != null ? this.getValue(graph, value) : "null";
        }
        catch (Throwable e) {
            try {
                Logger.defaultLogError((String)("getValue " + r.getURI(graph)), (Throwable)e);
            }
            catch (DatabaseException e1) {
                Logger.defaultLogError((Throwable)e1);
            }
            return e.getMessage();
        }
    }

    protected String getDatatype(ReadGraph graph, Variable r) {
        try {
            Datatype dt = (Datatype)r.getPossiblePropertyValue(graph, "DATATYPE");
            return dt != null ? dt.toSingleLineString() : "undefined";
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    private String getResourceRef(ReadGraph graph, Resource r) throws DatabaseException {
        return this.getVariableRef(graph, (Variable)graph.adapt(r, Variable.class));
    }

    private String getVariableRef(ReadGraph graph, Variable r) throws DatabaseException {
        String ret = "<a href=\"simantics:browser-link" + this.getLinkString(graph, r) + "\">" + this.getVariableName(graph, r) + "</a>";
        return ret;
    }

    private String getLinkString(ReadGraph graph, Variable t) throws DatabaseException {
        try {
            String uri = t.getURI(graph);
            String encoded = Base64.encode((byte[])uri.getBytes(this.utf8));
            return encoded;
        }
        catch (Exception e) {
            Logger.defaultLogError((Throwable)e);
            return e.getMessage();
        }
    }

    private void updateProperty(StringBuilder content, ReadGraph graph, Variable property) throws DatabaseException {
        content.append("<tr>");
        content.append("<td>" + this.getVariableRef(graph, property) + "</td>");
        content.append("<td>" + this.getValue(graph, property) + "</td>");
        content.append("<td>" + this.getDatatype(graph, property) + "</td>");
        content.append("</tr>");
    }

    protected String getRVIString(ReadGraph graph, Variable var) throws DatabaseException {
        try {
            return var.getRVI(graph).toString(graph);
        }
        catch (Throwable e) {
            return "No RVI";
        }
    }

    protected synchronized String calculateContent(ReadGraph graph, String ... uris) throws DatabaseException {
        this.L0 = Layer0.getInstance((ReadGraph)graph);
        StringBuilder content = new StringBuilder();
        content.append("<html><head>" + this.getHead() + "</head>\n");
        content.append("<body>\n");
        content.append("<div id=\"mainContent\">\n");
        String[] stringArray = uris;
        int n = uris.length;
        int n2 = 0;
        while (n2 < n) {
            String uri = stringArray[n2];
            Variable var = Variables.getPossibleVariable((ReadGraph)graph, (String)uri);
            if (var != null) {
                VariableNode vn;
                String rviString = this.getRVIString(graph, var);
                Object node = null;
                if (var instanceof AbstractChildVariable && (vn = ((AbstractChildVariable)var).node) != null) {
                    node = vn.node;
                }
                if (var instanceof AbstractPropertyVariable && (vn = ((AbstractPropertyVariable)var).node) != null) {
                    node = vn.node;
                }
                content.append("<div id=\"top\">\n");
                content.append("<table class=\"top\">\n");
                content.append("<tr><td class=\"top_key\">URI</td><td class=\"top_value\"><span id=\"uri\">" + uri + "</span></td></tr>\n");
                content.append("<tr><td class=\"top_key\">RVI</td><td class=\"top_value\"><span id=\"uri\">" + rviString + "</span></td></tr>\n");
                content.append("<tr><td class=\"top_key\">Class</td><td class=\"top_value\"><span id=\"class\">" + var.getClass().getCanonicalName() + "</span></td></tr>\n");
                content.append("<tr><td class=\"top_key\">Solver node</td><td class=\"top_value\"><span id=\"class\">" + node + "</span></td></tr>\n");
                content.append("</table>\n");
                content.append("</div>\n");
                TreeMap<String, Variable> map = new TreeMap<String, Variable>();
                try {
                    for (Variable child : var.getChildren(graph)) {
                        String name = this.getVariableName(graph, child);
                        map.put(name, child);
                    }
                }
                catch (DatabaseException e) {
                    ErrorLogger.defaultLogError((String)"Broken variable child retrieval implementation or serious modelling error encountered. See exception for details.", (Throwable)e);
                }
                TreeMap<String, Variable> map2 = new TreeMap<String, Variable>();
                try {
                    for (Variable child : var.getProperties(graph)) {
                        String name = this.getVariableName(graph, child);
                        map2.put(name, child);
                    }
                }
                catch (DatabaseException e) {
                    ErrorLogger.defaultLogError((String)"Broken variable property retrieval implementation or serious modelling error encountered. See exception for details.", (Throwable)e);
                }
                content.append("\n<div id=\"data\">\n");
                content.append("<table>\n");
                content.append("<tr><th>Child</th></tr>");
                for (Variable child : map.values()) {
                    content.append("<tr><td>" + this.getVariableRef(graph, child) + "</td></tr>");
                }
                content.append("<tr><th>Property</th><th>Value</th><th>Datatype</th></tr>");
                for (Variable property : map2.values()) {
                    this.updateProperty(content, graph, property);
                }
                content.append("</div>\n\n");
            }
            ++n2;
        }
        content.append("</div>\n");
        content.append("</body></html>\n");
        return content.toString();
    }

    private String getHead() {
        String result = "";
        if (this.cssPath != null) {
            result = "<link href=\"" + this.cssPath + "\" rel=\"stylesheet\" type=\"text/css\">";
        }
        return result;
    }

    public static interface HistoryListener {
        public void historyChanged();
    }

    class PageContentListener
    extends DisposableListener<String> {
        int triggerCounter;
        int updateCount;
        AtomicReference<String> lastResult = new AtomicReference();

        PageContentListener() {
        }

        public void execute(String content) {
            ++this.triggerCounter;
            if (this.lastResult.getAndSet(content) == null && !VariableDebugger.this.disposed) {
                VariableDebugger.this.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        String content = PageContentListener.this.lastResult.getAndSet(null);
                        if (content == null) {
                            return;
                        }
                        ++PageContentListener.this.updateCount;
                        if (!VariableDebugger.this.browser.isDisposed()) {
                            VariableDebugger.this.browser.setText(content);
                        }
                        if (!VariableDebugger.this.updateTriggerCounter.isDisposed()) {
                            VariableDebugger.this.updateTriggerCounter.setText(String.valueOf(PageContentListener.this.updateCount) + "/" + PageContentListener.this.triggerCounter);
                        }
                    }
                });
            }
        }

        public void exception(Throwable t) {
            Logger.defaultLogError((Throwable)t);
        }
    }
}

