/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.debug.ui;

import java.net.URL;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.Simantics;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.CancelTransactionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Write;
import org.simantics.db.service.DebugSupport;
import org.simantics.debug.ui.SessionDebugger;
import org.simantics.ui.workbench.IPropertyPage;
import org.simantics.utils.ui.LayoutUtils;
import org.simantics.views.swt.SimanticsView;
import org.simantics.wiki.ui.browser.BrowserComponent;
import org.simantics.wiki.ui.editor.NavigationHandler;

public class SessionDebuggerView
extends SimanticsView
implements NavigationHandler {
    public static final String VIEW_ID = "org.simantics.debug.sessionDebugger";
    private CTabFolder folder;

    protected Set<String> getBrowseContexts() {
        return Collections.singleton("");
    }

    private CTabItem createItem(int index, CTabFolder folder, Control control) {
        CTabItem item = new CTabItem(folder, 0, index);
        item.setControl(control);
        return item;
    }

    protected void createControls(Composite body, IWorkbenchSite site, ISessionContext context, WidgetSupport support) {
        body.setLayout((Layout)LayoutUtils.createNoBorderGridLayout((int)1));
        this.folder = new CTabFolder(body, 0x800400);
        this.folder.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite shell = new Composite((Composite)this.folder, 0);
        shell.setLayout((Layout)LayoutUtils.createNoBorderGridLayout((int)1));
        final Text commandLine = new Text(shell, 2048);
        commandLine.setLayoutData((Object)new GridData(4, 4, true, false));
        final BrowserComponent browser = new BrowserComponent(shell, 2048, (NavigationHandler)this);
        browser.syncPopulate();
        Logger.getLogger("org.lobobrowser").setLevel(Level.OFF);
        Logger.getLogger("com.steadystate").setLevel(Level.OFF);
        browser.setLayoutData((Object)new GridData(4, 4, true, true));
        final LinkedList terminal = new LinkedList();
        final LinkedList history = new LinkedList();
        commandLine.addKeyListener(new KeyListener(){
            private int historyPosition = -1;

            public void apply(final String command, final Object data) {
                if (data instanceof String) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            commandLine.setText("");
                            terminal.addFirst((String)data);
                            if (terminal.size() > 10) {
                                terminal.removeLast();
                            }
                            history.addFirst(command);
                            if (history.size() > 10) {
                                history.removeLast();
                            }
                            historyPosition = 0;
                            StringBuilder b = new StringBuilder();
                            for (String s : terminal) {
                                b.append(String.valueOf(s) + "<br />");
                            }
                            browser.setText(b.toString());
                        }
                    });
                }
            }

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 0x1000001) {
                    if (this.historyPosition > 10 || this.historyPosition >= history.size() - 1) {
                        return;
                    }
                    commandLine.setText((String)history.get(++this.historyPosition));
                } else if (e.keyCode == 0x1000002) {
                    if (this.historyPosition < 1) {
                        return;
                    }
                    commandLine.setText((String)history.get(--this.historyPosition));
                } else if (e.keyCode == 27) {
                    this.historyPosition = -1;
                    commandLine.setText("");
                } else if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    final String command = commandLine.getText();
                    try {
                        Simantics.getSession().syncRequest((Write)new WriteRequest(){

                            public void perform(WriteGraph graph) throws DatabaseException {
                                DebugSupport support = (DebugSupport)graph.getService(DebugSupport.class);
                                Object data = support.query(graph, command);
                                this.apply(command, data);
                                throw new CancelTransactionException();
                            }
                        });
                    }
                    catch (CancelTransactionException cancelTransactionException) {
                    }
                    catch (DatabaseException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        SessionDebugger deprecated = new SessionDebugger((Composite)this.folder, 0, Simantics.getSession());
        deprecated.initializeUI();
        CTabItem shellItem = this.createItem(0, this.folder, (Control)shell);
        shellItem.setText("Shell");
        this.folder.setSelection(shellItem);
    }

    public void navigate(URL url, String target) {
    }

    public void setFocus() {
        this.folder.setFocus();
    }

    protected IPropertyPage getPropertyPage() {
        return null;
    }
}

