/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.debug.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.db.exception.DatabaseException;
import org.simantics.debug.ui.GraphDebugger;
import org.simantics.debug.ui.internal.Activator;
import org.simantics.debug.ui.internal.DebugUtils;
import org.simantics.ui.workbench.ResourceEditorPart;
import org.simantics.utils.ui.BundleUtils;
import org.simantics.utils.ui.LayoutUtils;

public class GraphDebuggerEditor
extends ResourceEditorPart {
    public static final String EDITOR_ID = "org.simantics.debug.graphDebuggerEditor";
    private GraphDebugger debugger;
    private IAction backAction;
    private IAction forwardAction;
    private IAction refreshAction;
    private IAction findAction;
    private IAction addStatementAction;
    private IAction addResourceAction;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)LayoutUtils.createNoBorderGridLayout((int)1));
        this.debugger = new GraphDebugger(parent, 0, this.getSession(), this.getInputResource(), (IWorkbenchSite)this.getSite());
        this.debugger.setLayoutData(new GridData(4, 4, true, true));
        this.debugger.setLayout((Layout)LayoutUtils.createNoBorderGridLayout((int)1));
        Composite bar = new Composite((Composite)this.debugger, 0);
        bar.setLayout((Layout)new GridLayout(3, false));
        bar.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.backAction = new BackAction();
        this.forwardAction = new ForwardAction();
        this.refreshAction = new RefreshAction();
        this.findAction = new FindAction();
        this.addStatementAction = new AddStatementAction();
        this.addResourceAction = new AddResourceAction();
        ToolBar toolBar = new ToolBar(bar, 0x800100);
        new ActionContributionItem(this.backAction).fill(toolBar, 0);
        new ActionContributionItem(this.forwardAction).fill(toolBar, 1);
        new Separator().fill(toolBar, 2);
        new ActionContributionItem(this.refreshAction).fill(toolBar, 3);
        new Separator().fill(toolBar, 4);
        new ActionContributionItem(this.findAction).fill(toolBar, 5);
        new ActionContributionItem(this.addStatementAction).fill(toolBar, 6);
        new ActionContributionItem(this.addResourceAction).fill(toolBar, 7);
        this.debugger.createResourceText(bar);
        Label dropLabel = this.debugger.createDropLabel(bar);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 4).hint(-1, 20).span(3, 1).applyTo((Control)dropLabel);
        Browser browser = this.debugger.createBrowser(this.debugger);
        GridDataFactory.fillDefaults().grab(true, true).span(3, 1).applyTo((Control)browser);
        this.debugger.addHistoryListener(new GraphDebugger.HistoryListener(){

            @Override
            public void historyChanged() {
                GraphDebuggerEditor.this.updateActionStates();
            }
        });
        this.updateActionStates();
    }

    public void setFocus() {
        if (this.debugger != null) {
            this.debugger.setFocus();
        }
    }

    public void back() {
        this.debugger.back();
    }

    public void forward() {
        this.debugger.forward();
    }

    public void refreshBrowser() {
        this.debugger.refreshBrowser();
    }

    private void updateActionStates() {
        this.backAction.setEnabled(!this.debugger.hasBackHistory());
        this.forwardAction.setEnabled(!this.debugger.hasForwardHistory());
    }

    class AddResourceAction
    extends Action {
        public AddResourceAction() {
            super("AddResource", BundleUtils.getImageDescriptorFromPlugin((String)"org.simantics.debug.ui", (String)"icons/cog_add.png"));
            this.setToolTipText("Add New Related Resource");
        }

        public void run() {
            try {
                DebugUtils.addStatement(Simantics.getSession(), GraphDebuggerEditor.this.debugger);
            }
            catch (DatabaseException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.simantics.debug.ui", e.getMessage(), (Throwable)e));
            }
        }
    }

    class AddStatementAction
    extends Action {
        public AddStatementAction() {
            super("AddStatement", BundleUtils.getImageDescriptorFromPlugin((String)"org.simantics.debug.ui", (String)"icons/cog_add.png"));
            this.setToolTipText("Add Statement Between Existing Resources");
        }

        public void run() {
            try {
                DebugUtils.addStatement(Simantics.getSession(), GraphDebuggerEditor.this.debugger);
            }
            catch (DatabaseException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.simantics.debug.ui", e.getMessage(), (Throwable)e));
            }
        }
    }

    class BackAction
    extends Action {
        public BackAction() {
            super("Back", 1);
            this.setToolTipText("Back");
            this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_BACK"));
            this.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_BACK_DISABLED"));
        }

        public void run() {
            GraphDebuggerEditor.this.back();
            GraphDebuggerEditor.this.updateActionStates();
        }
    }

    class FindAction
    extends Action {
        public FindAction() {
            super("Find", BundleUtils.getImageDescriptorFromPlugin((String)"org.simantics.debug.ui", (String)"icons/cog_blue.png"));
            this.setToolTipText("Find Resource");
        }

        public void run() {
            DebugUtils.find(Simantics.getSession(), GraphDebuggerEditor.this.debugger);
        }
    }

    class ForwardAction
    extends Action {
        public ForwardAction() {
            super("Forward", 1);
            this.setToolTipText("Forward");
            this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_FORWARD"));
            this.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_FORWARD_DISABLED"));
        }

        public void run() {
            GraphDebuggerEditor.this.forward();
            GraphDebuggerEditor.this.updateActionStates();
        }
    }

    class RefreshAction
    extends Action {
        public RefreshAction() {
            super("Refresh", BundleUtils.getImageDescriptorFromPlugin((String)"org.simantics.ui", (String)"icons/refresh.gif"));
            this.setToolTipText("Refresh");
        }

        public void run() {
            GraphDebuggerEditor.this.refreshBrowser();
        }
    }
}

