/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.migration.ui;

import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.layer0.util.Simantics;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.layer0.SoftwareConfigurationResources;

public class MigrationAnalysis {
    Resource parentVersion;
    THashMap<Resource, Update> updates = new THashMap();

    public MigrationAnalysis(ReadGraph g, Resource parentVersion) throws DatabaseException {
        this.parentVersion = parentVersion;
        this.updates.put((Object)parentVersion, null);
        this.findUpdatesFrom(g, parentVersion);
        this.updates.remove((Object)parentVersion);
    }

    private void findUpdatesFrom(ReadGraph g, Resource version) throws DatabaseException {
        SoftwareConfigurationResources SC = SoftwareConfigurationResources.getInstance((ReadGraph)g);
        for (Resource update : g.getObjects(version, SC.Version_HasUpdate)) {
            Resource to = g.getSingleObject(update, SC.Update_To);
            if (this.updates.contains((Object)to)) continue;
            String name = NameUtils.getSafeLabel((ReadGraph)g, (Resource)to);
            this.updates.put((Object)to, (Object)new Update(update, version, to, name));
            this.findUpdatesFrom(g, to);
        }
    }

    public Collection<Update> getUpdates() {
        return this.updates.values();
    }

    public class Update
    implements Comparable<Update> {
        Resource updateResource;
        Resource parentVersion;
        Resource childVersion;
        String versionName;

        public Update(Resource updateResource, Resource parentVersion, Resource childVersion, String versionName) {
            this.updateResource = updateResource;
            this.parentVersion = parentVersion;
            this.childVersion = childVersion;
            this.versionName = versionName;
        }

        @Override
        public int compareTo(Update o) {
            return this.versionName.compareTo(o.versionName);
        }

        public void execute(final Resource target) throws DatabaseException {
            Update parentUpdate = (Update)MigrationAnalysis.this.updates.get((Object)this.parentVersion);
            if (parentUpdate != null) {
                parentUpdate.execute(target);
            }
            Collection migrateActions = (Collection)Simantics.getSession().syncRequest((Read)new Read<Collection<Runnable>>(){

                public Collection<Runnable> perform(ReadGraph graph) throws DatabaseException {
                    SoftwareConfigurationResources SC = SoftwareConfigurationResources.getInstance((ReadGraph)graph);
                    ArrayList<Runnable> result = new ArrayList<Runnable>();
                    for (Resource action : graph.getObjects(Update.this.updateResource, SC.Update_HasMigrationAction)) {
                        result.add(((ActionFactory)graph.adapt(action, ActionFactory.class)).create((Object)target));
                    }
                    return result;
                }
            });
            for (Runnable action : migrateActions) {
                action.run();
            }
        }

        public void updateTargetVersion(final Resource target) throws DatabaseException {
            Simantics.getSession().syncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    SoftwareConfigurationResources SC = SoftwareConfigurationResources.getInstance((ReadGraph)graph);
                    graph.deny(target, SC.IsCompatibleWith, ((Update)Update.this).MigrationAnalysis.this.parentVersion);
                    graph.claim(target, SC.IsCompatibleWith, Update.this.childVersion);
                }
            });
        }
    }
}

