/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.representation.utils;

import java.io.StringReader;
import java.util.Set;
import org.simantics.Simantics;
import org.simantics.project.IProject;
import org.simantics.simulation.experiment.IExperiment;
import org.simantics.simulation.project.IExperimentManager;
import org.simantics.sysdyn.expressionParser.ExpressionParser;
import org.simantics.sysdyn.expressionParser.ParseException;
import org.simantics.sysdyn.manager.SysdynGameExperimentBase;
import org.simantics.sysdyn.representation.Configuration;
import org.simantics.sysdyn.representation.IElement;
import org.simantics.sysdyn.representation.IndependentVariable;
import org.simantics.sysdyn.representation.Module;
import org.simantics.sysdyn.representation.Stock;
import org.simantics.sysdyn.representation.Variability;
import org.simantics.sysdyn.representation.Variable;
import org.simantics.sysdyn.representation.utils.FormatUtils;

public class RepresentationUtils {
    public static boolean isGameExperimentActive() {
        IProject project = Simantics.peekProject();
        if (project == null) {
            return false;
        }
        IExperimentManager manager = (IExperimentManager)project.getHint(IExperimentManager.KEY_EXPERIMENT_MANAGER);
        IExperiment active = manager.getActiveExperiment();
        return active instanceof SysdynGameExperimentBase;
    }

    public static boolean isPartOfGameExperiment(Variable variable) {
        Configuration conf = variable.getParentConfiguration();
        if (conf != null) {
            return conf.isGameConfiguration();
        }
        return false;
    }

    public static boolean isPartOfGameExperiment(Module module) {
        Configuration conf = module.getParentConfiguration();
        if (conf != null) {
            return conf.isGameConfiguration();
        }
        return false;
    }

    public static Variable getFirstGameVariableReference(Variable variable, String expression) {
        Variable result;
        block4: {
            String equation = FormatUtils.formatExpressionForModelica(variable, expression, false);
            ExpressionParser parser = new ExpressionParser(new StringReader(equation));
            result = null;
            try {
                parser.expr();
                if (parser.getReferences().isEmpty()) break block4;
                Set<String> references = parser.getReferences().keySet();
                for (String reference : references) {
                    result = RepresentationUtils.getGameVariableReference(variable, variable.getParentConfiguration(), reference);
                    if (result == null) {
                        continue;
                    }
                    break;
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return result;
    }

    private static Variable getGameVariableReference(Variable variable, Configuration configuration, String reference) {
        String r = reference.split("\\.")[0];
        for (IElement element : configuration.getElements()) {
            IndependentVariable v;
            if (element instanceof Module) {
                Module m = (Module)element;
                if (!r.equals(m.getName())) continue;
                if (!reference.contains(".")) {
                    return null;
                }
                Configuration moduleConfiguration = m.getType().getConfiguration();
                return RepresentationUtils.getGameVariableReference(variable, moduleConfiguration, reference.substring(reference.indexOf(".") + 1));
            }
            if (!(element instanceof IndependentVariable) || element instanceof Stock || !r.equals((v = (IndependentVariable)element).getName())) continue;
            if (v.getName().equals(variable.getName())) {
                return null;
            }
            if (Variability.PARAMETER.equals((Object)Variability.getVariability(v, false, null))) {
                return v;
            }
            return null;
        }
        return null;
    }

    public static Variable getVariable(Configuration configuration, String name) {
        String[] components;
        Configuration conf = configuration;
        String whitespacedName = name.replace('_', ' ');
        String[] stringArray = components = whitespacedName.split("\\.");
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            String component = stringArray[n2];
            Configuration newConf = null;
            for (IElement element : conf.getElements()) {
                Module m;
                if (element instanceof Variable) {
                    Variable variable = (Variable)element;
                    if (!variable.getName().equals(component)) continue;
                    return variable;
                }
                if (!(element instanceof Module) || !(m = (Module)element).getName().equals(component)) continue;
                newConf = m.getType().getConfiguration();
            }
            if (newConf == null) {
                return null;
            }
            ++n2;
        }
        return null;
    }
}

