/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.representation.expressions;

import org.simantics.objmap.annotations.GraphType;
import org.simantics.objmap.annotations.RelatedValue;
import org.simantics.sysdyn.representation.expressions.Expression;
import org.simantics.sysdyn.representation.utils.FormatUtils;
import org.simantics.sysdyn.representation.utils.IndexUtils;

@GraphType(value="http://www.simantics.org/Sysdyn-1.1/ParameterExpression")
public class ParameterExpression
extends Expression {
    @RelatedValue(value="http://www.simantics.org/Sysdyn-1.1/Expression/equation")
    private String equation;

    @Override
    public String getExpression() {
        return String.valueOf(this.equation) + " /* Actual value read from init file */";
    }

    @Override
    public String getModelicaExpression() {
        String equation = FormatUtils.replaceWhitespace(this.equation);
        return String.valueOf(equation) + " /* Actual value read from init file */";
    }

    @Override
    public String getEquation() {
        String equation = FormatUtils.replaceWhitespace(this.equation);
        String range = IndexUtils.rangeToIndexes(this.parent, this.getArrayRange());
        return "    " + this.parent.getModelicaName() + (range.equals("[:]") ? "" : range) + " = " + equation + ";\n";
    }

    public Double getValue() {
        try {
            return Double.parseDouble(this.equation);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

