/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.representation;

import java.util.ArrayList;
import java.util.HashMap;
import org.simantics.objmap.annotations.GraphType;
import org.simantics.objmap.annotations.RelatedElement;
import org.simantics.objmap.annotations.RelatedElements;
import org.simantics.objmap.annotations.RelatedValue;
import org.simantics.sysdyn.representation.Configuration;
import org.simantics.sysdyn.representation.Function;
import org.simantics.sysdyn.representation.FunctionLibrary;
import org.simantics.sysdyn.representation.ModuleType;
import org.simantics.sysdyn.representation.SharedFunctionLibrary;
import org.simantics.sysdyn.representation.annotations.BuiltinFunctions;

@GraphType(value="http://www.simantics.org/Sysdyn-1.1/SysdynModel")
public class Model {
    @RelatedValue(value="http://www.simantics.org/Sysdyn-1.1/SysdynModel/startTime")
    private final Double startTime = 0.0;
    @RelatedValue(value="http://www.simantics.org/Sysdyn-1.1/SysdynModel/stopTime")
    private final Double stopTime = 10.0;
    @RelatedValue(value="http://www.simantics.org/Sysdyn-1.1/SysdynModel/outputInterval")
    private Double outputInterval;
    @RelatedValue(value="http://www.simantics.org/Sysdyn-1.1/SysdynModel/simulationStepLength")
    private Double stepLength;
    @RelatedValue(value="http://www.simantics.org/Sysdyn-1.1/SysdynModel/tolerance")
    private Double tolerance;
    @RelatedValue(value="http://www.simantics.org/Sysdyn-1.1/SysdynModel/solver")
    private String solver;
    @RelatedValue(value="http://www.simantics.org/Sysdyn-1.1/SysdynModel/variableFilter")
    private String variableFilter;
    @RelatedElement(value="http://www.simantics.org/Simulation-1.1/HasConfiguration")
    private Configuration configuration;
    @RelatedValue(value="http://www.simantics.org/Sysdyn-1.1/SysdynModel/timeUnit")
    private String timeUnit;
    @RelatedElements(value="http://www.simantics.org/Layer0-1.1/ConsistsOf", composition=true)
    private final ArrayList<Object> consistsOf = new ArrayList();
    @RelatedElements(value="http://www.simantics.org/Layer0-1.1/IsLinkedTo", composition=true)
    private final ArrayList<Object> linkedTo = new ArrayList();
    @BuiltinFunctions
    private FunctionLibrary builtins;

    public Double getStartTime() {
        return this.startTime;
    }

    public Double getStopTime() {
        return this.stopTime;
    }

    public Double getOutputInterval() {
        return this.outputInterval;
    }

    public Double getSimulationStepLength() {
        return this.stepLength;
    }

    public Double getTolerance() {
        return this.tolerance;
    }

    public String getSolver() {
        return this.solver;
    }

    public String getVariableFilter() {
        if (this.variableFilter == null || this.variableFilter.isEmpty()) {
            return ".*";
        }
        return this.variableFilter;
    }

    public HashMap<String, Function> getFunctions() {
        HashMap<String, Function> functions = new HashMap<String, Function>();
        if (this.consistsOf != null) {
            for (Object o : this.consistsOf) {
                if (o instanceof Function) {
                    Function f = (Function)o;
                    functions.put(f.getName(), f);
                    continue;
                }
                if (!(o instanceof FunctionLibrary)) continue;
                this.addFunctions("", (FunctionLibrary)o, functions);
            }
        }
        if (this.linkedTo != null) {
            for (Object o : this.linkedTo) {
                if (!(o instanceof SharedFunctionLibrary)) continue;
                SharedFunctionLibrary fl = (SharedFunctionLibrary)o;
                this.addFunctions(fl.getName(), fl, functions);
            }
        }
        if (this.builtins != null) {
            this.addBuiltinFunctions(this.builtins, functions);
        }
        return functions;
    }

    public boolean containsModuleType(String moduleType) {
        if (this.consistsOf != null) {
            for (Object o : this.consistsOf) {
                ModuleType mt;
                if (!(o instanceof ModuleType) || !(mt = (ModuleType)o).getName().equals(moduleType)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsFunctionOrLibrary(String elementName) {
        if (this.consistsOf != null) {
            for (Object o : this.consistsOf) {
                FunctionLibrary fl;
                Function f;
                if (!(o instanceof Function ? (f = (Function)o).getName().equals(elementName) : o instanceof FunctionLibrary && (fl = (FunctionLibrary)o).getName().equals(elementName))) continue;
                return true;
            }
        }
        return false;
    }

    private void addBuiltinFunctions(FunctionLibrary library, HashMap<String, Function> functions) {
        for (Function f : library.getFunctions()) {
            functions.put(f.getName(), f);
        }
        for (FunctionLibrary fl : library.getLibraries()) {
            this.addBuiltinFunctions(fl, functions);
        }
    }

    private void addFunctions(String path, FunctionLibrary library, HashMap<String, Function> functions) {
        for (Function f : library.getFunctions()) {
            functions.put(String.valueOf(path) + (path.isEmpty() ? "" : ".") + f.getName(), f);
        }
        for (FunctionLibrary fl : library.getLibraries()) {
            this.addFunctions(String.valueOf(path.isEmpty() ? "" : String.valueOf(path) + ".") + fl.getName(), fl, functions);
        }
    }

    public FunctionLibrary getBuiltins() {
        return this.builtins;
    }

    public Configuration getModelConfiguration() {
        return this.configuration;
    }

    public String getTimeUnit() {
        return this.timeUnit;
    }
}

