/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.modelImport.model;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.modelImport.model.Variable;
import org.simantics.sysdyn.modelImport.model.WriteContext;
import org.simantics.sysdyn.modelImport.model.expression.Expression;
import org.simantics.sysdyn.modelImport.model.support.Range;

public class Valve
extends Variable {
    private Orientation orientation;
    private TextPosition position;

    public Valve() {
    }

    public Valve(Orientation orientation, TextPosition position) {
        this.orientation = orientation;
        this.position = position;
    }

    public Valve(double[] dim, String name, Expression expression, Range range, String unit, String description, Orientation orientation, TextPosition position) {
        super(dim, name, expression, range, unit, description);
        this.orientation = orientation;
        this.position = position;
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
    }

    public TextPosition getPosition() {
        return this.position;
    }

    public void setPosition(TextPosition position) {
        this.position = position;
    }

    @Override
    public Resource write(WriteGraph graph, Resource parent, WriteContext context) throws DatabaseException {
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
        Resource location = null;
        switch (this.position) {
            case BELOW: {
                location = sr.Bottom;
                break;
            }
            case LEFT: {
                location = sr.Left;
                break;
            }
            case ABOVE: {
                location = sr.Top;
                break;
            }
            case RIGHT: {
                location = sr.Right;
                break;
            }
            default: {
                System.err.println("valve text location not set");
                location = sr.Bottom;
            }
        }
        Resource valve = super.write(graph, parent, context);
        graph.claim(this.getDiagramResource(), sr.ValveSymbol_textLocation, location);
        return valve;
    }

    @Override
    public Resource getVariableType(ReadGraph graph) {
        return SysdynResource.getInstance((ReadGraph)graph).Valve;
    }

    @Override
    public Resource getSymbolType(ReadGraph graph) {
        return SysdynResource.getInstance((ReadGraph)graph).ValveSymbol;
    }

    public static enum Orientation {
        HORIZONTAL,
        VERTICAL;

    }

    public static enum TextPosition {
        INSIDE,
        BELOW,
        LEFT,
        ABOVE,
        RIGHT,
        UNSET;

    }
}

