/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.modelImport.mdl;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.simantics.sysdyn.modelImport.MdlUtil;
import org.simantics.sysdyn.modelImport.mdl.Declaration;
import org.simantics.sysdyn.modelImport.mdl.MdlModel;
import org.simantics.sysdyn.modelImport.model.Variable;
import org.simantics.sysdyn.modelImport.model.expression.DelayExpression;
import org.simantics.sysdyn.modelImport.model.expression.Expression;
import org.simantics.sysdyn.modelImport.model.expression.IntegralExpression;
import org.simantics.sysdyn.modelImport.model.expression.NormalExpression;
import org.simantics.sysdyn.modelImport.model.support.Range;

public class MdlVariable
extends Declaration {
    protected static final String EXPRESSION = "(?:\\s*=\\s*([^~]*?(?:\"[^\"\\\\]*(?:\\\\.[^\"\\\\]*)*\"[^~]*?)*))?";
    private static final String VARIABLE_DECL = "([A-Za-z]\\w*(?:\\s+\\w+)*|\"[^\"\\\\]*(?:\\\\.[^\"\\\\]*)*\")(?:\\s*=\\s*([^~]*?(?:\"[^\"\\\\]*(?:\\\\.[^\"\\\\]*)*\"[^~]*?)*))?(\\s*~\\s*([^~]*?)\\s*~\\s*([^\\|]*?)\\s*\\|)";
    private static final int variableName = 1;
    private static final int variableExpression = 2;
    private static final int variableSuffix = 3;
    private String expression;

    protected MdlVariable(String name, MdlModel mdl, String expression) {
        super(name, mdl);
        this.expression = expression;
    }

    public static MdlVariable getPossible(String line, MdlModel mdl) throws Exception {
        Matcher matcher = Pattern.compile(VARIABLE_DECL).matcher(line);
        if (!matcher.matches()) {
            return null;
        }
        String name = MdlUtil.normalize(matcher.group(1));
        String expression = matcher.group(2);
        if (expression != null) {
            expression = MdlUtil.normalize(expression);
        }
        MdlVariable var = new MdlVariable(name, mdl, expression);
        var.parseSuffix(matcher.group(3));
        return var;
    }

    public String getExpressionString() {
        return this.expression;
    }

    public <T extends Variable> T initVariable(T variable) {
        String unit;
        Range range;
        variable.setName(this.getName());
        if (this.expression != null) {
            variable.setExpression(this.getExpression());
        }
        if ((range = MdlVariable.parseRange(unit = this.getUnit())) != null) {
            unit = unit.substring(0, unit.indexOf(91)).trim();
        }
        variable.setUnit(unit);
        if (range != null) {
            variable.setRange(range);
        }
        variable.setDescription(this.getDescription());
        return variable;
    }

    public Expression getExpression() {
        if (this.expression == null) {
            return null;
        }
        return MdlVariable.parseExpression(MdlUtil.finalize(this.expression, this.getMdl()));
    }

    protected static Expression parseExpression(String expression) {
        Matcher matcher = Pattern.compile("([A-Za-z]\\w*(?:\\s+\\w+)*)\\s*\\((.*)\\)").matcher(expression);
        if (!matcher.matches()) {
            return new NormalExpression(expression);
        }
        String function = matcher.group(1).toUpperCase();
        String[] parameters = MdlVariable.splitFunctionParameters(matcher.group(2));
        if (function.equals("INTEG")) {
            if (parameters.length != 2) {
                System.err.println("malformed integral expression: " + expression);
                return null;
            }
            return new IntegralExpression(parameters[0], parameters[1]);
        }
        if (function.equals("INITIAL")) {
            if (parameters.length != 1) {
                System.err.println("malformed initial expression: " + expression);
                return null;
            }
            return new IntegralExpression("0", parameters[0]);
        }
        if (function.equals("DELAY N")) {
            if (parameters.length != 4) {
                System.err.println("malformed delay expression: " + expression);
                return null;
            }
            return new DelayExpression(parameters[0], parameters[1], parameters[2], Integer.parseInt(parameters[3]));
        }
        if (function.equals("SMOOTH3I")) {
            if (parameters.length != 3) {
                System.err.println("malformed smoothi expression: " + expression);
            }
            return new DelayExpression(parameters[0], parameters[1], parameters[2], 3);
        }
        if (function.equals("SMOOTH3")) {
            if (parameters.length != 2) {
                System.err.println("malformed smooth expression: " + expression);
            }
            return new DelayExpression(parameters[0], parameters[1], parameters[0], 3);
        }
        if (function.equals("SMOOTHI")) {
            if (parameters.length != 3) {
                System.err.println("malformed smoothi expression: " + expression);
            }
            return new DelayExpression(parameters[0], parameters[1], parameters[2], 1);
        }
        if (function.equals("SMOOTH")) {
            if (parameters.length != 2) {
                System.err.println("malformed smooth expression: " + expression);
            }
            return new DelayExpression(parameters[0], parameters[1], parameters[0], 1);
        }
        if (function.equals("GAME")) {
            if (parameters.length != 1) {
                System.err.println("malformed game expression: " + expression);
                return null;
            }
            return new NormalExpression(parameters[0]);
        }
        return new NormalExpression(expression);
    }

    private static Range parseRange(String unit) {
        Matcher matcher = Pattern.compile("\\[([+-]?(?:NaN|Infinity|\\d+(?:\\.\\d+)?(?:[eE][+-]?\\d+)?)),(\\?|([+-]?(?:NaN|Infinity|\\d+(?:\\.\\d+)?(?:[eE][+-]?\\d+)?))|([+-]?(?:NaN|Infinity|\\d+(?:\\.\\d+)?(?:[eE][+-]?\\d+)?)),([+-]?(?:NaN|Infinity|\\d+(?:\\.\\d+)?(?:[eE][+-]?\\d+)?)))\\]").matcher(unit);
        if (matcher.find()) {
            Double step;
            Double end;
            Double start = Double.parseDouble(matcher.group(1));
            if (matcher.group(2).equals("?")) {
                end = null;
                step = null;
            } else if (matcher.group(2).contains(",")) {
                end = Double.parseDouble(matcher.group(4));
                step = Double.parseDouble(matcher.group(5));
            } else {
                end = Double.parseDouble(matcher.group(3));
                step = null;
            }
            return new Range(start, end, step);
        }
        return null;
    }

    private static String[] splitFunctionParameters(String str) {
        ArrayList<String> list = new ArrayList<String>();
        int last = 0;
        int level = 0;
        boolean comment = false;
        boolean brackets = false;
        int i = 0;
        while (i < str.length()) {
            char current = str.charAt(i);
            if (current == '\"') {
                comment = !comment;
            } else if (current == '[' && !comment) {
                brackets = true;
            } else if (current == ']' && !comment) {
                brackets = false;
            } else if (current == '(' && !comment && !brackets) {
                ++level;
            } else if (current == ')' && !comment && !brackets) {
                --level;
            } else if (current == ',' && !comment && !brackets && level == 0) {
                list.add(str.substring(last, i).trim());
                last = i + 1;
            }
            ++i;
        }
        if (last < i) {
            list.add(str.substring(last, i).trim());
        }
        return list.toArray(new String[list.size()]);
    }
}

