/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.modelImport;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Pattern;
import org.simantics.sysdyn.modelImport.MdlUtil;
import org.simantics.sysdyn.modelImport.mdl.Declaration;
import org.simantics.sysdyn.modelImport.mdl.Lookup;
import org.simantics.sysdyn.modelImport.mdl.MdlModel;
import org.simantics.sysdyn.modelImport.mdl.MdlVariable;
import org.simantics.sysdyn.modelImport.mdl.Sketch;
import org.simantics.sysdyn.modelImport.mdl.SketchComment;
import org.simantics.sysdyn.modelImport.mdl.SketchConnection;
import org.simantics.sysdyn.modelImport.mdl.SketchObject;
import org.simantics.sysdyn.modelImport.mdl.SketchValve;
import org.simantics.sysdyn.modelImport.mdl.SketchVariable;
import org.simantics.sysdyn.modelImport.mdl.Subscript;
import org.simantics.sysdyn.modelImport.mdl.SubscriptVariable;
import org.simantics.sysdyn.modelImport.model.Comment;
import org.simantics.sysdyn.modelImport.model.Connection;
import org.simantics.sysdyn.modelImport.model.Model;
import org.simantics.sysdyn.modelImport.model.Shadow;
import org.simantics.sysdyn.modelImport.model.Symbol;
import org.simantics.sysdyn.modelImport.model.Variable;

public class MdlParser {
    private static final String UTF_8 = "{UTF-8}";
    private static final String SKETCH_VERSION = "V300";
    private static final String SKETCH_START = "\\\\\\---///";
    private static final String SKETCH_END = "///---\\\\\\";
    private static final String PARAMETER_START = "INITIAL TIME";
    private static final String PARAMETER_STOP = "FINAL TIME";
    private static final String PARAMETER_STEP = "TIME STEP";

    public static Model parse(File file) throws Exception {
        MdlVariable step;
        MdlVariable stop;
        MdlModel mdl = MdlParser.parseFile(file);
        Model model = new Model(mdl.getName());
        for (Subscript subscript : mdl.getAllSubscripts()) {
            if (subscript.isEquivalent()) continue;
            model.addEnumeration(subscript.getEnumeration());
        }
        for (Lookup lookup : mdl.getAllLookups()) {
            model.addFunction(lookup.getFunction());
        }
        int offset = 0;
        for (Sketch sketch : mdl.getSketches()) {
            Symbol symbol;
            model.addSymbol(new Comment(MdlUtil.getSysdynDimensions(offset, 0, -1, -1), "=== VENSIM SKETCH: " + sketch.getName() + " ======>"));
            sketch.setLocation(offset, 20);
            for (SketchComment comment : sketch.getComments()) {
                symbol = comment.getSymbol();
                if (symbol == null) continue;
                comment.setModelObject(symbol);
                model.addSymbol(symbol);
            }
            for (SketchValve valve : sketch.getValves()) {
                symbol = valve.getSymbol();
                if (symbol == null) continue;
                valve.setModelObject(symbol);
                model.addVariable((Variable)symbol);
            }
            for (SketchVariable variable : sketch.getNonShadowVariables()) {
                symbol = variable.getSymbol();
                if (symbol == null) continue;
                variable.setModelObject(symbol);
                model.addVariable((Variable)symbol);
            }
            offset += sketch.getWidth();
        }
        for (Sketch sketch : mdl.getSketches()) {
            for (SketchVariable variable : sketch.getShadowVariables()) {
                Symbol symbol;
                Variable original = model.getVariable(variable.getName());
                if (original != null) {
                    symbol = new Shadow(variable.getDimensions(), original);
                    variable.setModelObject(symbol);
                    model.addShadow((Shadow)symbol);
                    continue;
                }
                symbol = variable.getSymbol();
                if (symbol == null) continue;
                variable.setModelObject(symbol);
                model.addVariable((Variable)symbol);
            }
            for (SketchConnection connection : sketch.getConnections()) {
                Connection conn = connection.getConnection();
                if (conn == null) continue;
                connection.setModelObject(conn);
                model.addConnection(conn);
            }
        }
        MdlVariable start = mdl.getVariable(PARAMETER_START);
        if (start != null && Pattern.matches("[+-]?(?:NaN|Infinity|\\d+(?:\\.\\d+)?(?:[eE][+-]?\\d+)?)", start.getExpressionString())) {
            model.setStartTime(Double.parseDouble(start.getExpressionString()));
        }
        if ((stop = mdl.getVariable(PARAMETER_STOP)) != null && Pattern.matches("[+-]?(?:NaN|Infinity|\\d+(?:\\.\\d+)?(?:[eE][+-]?\\d+)?)", stop.getExpressionString())) {
            model.setStopTime(Double.parseDouble(stop.getExpressionString()));
        }
        if ((step = mdl.getVariable(PARAMETER_STEP)) != null && Pattern.matches("[+-]?(?:NaN|Infinity|\\d+(?:\\.\\d+)?(?:[eE][+-]?\\d+)?)", step.getExpressionString())) {
            model.setTimeStep(Double.parseDouble(step.getExpressionString()));
            String unit = step.getUnit();
            if (unit.contains("[")) {
                unit = unit.substring(0, unit.indexOf(91)).trim();
            }
            model.setTimeUnit(unit.toLowerCase());
        }
        return model;
    }

    private static MdlModel parseFile(File file) throws Exception {
        String name = file.getName();
        if (file.getName().contains(".")) {
            name = name.substring(0, name.indexOf(46));
        }
        MdlModel mdl = new MdlModel(name);
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        String line = reader.readLine();
        if (line == null) {
            reader.close();
            return null;
        }
        if (line.startsWith(UTF_8)) {
            reader.close();
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            reader.readLine();
            line = reader.readLine();
        }
        String category = null;
        do {
            if (line.isEmpty()) continue;
            StringBuilder buffer = new StringBuilder();
            do {
                line = line.replaceFirst("^\\s*", "");
                line = line.replaceFirst("\\\\$", "");
                buffer.append(line);
            } while (!line.endsWith("|") && (line = reader.readLine()) != null);
            String str = buffer.toString();
            String cat = Declaration.parseCategory(str);
            if (cat != null) {
                category = cat;
                continue;
            }
            Declaration decl = MdlVariable.getPossible(str, mdl);
            if (decl != null) {
                mdl.addVariable((MdlVariable)decl, category);
                continue;
            }
            decl = SubscriptVariable.getPossible(str, mdl);
            if (decl != null) {
                mdl.addSubscriptVariable((SubscriptVariable)decl, category);
                continue;
            }
            decl = Lookup.getPossible(str, mdl);
            if (decl != null) {
                mdl.addLookup((Lookup)decl);
                continue;
            }
            decl = Subscript.getPossible(str, mdl);
            if (decl != null) {
                mdl.addSubscript((Subscript)decl);
                continue;
            }
            throw new Exception("unrecognized variable " + str);
        } while ((line = reader.readLine()) != null && !line.startsWith(SKETCH_START));
        if (line == null) {
            throw new Exception("unexpected end of file");
        }
        Sketch sketch = null;
        do {
            if (line.isEmpty()) continue;
            if (line.startsWith(SKETCH_START)) {
                sketch = new Sketch(mdl);
                mdl.addSketch(sketch);
                continue;
            }
            if (line.startsWith(SKETCH_VERSION)) continue;
            if (line.startsWith("*")) {
                sketch.setName(line.substring(1));
                continue;
            }
            if (line.startsWith("$")) continue;
            SketchObject so = SketchConnection.getPossible(line, sketch);
            if (so != null) {
                sketch.addConnection((SketchConnection)so);
                continue;
            }
            so = SketchVariable.getPossible(line, sketch);
            if (so != null) {
                sketch.addVariable((SketchVariable)so);
                continue;
            }
            so = SketchValve.getPossible(line, sketch);
            if (so != null) {
                SketchValve valve = (SketchValve)so;
                SketchVariable attached = SketchVariable.getPossible(reader.readLine(), sketch);
                if (attached == null || !attached.isAttached()) {
                    throw new Exception("attached variable not found for valve");
                }
                valve.setAttached(attached);
                sketch.addValve(valve);
                continue;
            }
            so = SketchComment.getPossible(line, sketch);
            if (so != null) {
                SketchComment comment = (SketchComment)so;
                if (comment.hasTextLine()) {
                    comment.setText(reader.readLine());
                }
                if (comment.isInputOutput()) continue;
                sketch.addComment(comment);
                continue;
            }
            throw new Exception("unrecognized element " + line);
        } while ((line = reader.readLine()) != null && !line.startsWith(SKETCH_END));
        if (line == null) {
            throw new Exception("unexpected end of file");
        }
        while ((line = reader.readLine()) != null) {
        }
        reader.close();
        return mdl;
    }
}

