/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.manager;

import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.VirtualGraph;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ManyObjectsForFunctionalRelationException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.layer0.Layer0;
import org.simantics.objmap.IMapping;
import org.simantics.objmap.IMappingListener;
import org.simantics.objmap.IMappingSchema;
import org.simantics.objmap.MappingException;
import org.simantics.objmap.Mappings;
import org.simantics.project.IProject;
import org.simantics.simulation.experiment.IExperiment;
import org.simantics.simulation.model.IModel;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.simulation.project.ExperimentRuns;
import org.simantics.simulation.project.IExperimentActivationListener;
import org.simantics.simulation.project.IExperimentManager;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.adapter.VariableValueSubscription;
import org.simantics.sysdyn.manager.ActiveResults;
import org.simantics.sysdyn.manager.FileResult;
import org.simantics.sysdyn.manager.HistoryDatasetResult;
import org.simantics.sysdyn.manager.MemoryResult;
import org.simantics.sysdyn.manager.OldSysdynExperiment;
import org.simantics.sysdyn.manager.SysdynConsole;
import org.simantics.sysdyn.manager.SysdynExperiment;
import org.simantics.sysdyn.manager.SysdynGameExperiment;
import org.simantics.sysdyn.manager.SysdynGameExperimentInternal;
import org.simantics.sysdyn.manager.SysdynPlaybackExperiment;
import org.simantics.sysdyn.manager.SysdynResult;
import org.simantics.sysdyn.manager.SysdynSensitivityAnalysisExperiment;
import org.simantics.sysdyn.manager.VariableSubscriptionManager;
import org.simantics.sysdyn.representation.Configuration;
import org.simantics.sysdyn.representation.IElement;
import org.simantics.sysdyn.representation.IndependentVariable;
import org.simantics.sysdyn.representation.Model;
import org.simantics.sysdyn.representation.Module;
import org.simantics.sysdyn.representation.ParameterOverride;
import org.simantics.sysdyn.representation.Sheet;
import org.simantics.sysdyn.representation.SysdynSchema;
import org.simantics.sysdyn.representation.Variability;
import org.simantics.sysdyn.representation.expressions.Expression;
import org.simantics.sysdyn.representation.expressions.IExpression;
import org.simantics.sysdyn.representation.expressions.ParameterExpression;
import org.simantics.sysdyn.representation.expressions.StockExpression;
import org.simantics.sysdyn.solver.SolverSettings;

public class SysdynModel
implements IModel,
IMappingListener,
VariableSubscriptionManager {
    private Session session;
    private IMapping mapping;
    private Resource configurationResource;
    private Resource modelResource;
    private Configuration configuration;
    private final Set<Configuration> modules = new HashSet<Configuration>();
    private ArrayList<SysdynResult> displayedResults;
    private final ArrayList<HistoryDatasetResult> listeningHistories = new ArrayList();
    private final CopyOnWriteArrayList<Runnable> modificationListeners = new CopyOnWriteArrayList();
    protected THashSet<VariableValueSubscription> variableValueSubscriptions = new THashSet();
    protected volatile VariableValueSubscription[] variableValueSubscriptionsSnapshot = null;
    private final Map<Class, Object> services = new HashMap<Class, Object>();
    private boolean structureModified = false;

    void readModules(ReadGraph graph, Resource configResource, Set<Resource> result) throws DatabaseException {
        if (!result.add(configResource)) {
            return;
        }
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
        StructuralResource2 str = StructuralResource2.getInstance((ReadGraph)graph);
        for (Resource part : graph.getObjects(configResource, l0.ConsistsOf)) {
            if (!graph.isInstanceOf(part, sr.Module)) continue;
            Resource type = graph.getPossibleType(part, sr.Module);
            Resource config = graph.getPossibleObject(type, str.IsDefinedBy);
            this.readModules(graph, config, result);
        }
    }

    Set<Resource> readModules(ReadGraph graph, Resource configResource) throws DatabaseException {
        HashSet<Resource> result = new HashSet<Resource>();
        this.readModules(graph, configResource, result);
        return result;
    }

    private void createMapping(ReadGraph g) throws DatabaseException {
        SysdynSchema schema = new SysdynSchema(g);
        this.mapping = Mappings.createWithListening((IMappingSchema)schema);
        this.mapping.addMappingListener((IMappingListener)this);
        try {
            this.configuration = (Configuration)this.mapping.map(g, this.configurationResource);
        }
        catch (MappingException e) {
            SysdynConsole.INSTANCE.message("Error: Mapping is broken! Find the problem, fix it and restart the program.\nJava error message:\n" + e.getMessage());
            throw e;
        }
        for (Resource config : this.readModules(g, this.configurationResource)) {
            this.modules.add((Configuration)this.mapping.map(g, config));
        }
    }

    public SysdynModel(ReadGraph g, Resource configurationResource) {
        this.session = g.getSession();
        this.configurationResource = configurationResource;
        try {
            this.createMapping(g);
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        g.asyncRequest((Read)new Read<ArrayList<SysdynResult>>(){

            public ArrayList<SysdynResult> perform(ReadGraph graph) throws DatabaseException {
                Resource model;
                SysdynResource sr;
                Layer0 l0;
                ArrayList<SysdynResult> displayedResults;
                block7: {
                    displayedResults = new ArrayList<SysdynResult>();
                    for (HistoryDatasetResult hs : SysdynModel.this.listeningHistories) {
                        hs.disposeListeners();
                    }
                    l0 = Layer0.getInstance((ReadGraph)graph);
                    sr = SysdynResource.getInstance((ReadGraph)graph);
                    SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
                    model = graph.getPossibleObject(SysdynModel.this.getConfigurationResource(), SIMU.IsConfigurationOf);
                    if (model != null) break block7;
                    return null;
                }
                try {
                    Collection results = (Collection)graph.syncRequest((Read)new ActiveResults(model));
                    for (Resource result : results) {
                        if (!graph.hasStatement(result, sr.Result_showResult)) continue;
                        SysdynResult sysdynResult = null;
                        if (graph.isInstanceOf(result, sr.HistoryDataset)) {
                            HistoryDatasetResult r = new HistoryDatasetResult();
                            SysdynModel.this.listeningHistories.add(r);
                            sysdynResult = new MemoryResult(r, NameUtils.getSafeLabel((ReadGraph)graph, (Resource)result));
                            r.read((MemoryResult)sysdynResult, result);
                        } else {
                            sysdynResult = new FileResult((String)graph.getPossibleRelatedValue(result, l0.HasLabel), (String)graph.getPossibleRelatedValue(result, sr.Result_resultFile));
                        }
                        if (sysdynResult == null) continue;
                        displayedResults.add(sysdynResult);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return displayedResults;
            }
        }, (Listener)new Listener<ArrayList<SysdynResult>>(){

            public void execute(ArrayList<SysdynResult> result) {
                SysdynModel.this.displayedResults = result;
                SysdynModel.this.resultChanged();
            }

            public void exception(Throwable t) {
                t.printStackTrace();
            }

            public boolean isDisposed() {
                return false;
            }
        });
    }

    public SysdynModel(Resource modelResource) {
        this.modelResource = modelResource;
    }

    public Set<Configuration> getModules() {
        return this.modules;
    }

    public synchronized boolean update(ReadGraph graph) throws DatabaseException {
        if (this.mapping.isDomainModified()) {
            try {
                Collection updated = this.mapping.updateRange(graph);
                for (Object o : updated) {
                    IndependentVariable variable;
                    Variability variability;
                    if (o instanceof Model || o instanceof Expression && !(o instanceof StockExpression) && (variability = Variability.getVariability(variable = ((Expression)o).getParent(), false, this.configuration)) == Variability.PARAMETER) continue;
                    this.setStructureModified(true);
                    break;
                }
            }
            catch (MappingException e) {
                SysdynConsole.INSTANCE.message("Error: Mapping is broken! Find the problem, fix it and restart the program.\nJava error message:\n" + e.getMessage());
                throw e;
            }
            Set<Resource> configs = this.readModules(graph, this.configurationResource);
            for (Resource config : configs) {
                if (this.modules.contains(config)) continue;
                this.modules.add((Configuration)this.mapping.map(graph, config));
            }
            HashSet<Configuration> toBeRemoved = null;
            for (Configuration module : this.modules) {
                if (configs.contains(this.mapping.inverseGet((Object)module))) continue;
                if (toBeRemoved == null) {
                    toBeRemoved = new HashSet<Configuration>();
                }
                toBeRemoved.add(module);
            }
            if (toBeRemoved != null) {
                this.modules.removeAll(toBeRemoved);
            }
            return true;
        }
        return false;
    }

    public boolean update() throws DatabaseException {
        return (Boolean)this.session.syncRequest((Read)new Read<Boolean>(){

            public Boolean perform(ReadGraph graph) throws DatabaseException {
                return SysdynModel.this.update(graph);
            }
        });
    }

    public void resultChanged() {
        IProject project = Simantics.peekProject();
        IExperimentManager manager = (IExperimentManager)project.getHint(IExperimentManager.KEY_EXPERIMENT_MANAGER);
        IExperiment active = manager.getActiveExperiment();
        if (active != null && active instanceof SysdynExperiment) {
            ((SysdynExperiment)active).resultsChanged();
        }
        this.updateSubscriptions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModificationListener(Runnable listener) {
        CopyOnWriteArrayList<Runnable> copyOnWriteArrayList = this.modificationListeners;
        synchronized (copyOnWriteArrayList) {
            this.modificationListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModificationListener(Runnable listener) {
        CopyOnWriteArrayList<Runnable> copyOnWriteArrayList = this.modificationListeners;
        synchronized (copyOnWriteArrayList) {
            this.modificationListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void domainModified() {
        CopyOnWriteArrayList<Runnable> copyOnWriteArrayList = this.modificationListeners;
        synchronized (copyOnWriteArrayList) {
            for (Runnable listener : this.modificationListeners) {
                listener.run();
            }
        }
    }

    public void rangeModified() {
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Resource getConfigurationResource() {
        return this.configurationResource;
    }

    public IMapping getMapping() {
        return this.mapping;
    }

    public synchronized IElement getElement(Resource resource) {
        return (IElement)this.mapping.get(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getService(Class<T> clazz) {
        Map<Class, Object> map = this.services;
        synchronized (map) {
            return clazz.cast(this.services.get(clazz));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void addService(Class<T> clazz, T service) {
        Map<Class, Object> map = this.services;
        synchronized (map) {
            this.services.put(clazz, service);
        }
    }

    public IExperiment loadExperiment(ReadGraph g, Resource experiment, IExperimentActivationListener listener) {
        SysdynExperiment exp;
        block13: {
            if (this.configurationResource == null && this.modelResource != null) {
                SimulationResource simu = SimulationResource.getInstance((ReadGraph)g);
                try {
                    this.configurationResource = g.getPossibleObject(this.modelResource, simu.HasConfiguration);
                }
                catch (ManyObjectsForFunctionalRelationException e) {
                    e.printStackTrace();
                }
                catch (ServiceException e) {
                    e.printStackTrace();
                }
            }
            try {
                SysdynResource sr = SysdynResource.getInstance((ReadGraph)g);
                if (g.isInstanceOf(experiment, sr.PlaybackExperiment)) {
                    exp = new SysdynPlaybackExperiment(experiment, this.modelResource);
                    break block13;
                }
                if (g.isInstanceOf(experiment, sr.GameExperiment)) {
                    exp = SolverSettings.SolverType.INTERNAL.equals((Object)SolverSettings.getSelectedSolverType()) ? new SysdynGameExperimentInternal(experiment, this.modelResource) : new SysdynGameExperiment(experiment, this.modelResource);
                    break block13;
                }
                if (g.isInstanceOf(experiment, sr.SensitivityAnalysisExperiment)) {
                    exp = new SysdynSensitivityAnalysisExperiment(experiment, this.modelResource);
                    break block13;
                }
                if (g.isInstanceOf(experiment, sr.BasicExperiment)) {
                    exp = SolverSettings.SolverType.INTERNAL.equals((Object)SolverSettings.getSelectedSolverType()) ? new SysdynExperiment(experiment, this.modelResource) : new OldSysdynExperiment(experiment, this.modelResource);
                    break block13;
                }
                return null;
            }
            catch (Exception e) {
                if (listener != null) {
                    listener.onFailure((Throwable)e);
                }
                return null;
            }
        }
        ((SysdynExperiment)exp).init(g);
        VirtualGraphSupport support = (VirtualGraphSupport)g.getSession().getService(VirtualGraphSupport.class);
        ExperimentRuns.createRun((Session)g.getSession(), (VirtualGraph)support.getWorkspacePersistent("experiments"), (Resource)experiment, (IExperiment)exp, (String)"http://www.simantics.org/Sysdyn-1.1/Experiment/Run", (IExperimentActivationListener)listener, null);
        if (listener != null) {
            listener.onExperimentActivated((IExperiment)exp);
        }
        return exp;
    }

    public Collection<SysdynResult> getDisplayedResults() {
        if (this.displayedResults == null) {
            return new ArrayList<SysdynResult>();
        }
        return this.displayedResults;
    }

    public HashMap<String, String> getInits(Configuration configuration, String prefix) {
        HashMap<String, String> inits = new HashMap<String, String>();
        for (IElement element : configuration.getElements()) {
            if (element instanceof Module) {
                Module module = (Module)element;
                Configuration conf = module.getType().getConfiguration();
                String prfx = String.valueOf(prefix) + module.getName() + ".";
                inits.putAll(this.getInits(conf, prfx));
                for (ParameterOverride po : module.getParameterOverrides()) {
                    inits.put(String.valueOf(prfx) + po.getVariable().getName(), po.getExpression());
                }
                continue;
            }
            if (element instanceof IndependentVariable) {
                Double value;
                IExpression expression;
                IndependentVariable variable = (IndependentVariable)element;
                if (variable == null || variable.getExpressions() == null || variable.getExpressions().get(0) == null || !((expression = variable.getExpressions().get(0)) instanceof ParameterExpression) || (value = ((ParameterExpression)expression).getValue()) == null) continue;
                inits.put(String.valueOf(prefix) + variable.getName(), "" + value);
                continue;
            }
            if (!(element instanceof Sheet)) continue;
            Sheet sheet = (Sheet)element;
            for (String cell : sheet.getCells().keySet()) {
                inits.put(String.valueOf(sheet.getName()) + "." + cell, sheet.getCells().get((Object)cell).toString());
            }
        }
        return inits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addVariableValueSubscription(VariableValueSubscription subscription) {
        assert (subscription != null);
        THashSet<VariableValueSubscription> tHashSet = this.variableValueSubscriptions;
        synchronized (tHashSet) {
            this.variableValueSubscriptions.add((Object)subscription);
            this.variableValueSubscriptionsSnapshot = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeVariableValueSubscription(VariableValueSubscription subscription) {
        assert (subscription != null);
        THashSet<VariableValueSubscription> tHashSet = this.variableValueSubscriptions;
        synchronized (tHashSet) {
            this.variableValueSubscriptions.remove((Object)subscription);
            this.variableValueSubscriptionsSnapshot = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VariableValueSubscription[] getListenerSnapshot() {
        VariableValueSubscription[] snapshot = this.variableValueSubscriptionsSnapshot;
        if (snapshot == null) {
            THashSet<VariableValueSubscription> tHashSet = this.variableValueSubscriptions;
            synchronized (tHashSet) {
                snapshot = this.variableValueSubscriptionsSnapshot;
                if (snapshot == null) {
                    this.variableValueSubscriptionsSnapshot = (VariableValueSubscription[])this.variableValueSubscriptions.toArray((Object[])new VariableValueSubscription[this.variableValueSubscriptions.size()]);
                    snapshot = this.variableValueSubscriptionsSnapshot;
                }
            }
        }
        return snapshot;
    }

    @Override
    public void updateSubscriptions() {
        VariableValueSubscription[] snapShot;
        VariableValueSubscription[] variableValueSubscriptionArray = snapShot = this.getListenerSnapshot();
        int n = snapShot.length;
        int n2 = 0;
        while (n2 < n) {
            VariableValueSubscription subscription = variableValueSubscriptionArray[n2];
            subscription.update();
            ++n2;
        }
    }

    public boolean isStructureModified() {
        return this.structureModified;
    }

    public void setStructureModified(boolean structureModified) {
        this.structureModified = structureModified;
    }
}

