/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.manager;

import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.map.hash.THashMap;
import java.io.IOException;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Write;
import org.simantics.modelica.IModelicaMonitor;
import org.simantics.modeling.PartialIC;
import org.simantics.simulation.experiment.ExperimentState;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.manager.GameResult;
import org.simantics.sysdyn.manager.MemoryResult;
import org.simantics.sysdyn.manager.SysdynGameExperimentBase;
import org.simantics.sysdyn.simulation.SimulationJob;
import org.simantics.sysdyn.solver.ISolver;
import org.simantics.sysdyn.solver.ISolverMonitor;
import org.simantics.sysdyn.solver.InternalSolver;

public class SysdynGameExperimentInternal
extends SysdynGameExperimentBase {
    public InternalSolver solver;

    public SysdynGameExperimentInternal(Resource experiment, Resource model) {
        super(experiment, model);
    }

    @Override
    public ISolver getSolver() {
        return this.solver;
    }

    @Override
    public void init(ReadGraph g) {
        super.init(g);
        this.results = new THashMap();
        this.solver = new InternalSolver(this, this.sysdynModel, true, new ISolverMonitor(){

            @Override
            public void showConsole() {
            }

            @Override
            public void message(String message) {
                System.err.println("Internal solver:" + message);
            }

            @Override
            public void clearConsole() {
            }
        });
    }

    @Override
    public synchronized void simulate(IModelicaMonitor monitor, IProgressMonitor progressMonitor, String modelName) throws IOException {
        try {
            this.solver.initialize();
            this.solver.buildModel();
            this.subscription = this.solver.solver.keys();
            if (this.subscriptionIndexes == null) {
                this.subscriptionIndexes = new HashMap();
            }
            this.subscriptionIndexes.clear();
            int i = 0;
            while (i < this.subscription.length) {
                this.subscriptionIndexes.put(this.subscription[i], i);
                ++i;
            }
            this.currentValues = new double[this.subscription.length];
            this.clearResults();
            Simantics.getSession().syncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    Resource run = Layer0Utils.getPossibleChild((ReadGraph)graph, (Resource)SysdynGameExperimentInternal.this.experiment, (String)SysdynGameExperimentInternal.this.getIdentifier());
                    if (run == null) {
                        System.err.println("No run");
                        return;
                    }
                    Variable base = Variables.getVariable((ReadGraph)graph, (Resource)run);
                    SysdynResource SYSDYN = SysdynResource.getInstance((ReadGraph)graph);
                    Resource ic = graph.getPossibleObject(SysdynGameExperimentInternal.this.experiment, SYSDYN.Experiment_ic);
                    if (ic == null) {
                        return;
                    }
                    PartialIC data = (PartialIC)graph.getPossibleRelatedValue(ic, SYSDYN.InitialCondition_HasInitialValues, PartialIC.BINDING);
                    data.apply(graph, base);
                }
            });
            this.setSubscribedResults((IProgressMonitor)new NullProgressMonitor(), this.solver.getTime());
            ((MemoryResult)this.getCurrentResult()).setResult(new GameResult(this, (THashMap<String, TDoubleArrayList>)this.results, this.subscription));
            this.resultsChanged(true);
            this.changeState(ExperimentState.STOPPED);
        }
        catch (Exception e) {
            Logger.defaultLogError((Throwable)e);
        }
    }

    @Override
    public void refresh() {
        try {
            this.setSubscribedResults((IProgressMonitor)new NullProgressMonitor(), this.solver.getTime());
            ((MemoryResult)this.getCurrentResult()).setResult(new GameResult(this, (THashMap<String, TDoubleArrayList>)this.results, this.subscription));
            this.resultsChanged(true);
        }
        catch (Exception e) {
            Logger.defaultLogError((Throwable)e);
        }
    }

    @Override
    public void rewindTo(double time) {
        if (time > -0.001 && time < 0.001) {
            try {
                this.simulate(new SimulationJob.HeadlessModelicaMonitor(), (IProgressMonitor)new NullProgressMonitor(), this.sysdynModel.getConfiguration().getLabel());
            }
            catch (IOException e) {
                Logger.defaultLogError((Throwable)e);
            }
        } else {
            System.out.println("rewindTo");
        }
    }
}

