/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.manager;

import gnu.trove.map.hash.THashMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.fmu.FMUControlJNI;
import org.simantics.fmu.FMUJNIException;
import org.simantics.modelica.IModelicaMonitor;
import org.simantics.modelica.ModelicaManager;
import org.simantics.modelica.SimulationLocation;
import org.simantics.modeling.PartialIC;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.manager.SysdynGameExperimentBase;
import org.simantics.sysdyn.simulation.SimulationJob;
import org.simantics.sysdyn.solver.ISolver;
import org.simantics.sysdyn.solver.ModelicaSolver;

public class SysdynGameExperiment
extends SysdynGameExperimentBase {
    private ModelicaSolver solver = new ModelicaSolver(this);
    public FMUControlJNI control;
    private boolean loaded = false;
    private static boolean fortranLibrariesLoaded = false;

    public SysdynGameExperiment(Resource experiment, Resource model) {
        super(experiment, model);
    }

    public FMUControlJNI getFMUControl() {
        return this.control;
    }

    @Override
    public void init(ReadGraph g) {
        super.init(g);
        if (this.control == null) {
            this.control = new FMUControlJNI();
        }
        this.results = new THashMap();
    }

    @Override
    protected void onExperimentDisposed() {
        super.onExperimentDisposed();
        if (this.control != null) {
            try {
                this.control.unloadFMU();
                this.loaded = false;
            }
            catch (FMUJNIException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean isValidFMU(File file) {
        if (!file.exists()) {
            return false;
        }
        if (!file.isFile()) {
            return false;
        }
        return file.length() != 0L;
    }

    @Override
    public synchronized void simulate(IModelicaMonitor monitor, IProgressMonitor progressMonitor, String modelName) throws IOException {
        this.canceled = false;
        progressMonitor.subTask("Write modelica classes");
        String modelText = this.getModelicaCode(monitor, true, this.getOpenModelicaVersion());
        if (modelText == null) {
            return;
        }
        omcVersion = ModelicaManager.getDefaultOMVersion();
        monitor.message("Simulate " + modelName + " using OpenModelica " + omcVersion);
        progressMonitor.worked(1);
        progressMonitor.subTask("Write simulation files");
        HashMap<String, String> inits = this.getExperimentParameters(monitor);
        String additionalScript = this.getAdditionalScripts();
        SimulationLocation simulationLocation = this.createSimulationFiles(this.sysdynModel, modelText, inits, additionalScript, true);
        progressMonitor.worked(1);
        File fmu = null;
        if (!this.sysdynModel.isStructureModified()) {
            fmu = !simulationLocation.executableFile.isFile() ? this.loadModelFmu(simulationLocation) : simulationLocation.executableFile;
        }
        if (fmu == null && (!this.isValidFMU(simulationLocation.executableFile) || this.sysdynModel.isStructureModified())) {
            progressMonitor.subTask("Build model");
            this.buildModel(simulationLocation, monitor);
            this.previousModelStructure = modelText;
            this.saveModelFmu(simulationLocation);
        }
        progressMonitor.worked(1);
        if (simulationLocation != null && !this.canceled) {
            try {
                this.control.loadFMUFile(simulationLocation.executableFile.getAbsolutePath());
                this.loaded = true;
                this.instantiate();
            }
            catch (FMUJNIException e) {
                System.err.println("SysdynGameExperiment initialization failed:\n\t" + e.getMessage());
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        this.process = null;
        this.simulate(false);
    }

    private File loadModelFmu(SimulationLocation simulationLocation) {
        File fmu = null;
        try {
            final String fmuLocation = simulationLocation.executableFile.getAbsolutePath();
            fmu = (File)this.session.syncRequest((Read)new Read<File>(){

                public File perform(ReadGraph graph) throws DatabaseException {
                    File result;
                    block4: {
                        result = null;
                        try {
                            FileOutputStream fos = new FileOutputStream(fmuLocation);
                            byte[] fileBArray = (byte[])graph.getPossibleRelatedValue(SysdynGameExperiment.this.getModel(), SysdynResource.getInstance((ReadGraph)graph).SysdynModel_fmuFile, (Binding)Bindings.BYTE_ARRAY);
                            if (fileBArray != null) {
                                fos.write(fileBArray);
                                fos.close();
                                result = new File(fmuLocation);
                                break block4;
                            }
                            fos.close();
                            return null;
                        }
                        catch (FileNotFoundException e) {
                            e.printStackTrace();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    return result;
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        return fmu;
    }

    private void saveModelFmu(SimulationLocation simulationLocation) {
        final String fmuLocation = simulationLocation.executableFile.getAbsolutePath();
        this.session.asyncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                File file = new File(fmuLocation);
                byte[] fileBArray = new byte[(int)file.length()];
                try {
                    FileInputStream fis = new FileInputStream(file);
                    fis.read(fileBArray);
                    graph.claimLiteral(SysdynGameExperiment.this.getModel(), SysdynResource.getInstance((ReadGraph)graph).SysdynModel_fmuFile, (Object)fileBArray, (Binding)Bindings.BYTE_ARRAY);
                    fis.close();
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    public void rewindTo(double time) {
        if (this.control == null) {
            return;
        }
        if (time > -0.001 && time < 0.001) {
            try {
                this.simulate(new SimulationJob.HeadlessModelicaMonitor(), (IProgressMonitor)new NullProgressMonitor(), this.sysdynModel.getConfiguration().getLabel());
            }
            catch (IOException e) {
                Logger.defaultLogError((Throwable)e);
            }
        } else {
            System.out.println("rewindTo");
        }
    }

    @Override
    public void refresh(Session session) {
        try {
            this.control.initializeSimulation();
            this.clearResults();
        }
        catch (FMUJNIException e) {
            System.err.println("SysdynGameExperiment instantiate failed: " + e.getMessage());
        }
    }

    private synchronized void instantiate() {
        try {
            HashMap<String, String> inits = this.getExperimentParameters(null);
            this.control.setStepLength(this.stepLength);
            this.control.setTime(this.startTime);
            this.control.instantiateSimulation();
            if (!this.control.isInitialized()) {
                this.control.initializeSimulation();
            }
            this.subscription = inits.get("variableFilter") == null || inits.get("variableFilter").equals(".*") ? this.control.getAllVariables() : this.control.filterVariables(inits.get("variableFilter"));
            if (this.subscriptionIndexes == null) {
                this.subscriptionIndexes = new HashMap();
            }
            this.subscriptionIndexes.clear();
            int i = 0;
            while (i < this.subscription.length) {
                this.subscriptionIndexes.put(this.subscription[i], i);
                ++i;
            }
            this.currentValues = new double[this.subscription.length];
            this.control.subscribe(this.subscription);
            this.clearResults();
            Simantics.getSession().syncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    Resource run = Layer0Utils.getPossibleChild((ReadGraph)graph, (Resource)SysdynGameExperiment.this.experiment, (String)SysdynGameExperiment.this.getIdentifier());
                    if (run == null) {
                        System.err.println("No run");
                        return;
                    }
                    Variable base = Variables.getVariable((ReadGraph)graph, (Resource)run);
                    SysdynResource SYSDYN = SysdynResource.getInstance((ReadGraph)graph);
                    Resource ic = graph.getPossibleObject(SysdynGameExperiment.this.experiment, SYSDYN.Experiment_ic);
                    if (ic == null) {
                        return;
                    }
                    PartialIC data = (PartialIC)graph.getPossibleRelatedValue(ic, SYSDYN.InitialCondition_HasInitialValues, PartialIC.BINDING);
                    data.apply(graph, base);
                }
            });
        }
        catch (FMUJNIException e) {
            System.err.println("SysdynGameExperiment instantiate failed: " + e.getMessage());
        }
        catch (DatabaseException e) {
            System.err.println("SysdynGameExperiment instantiate failed: " + e.getMessage());
        }
    }

    @Override
    public void updateSubscriptions() {
        if (!this.loaded) {
            return;
        }
        try {
            if (this.control.isInitialized()) {
                this.currentValues = this.control.getSubscribedResults(this.currentValues);
            }
        }
        catch (FMUJNIException e) {
            e.printStackTrace();
        }
        super.updateSubscriptions();
    }

    @Override
    public ISolver getSolver() {
        return this.solver;
    }
}

