/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.manager;

import java.util.Collection;
import java.util.concurrent.Semaphore;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.PartialIC;
import org.simantics.project.IProject;
import org.simantics.simulation.experiment.ExperimentState;
import org.simantics.simulation.experiment.IDynamicExperiment;
import org.simantics.simulation.experiment.IExperiment;
import org.simantics.simulation.model.ExperimentLoadingFailed;
import org.simantics.simulation.project.IExperimentActivationListener;
import org.simantics.simulation.project.IExperimentManager;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.manager.OldSysdynExperiment;
import org.simantics.utils.DataContainer;

public class SysdynExperiments {
    public static void setPublishResults(ReadGraph graph, Variable variable, boolean value) throws DatabaseException {
        IProject project = Simantics.getProject();
        if (project == null) {
            return;
        }
        IExperimentManager experimentManager = (IExperimentManager)project.getHint(IExperimentManager.KEY_EXPERIMENT_MANAGER);
        if (experimentManager == null) {
            return;
        }
        IExperiment exp = experimentManager.getExperiment(variable.getName(graph));
        if (exp instanceof OldSysdynExperiment) {
            OldSysdynExperiment experiment = (OldSysdynExperiment)exp;
            experiment.setPublishResults(value);
        }
    }

    public static String activateExperiment(IProgressMonitor monitor, IProject project, IExperimentManager manager, Resource experimentResource) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        final SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)"Activating experiment", (int)100000);
        IExperiment[] experiments = manager.getExperiments();
        SubMonitor shutdownMon = mon.newChild(10000);
        int workPerExperiment = experiments.length > 0 ? 10000 / experiments.length : 10000;
        IExperiment[] iExperimentArray = experiments;
        int n = experiments.length;
        int n2 = 0;
        while (n2 < n) {
            IExperiment e = iExperimentArray[n2];
            if (e.getState() != ExperimentState.DISPOSED) {
                e.shutdown((IProgressMonitor)shutdownMon.newChild(workPerExperiment));
            }
            ++n2;
        }
        mon.setWorkRemaining(90000);
        final Semaphore activated = new Semaphore(0);
        final DataContainer problem = new DataContainer();
        final DataContainer run = new DataContainer();
        manager.startExperiment(experimentResource, new IExperimentActivationListener(){

            public void onExperimentActivated(IExperiment experiment) {
                activated.release();
                run.set((Object)experiment);
            }

            public void onFailure(Throwable e) {
                problem.set((Object)e);
                activated.release();
            }

            public void onMessage(IStatus message) {
            }

            public IProgressMonitor getProgressMonitor() {
                return mon;
            }
        }, true);
        try {
            activated.acquire();
            Throwable t = (Throwable)problem.get();
            if (t != null) {
                boolean cfr_ignored_0 = t instanceof ExperimentLoadingFailed;
            }
            return ((IExperiment)run.get()).getIdentifier();
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    public static String activateExperiment(Resource experiment) throws DatabaseException {
        IProject project = Simantics.getProject();
        if (project == null) {
            return null;
        }
        IExperimentManager experimentManager = (IExperimentManager)project.getHint(IExperimentManager.KEY_EXPERIMENT_MANAGER);
        if (experimentManager == null) {
            return null;
        }
        return SysdynExperiments.activateExperiment(null, project, experimentManager, experiment);
    }

    public static void run(String experimentId) throws DatabaseException {
        IProject project = Simantics.getProject();
        if (project == null) {
            return;
        }
        IExperimentManager experimentManager = (IExperimentManager)project.getHint(IExperimentManager.KEY_EXPERIMENT_MANAGER);
        if (experimentManager == null) {
            return;
        }
        IExperiment experiment = experimentManager.getExperiment(experimentId);
        if (experiment instanceof IDynamicExperiment) {
            ((IDynamicExperiment)experiment).simulate(true);
        }
    }

    private static void processChild(ReadGraph graph, Variable child, PartialIC IC) throws DatabaseException {
        System.err.println("processChild " + child.getURI(graph));
        for (Variable c : child.getChildren(graph)) {
            SysdynExperiments.processChild(graph, c, IC);
        }
        Variable values = child.getPossibleProperty(graph, "values");
        if (values == null) {
            return;
        }
        Resource represents = child.getPossibleRepresents(graph);
        if (represents == null) {
            return;
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        SysdynResource SYSDYN = SysdynResource.getInstance((ReadGraph)graph);
        Collection exprs = (Collection)graph.syncRequest((Read)new ObjectsWithType(represents, L0.ConsistsOf, SYSDYN.ParameterExpression));
        if (exprs.size() == 0) {
            return;
        }
        Variable v = values.getPossibleProperty(graph, "");
        if (v == null) {
            return;
        }
        double[][] vs = (double[][])v.getValue(graph);
        Variable value = child.getPossibleProperty(graph, "value");
        if (value == null) {
            return;
        }
        int i = 0;
        while (i < vs.length) {
            Variable target;
            double[] ds = vs[i];
            if (ds != null && (target = value.getPossibleProperty(graph, "$" + i)) != null && ds.length > 0) {
                RVI rvi = target.getRVI(graph);
                double initial = ds[0];
                System.err.println("rvi=" + rvi + " value=" + initial);
                IC.add(rvi, Variant.ofInstance((Object)initial));
            }
            ++i;
        }
    }

    public static Resource saveIC(WriteGraph graph, Variable input, String name) throws DatabaseException {
        graph.markUndoPoint();
        Resource model = Variables.getModel((ReadGraph)graph, (Variable)input);
        Resource child = Layer0Utils.getPossibleChild((ReadGraph)graph, (Resource)model, (String)name);
        SysdynResource SYSDYN = SysdynResource.getInstance((ReadGraph)graph);
        if (child != null) {
            if (graph.isInstanceOf(child, SYSDYN.InitialCondition)) {
                RemoverUtil.remove((WriteGraph)graph, (Resource)child);
            } else {
                return null;
            }
        }
        PartialIC IC = new PartialIC();
        SysdynExperiments.processChild((ReadGraph)graph, input, IC);
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        Resource ic = graph.newResource();
        graph.claim(ic, L0.InstanceOf, SYSDYN.InitialCondition);
        graph.addLiteral(ic, L0.HasName, L0.NameOf, L0.String, (Object)name, (Binding)Bindings.STRING);
        graph.addLiteral(ic, SYSDYN.InitialCondition_HasInitialValues, SYSDYN.InitialCondition_HasInitialValues_Inverse, MOD.PartialIC, (Object)IC, PartialIC.BINDING);
        graph.claim(model, L0.ConsistsOf, ic);
        Layer0Utils.addCommentMetadata((WriteGraph)graph, (String)("Saved new Initial Condition " + name + " " + ic));
        return ic;
    }

    public static void assignIC(WriteGraph graph, Variable experiment, String name) throws DatabaseException {
        graph.markUndoPoint();
        System.err.println("assignIC " + experiment.getURI((ReadGraph)graph));
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        SysdynResource SYSDYN = SysdynResource.getInstance((ReadGraph)graph);
        Resource run = experiment.getPossibleRepresents((ReadGraph)graph);
        if (run == null) {
            return;
        }
        Resource exp = graph.getPossibleObject(run, L0.PartOf);
        if (exp == null) {
            return;
        }
        Resource model = Variables.getModel((ReadGraph)graph, (Variable)experiment);
        Resource ic = Layer0Utils.getPossibleChild((ReadGraph)graph, (Resource)model, (String)name);
        if (ic == null) {
            return;
        }
        if (!graph.isInstanceOf(ic, SYSDYN.InitialCondition)) {
            return;
        }
        graph.deny(exp, SYSDYN.Experiment_ic);
        graph.claim(exp, SYSDYN.Experiment_ic, ic);
        Layer0Utils.addCommentMetadata((WriteGraph)graph, (String)("Assigned Initial Condition " + graph.getRelatedValue2(ic, L0.HasName, (Binding)Bindings.STRING) + " to experiment " + graph.getRelatedValue2(exp, L0.HasName, (Binding)Bindings.STRING)));
    }

    public static void deassignIC(WriteGraph graph, Variable experiment) throws DatabaseException {
        System.err.println("deassignIC " + experiment.getURI((ReadGraph)graph));
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        SysdynResource SYSDYN = SysdynResource.getInstance((ReadGraph)graph);
        Resource run = experiment.getPossibleRepresents((ReadGraph)graph);
        if (run == null) {
            return;
        }
        Resource exp = graph.getPossibleObject(run, L0.PartOf);
        if (exp == null) {
            return;
        }
        graph.deny(exp, SYSDYN.Experiment_ic);
    }

    public static void applyIC(WriteGraph graph, Variable experiment, String name) throws DatabaseException {
        System.err.println("applyIC " + experiment.getURI((ReadGraph)graph));
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        SysdynResource SYSDYN = SysdynResource.getInstance((ReadGraph)graph);
        Resource run = experiment.getPossibleRepresents((ReadGraph)graph);
        if (run == null) {
            return;
        }
        Resource exp = graph.getPossibleObject(run, L0.PartOf);
        if (exp == null) {
            return;
        }
        Resource model = Variables.getModel((ReadGraph)graph, (Variable)experiment);
        Resource ic = Layer0Utils.getPossibleChild((ReadGraph)graph, (Resource)model, (String)name);
        if (ic == null) {
            return;
        }
        if (!graph.isInstanceOf(ic, SYSDYN.InitialCondition)) {
            return;
        }
        Variable base = Variables.getVariable((ReadGraph)graph, (Resource)run);
        PartialIC data = (PartialIC)graph.getPossibleRelatedValue(ic, SYSDYN.InitialCondition_HasInitialValues, PartialIC.BINDING);
        data.apply(graph, base);
    }

    public static void deleteIC(WriteGraph graph, Variable input, String name) throws DatabaseException {
        graph.markUndoPoint();
        Resource model = Variables.getModel((ReadGraph)graph, (Variable)input);
        Resource child = Layer0Utils.getPossibleChild((ReadGraph)graph, (Resource)model, (String)name);
        SysdynResource SYSDYN = SysdynResource.getInstance((ReadGraph)graph);
        if (child != null && graph.isInstanceOf(child, SYSDYN.InitialCondition)) {
            RemoverUtil.remove((WriteGraph)graph, (Resource)child);
        }
        Layer0Utils.addCommentMetadata((WriteGraph)graph, (String)("Deleted Initial Condition " + graph.getRelatedValue2(child, Layer0.getInstance((ReadGraph)graph).HasName, (Binding)Bindings.STRING)));
    }
}

