/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.manager;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.IPatternMatchListener;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.console.PatternMatchEvent;
import org.eclipse.ui.console.TextConsole;
import org.simantics.sysdyn.solver.ISolverMonitor;

public class SysdynConsole
implements ISolverMonitor {
    private static String SYSDYN_CONSOLE = "Sysdyn modelica console";
    private MessageConsole console;
    public static SysdynConsole INSTANCE = new SysdynConsole();

    public SysdynConsole() {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        IConsole[] existing = conMan.getConsoles();
        int i = 0;
        while (i < existing.length) {
            if (existing[i].getName().equals(SYSDYN_CONSOLE)) {
                this.console = (MessageConsole)existing[i];
            }
            ++i;
        }
        if (this.console == null) {
            MessageConsole myConsole = new MessageConsole(SYSDYN_CONSOLE, null);
            conMan.addConsoles(new IConsole[]{myConsole});
            this.console = myConsole;
            this.console.addPatternMatchListener(new IPatternMatchListener(){

                public void matchFound(PatternMatchEvent event) {
                    try {
                        SysdynConsole.this.console.addHyperlink((IHyperlink)new IssueLink(), event.getOffset(), event.getLength());
                    }
                    catch (BadLocationException e) {
                        e.printStackTrace();
                    }
                }

                public void disconnect() {
                }

                public void connect(TextConsole console) {
                }

                public String getPattern() {
                    return "Issues view";
                }

                public String getLineQualifier() {
                    return null;
                }

                public int getCompilerFlags() {
                    return 0;
                }
            });
        }
    }

    @Override
    public void message(String message) {
        this.message(message, "hh:mm:ss");
    }

    public void message(String message, String timeStampFormat) {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat(timeStampFormat);
        String time = sdf.format(cal.getTime());
        MessageConsoleStream out = this.console.newMessageStream();
        if (message.length() > 1) {
            out.println("[" + time + "] " + message);
        }
        if (message.contains("Error")) {
            this.showConsole();
            out.println("See Issues view");
        }
    }

    @Override
    public void clearConsole() {
        this.console.clearConsole();
    }

    @Override
    public void showConsole() {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        conMan.showConsoleView((IConsole)this.console);
    }

    class IssueLink
    implements IHyperlink {
        IssueLink() {
        }

        public void linkEntered() {
        }

        public void linkExited() {
        }

        public void linkActivated() {
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.simantics.issues.ui.issueview2");
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
    }

    class ModelicaLink
    implements IHyperlink {
        ModelicaLink() {
        }

        public void linkEntered() {
        }

        public void linkExited() {
        }

        public void linkActivated() {
            System.err.println("MODELICA LINK");
        }
    }
}

