/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.manager;

import gnu.trove.set.hash.THashSet;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.locks.Lock;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.layer0.Layer0;
import org.simantics.modelica.IModelicaMonitor;
import org.simantics.modelica.ModelicaException;
import org.simantics.modelica.ModelicaKeys;
import org.simantics.modelica.ModelicaManager;
import org.simantics.modelica.SimulationLocation;
import org.simantics.modelica.data.CSVSimulationResult;
import org.simantics.modelica.data.MatSimulationResult;
import org.simantics.modelica.data.SimulationResult;
import org.simantics.modelica.preferences.OpenModelicaPreferences;
import org.simantics.simulation.data.Datasource;
import org.simantics.simulation.experiment.ExperimentState;
import org.simantics.simulation.experiment.IExperimentListener;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.sysdyn.Activator;
import org.simantics.sysdyn.adapter.VariableValueSubscription;
import org.simantics.sysdyn.manager.FunctionUtils;
import org.simantics.sysdyn.manager.MemoryResult;
import org.simantics.sysdyn.manager.SaveResultJob;
import org.simantics.sysdyn.manager.SysdynExperiment;
import org.simantics.sysdyn.manager.SysdynModel;
import org.simantics.sysdyn.manager.SysdynModelManager;
import org.simantics.sysdyn.manager.SysdynResult;
import org.simantics.sysdyn.modelica.ModelicaWriter;
import org.simantics.sysdyn.representation.Configuration;
import org.simantics.sysdyn.representation.Model;
import org.simantics.sysdyn.simulation.SimulationScheduler;

public class OldSysdynExperiment
extends SysdynExperiment {
    protected Session session;
    protected Runnable modificationListener;
    protected SysdynModel sysdynModel;
    protected boolean toggled = false;
    protected THashSet<VariableValueSubscription> variableValueSubscriptions = new THashSet();
    protected volatile VariableValueSubscription[] variableValueSubscriptionsSnapshot = null;
    protected String previousModelStructure;
    protected HashMap<String, String> previousParameters;
    protected Process process;
    protected boolean canceled = false;
    protected ExperimentState sysdynExperimentState;
    private SysdynResult result;
    private File simulationDir;
    protected String experimentName;
    protected static String omcVersion = null;
    protected static String omcHome = null;
    public static OldSysdynExperiment INSTANCE;
    boolean publishResults = true;
    volatile long previousVariableUpdateTime = 0L;
    volatile boolean skippedVariableUpdate = true;

    public OldSysdynExperiment(Resource experiment, Resource model) {
        super(experiment, model);
        INSTANCE = this;
    }

    public static OldSysdynExperiment getInstance() {
        return INSTANCE;
    }

    @Override
    public SysdynResult getCurrentResult() {
        if (this.result == null) {
            this.result = new MemoryResult(null, null);
        }
        return this.result;
    }

    @Override
    public Collection<SysdynResult> getActiveResults() {
        ArrayList<SysdynResult> result = new ArrayList<SysdynResult>();
        if (this.getCurrentResult() != null) {
            result.add(this.getCurrentResult());
        }
        result.addAll(this.sysdynModel.getDisplayedResults());
        return result;
    }

    @Override
    public void init(ReadGraph g) {
        try {
            this.experimentName = NameUtils.getSafeName((ReadGraph)g, (Resource)this.experiment);
        }
        catch (DatabaseException e) {
            this.experimentName = "Experiment";
        }
        this.session = g.getSession();
        this.state = ExperimentState.STOPPED;
        IExperimentListener[] iExperimentListenerArray = (IExperimentListener[])this.listeners.getListeners();
        int n = iExperimentListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExperimentListener listener = iExperimentListenerArray[n2];
            listener.stateChanged(this.state);
            ++n2;
        }
        try {
            g.syncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    Resource configuration = graph.getPossibleObject(OldSysdynExperiment.this.model, SimulationResource.getInstance((ReadGraph)graph).HasConfiguration);
                    OldSysdynExperiment.this.sysdynModel = SysdynModelManager.getInstance(OldSysdynExperiment.this.session).getModel(graph, configuration);
                    OldSysdynExperiment.this.toggleActivation(graph, true);
                }
            });
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((Throwable)e);
        }
        this.setSysdynExperimentState(ExperimentState.INITIALIZING);
    }

    @Override
    public void saveState() {
        if (this.result == null || !(this.result instanceof MemoryResult)) {
            return;
        }
        SaveResultJob saveResultJob = new SaveResultJob(this, this.session, (MemoryResult)this.result);
        saveResultJob.schedule();
    }

    @Override
    protected Thread getSaveThread(final SysdynResult result, final File file, final IProgressMonitor progressMonitor) {
        return new Thread(){

            @Override
            public void run() {
                if (!OldSysdynExperiment.this.canceled) {
                    result.saveToFile(file, progressMonitor);
                }
            }
        };
    }

    @Override
    public void simulate(boolean enabled) {
        if (enabled && this.sysdynModel != null) {
            if (!ExperimentState.RUNNING.equals((Object)this.getState())) {
                this.changeState(ExperimentState.RUNNING);
                this.startSimulationJob();
            }
        } else if (!this.toggled) {
            this.changeState(ExperimentState.STOPPED);
        }
    }

    protected void startSimulationJob() {
        this.session.asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                SimulationScheduler.start(OldSysdynExperiment.this.sysdynModel, OldSysdynExperiment.this);
            }
        });
    }

    protected String getModelicaCode(IModelicaMonitor monitor, boolean isGame, String modelicaVersion) {
        String modelText = null;
        try {
            modelText = ModelicaWriter.write(this.sysdynModel.getModules(), this.sysdynModel.getConfiguration().getModel().getStartTime(), isGame, modelicaVersion);
        }
        catch (Exception e) {
            this.simulate(false);
            monitor.showConsole();
            monitor.message("Error when writing Modelica code.");
        }
        return modelText;
    }

    protected HashMap<String, String> getExperimentParameters(IModelicaMonitor monitor) {
        String variableFilter;
        Configuration configuration = this.sysdynModel.getConfiguration();
        HashMap<String, String> parameters = new HashMap<String, String>();
        Model model = configuration.getModel();
        Double startTime = model.getStartTime();
        Double stopTime = model.getStopTime();
        parameters.put(ModelicaKeys.START_VALUE, startTime.toString());
        parameters.put(ModelicaKeys.STOP_VALUE, stopTime.toString());
        String outputFormat = "mat";
        parameters.put(ModelicaKeys.OUTPUT_FORMAT, outputFormat);
        Double simulationStepLength = model.getSimulationStepLength();
        if (simulationStepLength != null) {
            parameters.put(ModelicaKeys.STEP_VALUE, simulationStepLength.toString());
            parameters.put(ModelicaKeys.NUMBER_OF_INTERVALS, "" + (int)((stopTime - startTime) / simulationStepLength));
        } else {
            parameters.put(ModelicaKeys.STEP_VALUE, "" + (stopTime - startTime) / 500.0);
        }
        Double outputInterval = model.getOutputInterval();
        parameters.put(ModelicaKeys.OUTPUT_INTERVAL, outputInterval != null ? outputInterval.toString() : (String)parameters.get(ModelicaKeys.STEP_VALUE));
        String method = "\"" + model.getSolver() + "\"";
        parameters.put(ModelicaKeys.METHOD, method);
        if (model.getTolerance() != null) {
            parameters.put(ModelicaKeys.TOLERANCE, model.getTolerance().toString());
        }
        if ((variableFilter = model.getVariableFilter()) != null && !variableFilter.isEmpty()) {
            parameters.put(ModelicaKeys.VARIABLE_FILTER, variableFilter);
        }
        return parameters;
    }

    protected void buildModel(SimulationLocation simulationLocation, IModelicaMonitor monitor) {
        try {
            simulationLocation.executableFile.delete();
            ModelicaManager.buildModel((SimulationLocation)simulationLocation, (IModelicaMonitor)monitor);
        }
        catch (ModelicaException e) {
            if (e.getMessage() != null) {
                monitor.message(e.getMessage());
            }
            monitor.showConsole();
            this.canceled = true;
            this.previousModelStructure = "";
            this.previousParameters = null;
        }
    }

    protected void runModelica(SimulationLocation simulationLocation, IModelicaMonitor monitor, IProgressMonitor progressMonitor, HashMap<String, String> experimentParameters, HashMap<String, String> changes) throws IOException {
        progressMonitor.subTask("Simulate model");
        this.process = ModelicaManager.runModelica((SimulationLocation)simulationLocation, (IModelicaMonitor)monitor, experimentParameters, changes);
        ModelicaManager.printProcessOutput((Process)this.process, (IModelicaMonitor)monitor);
        Thread resultThread = this.getResultThread(simulationLocation, experimentParameters, monitor, progressMonitor);
        resultThread.run();
        this.process = null;
    }

    protected Thread getResultThread(final SimulationLocation simulationLocation, final HashMap<String, String> experimentParameters, final IModelicaMonitor monitor, final IProgressMonitor progressMonitor) {
        return new Thread(){

            @Override
            public void run() {
                try {
                    OldSysdynExperiment.this.process.waitFor();
                    if (!OldSysdynExperiment.this.canceled) {
                        progressMonitor.worked(1);
                        progressMonitor.subTask("Read results");
                        Object result = simulationLocation.resultFile.getName().endsWith(".csv") ? new CSVSimulationResult() : (simulationLocation.resultFile.getName().endsWith(".plt") ? new SimulationResult() : new MatSimulationResult());
                        int outIntervalInt = 1;
                        String outputInterval = (String)experimentParameters.get(ModelicaKeys.OUTPUT_INTERVAL);
                        if (outputInterval != null) {
                            int maxIntervalInt;
                            String stepTime = (String)experimentParameters.get(ModelicaKeys.STEP_VALUE);
                            String stopTime = (String)experimentParameters.get(ModelicaKeys.STOP_VALUE);
                            Double step = Double.parseDouble(stepTime);
                            Double stop = Double.parseDouble(stopTime);
                            Double outInterval = Double.parseDouble(outputInterval);
                            outIntervalInt = (int)OldSysdynExperiment.getInterval(outInterval, step);
                            if (outIntervalInt > (maxIntervalInt = (int)Math.round(stop / step))) {
                                outIntervalInt = maxIntervalInt;
                            }
                        }
                        result.initRead(simulationLocation.resultFile);
                        result.readTime(simulationLocation.resultFile, outIntervalInt);
                        result.filter();
                        ((MemoryResult)OldSysdynExperiment.this.getCurrentResult()).setResult((SimulationResult)result);
                        ((MemoryResult)OldSysdynExperiment.this.getCurrentResult()).setResultFile(simulationLocation.resultFile);
                        progressMonitor.worked(1);
                        OldSysdynExperiment.this.resultsChanged();
                        OldSysdynExperiment.this.simulate(false);
                        String errorString = result.getResultReadErrors();
                        if (errorString != null && !errorString.isEmpty()) {
                            monitor.message(errorString);
                        }
                    }
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        };
    }

    protected static long getInterval(double outputLength, double stepLength) {
        double interval = outputLength / stepLength;
        if (interval <= 1.0) {
            return 1L;
        }
        return Math.round(interval);
    }

    protected SimulationLocation createSimulationFiles(SysdynModel sysdynModel, String modelText, HashMap<String, String> inits, String additionalScript, boolean fmu) throws IOException {
        File simulationDir = this.getExperimentDir();
        FunctionUtils.updateFunctionFilesForExperiment(this);
        SimulationLocation location = ModelicaManager.createSimulationLocation((File)simulationDir, (String)sysdynModel.getConfiguration().getLabel(), (String)modelText, (File)ModelicaManager.getOMHome(), (boolean)ModelicaManager.isOldOMVersion());
        if (fmu) {
            ModelicaManager.createFMUSimulationScripts((SimulationLocation)location, inits, (String)additionalScript);
        } else {
            ModelicaManager.createSimulationScripts((SimulationLocation)location, inits, (String)additionalScript);
        }
        return location;
    }

    @Override
    public File getExperimentDir() {
        if (this.simulationDir == null) {
            File modelsDir = Activator.getBundleContext().getDataFile("models");
            String experimentName = this.experimentName;
            List<String> files = Arrays.asList(modelsDir.list());
            if (files.contains(experimentName)) {
                int i = 2;
                while (files.contains(String.valueOf(experimentName) + "_" + i)) {
                    ++i;
                }
                experimentName = String.valueOf(experimentName) + "_" + i;
            }
            this.simulationDir = Activator.getBundleContext().getDataFile("models/" + experimentName);
            if (!this.simulationDir.exists()) {
                this.simulationDir.mkdir();
            }
        }
        return this.simulationDir;
    }

    protected String getAdditionalScripts() {
        StringBuilder functionscript = new StringBuilder();
        for (String path : FunctionUtils.getLibraryPathsForModelica(this)) {
            functionscript.append("loadFile(\"" + path + "\");\n");
        }
        return functionscript.toString();
    }

    public synchronized void simulate(IModelicaMonitor monitor, IProgressMonitor progressMonitor, String modelName) throws IOException {
        HashMap<String, String> changes;
        this.canceled = false;
        progressMonitor.subTask("Write modelica classes");
        omcVersion = ModelicaManager.getDefaultOMVersion();
        monitor.message("Simulate " + modelName + " using OpenModelica " + omcVersion);
        String modelText = this.getModelicaCode(monitor, false, omcVersion);
        if (modelText == null) {
            return;
        }
        progressMonitor.worked(1);
        progressMonitor.subTask("Write simulation files");
        HashMap<String, String> experimentParameters = this.getExperimentParameters(monitor);
        String additionalScript = this.getAdditionalScripts();
        SimulationLocation simulationLocation = this.createSimulationFiles(this.sysdynModel, modelText, experimentParameters, additionalScript, false);
        progressMonitor.worked(1);
        String flatModelText = ModelicaManager.getFlatModelText((SimulationLocation)simulationLocation, (IModelicaMonitor)monitor, FunctionUtils.getLibraryPathsForModelica(this));
        boolean structureChanged = this.sysdynModel.isStructureModified();
        if (!simulationLocation.executableFile.isFile() || structureChanged) {
            progressMonitor.subTask("Build model");
            this.previousModelStructure = flatModelText;
            this.previousParameters = ModelicaManager.getModelParameters((String)this.previousModelStructure);
            this.buildModel(simulationLocation, monitor);
        }
        HashMap<String, String> hashMap = changes = structureChanged ? null : new HashMap<String, String>();
        if (!structureChanged && this.previousParameters != null && omcVersion.startsWith("1.9")) {
            HashMap newParameters = ModelicaManager.getModelParameters((String)flatModelText);
            for (String key : this.previousParameters.keySet()) {
                if (this.previousParameters.get(key).equals(newParameters.get(key))) continue;
                changes.put(key, (String)newParameters.get(key));
            }
            this.previousParameters = newParameters;
        }
        progressMonitor.worked(1);
        if (simulationLocation != null && !this.canceled) {
            this.runModelica(simulationLocation, monitor, progressMonitor, experimentParameters, changes);
        }
        if (this.canceled) {
            this.simulate(false);
        }
        this.process = null;
    }

    protected String getOpenModelicaVersion() {
        File omHomeDir;
        String omVersion = null;
        IScopeContext context = DefaultScope.INSTANCE;
        IEclipsePreferences node = context.getNode("org.simantics.modelica");
        String omHome = node.get(OpenModelicaPreferences.OM_HOME, null);
        if (omHome != null && (omHomeDir = new File(omHome)) != null && omHomeDir.isDirectory()) {
            omVersion = ModelicaManager.getOMVersion((File)omHomeDir);
        }
        if (omVersion == null) {
            omVersion = ModelicaManager.getDefaultOMVersion();
        }
        return omVersion;
    }

    @Override
    public void cancelSimulation() {
        this.canceled = true;
        if (this.process != null) {
            this.process.destroy();
        }
    }

    @Override
    public void toggleSimulation(boolean enabled) {
        if (enabled) {
            this.toggled = true;
            this.changeState(ExperimentState.RUNNING);
            if (this.modificationListener == null) {
                this.modificationListener = new Runnable(){

                    @Override
                    public void run() {
                        OldSysdynExperiment.this.session.asyncRequest((Read)new ReadRequest(){

                            public void run(ReadGraph graph) throws DatabaseException {
                                if (OldSysdynExperiment.this.getState() == ExperimentState.RUNNING) {
                                    SimulationScheduler.start((this).OldSysdynExperiment.this.sysdynModel, OldSysdynExperiment.this);
                                }
                            }
                        });
                    }
                };
                this.sysdynModel.addModificationListener(this.modificationListener);
            }
        } else {
            this.changeState(ExperimentState.STOPPED);
            this.toggled = false;
        }
    }

    @Override
    public void refresh(RequestProcessor session) {
        session.asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                OldSysdynExperiment.this.init(graph);
            }
        });
    }

    @Override
    public void refresh(Session session) {
        this.refresh((RequestProcessor)session);
    }

    @Override
    protected void localStateChange() {
        this.setSysdynExperimentState(this.getState());
        switch (this.state) {
            case DISPOSED: {
                this.onExperimentDisposed();
                break;
            }
        }
    }

    @Override
    public ExperimentState getSysdynExperimentState() {
        return this.sysdynExperimentState;
    }

    @Override
    protected void setSysdynExperimentState(final ExperimentState state) {
        this.sysdynExperimentState = state;
        this.session.asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                VirtualGraphSupport support = (VirtualGraphSupport)graph.getService(VirtualGraphSupport.class);
                Session session = graph.getSession();
                session.asyncRequest((Write)new WriteRequest(support.getWorkspacePersistent("experiments")){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                        SimulationResource SR = SimulationResource.getInstance((ReadGraph)graph);
                        graph.deny(OldSysdynExperiment.this.model, SR.HasExperimentState);
                        graph.deny(OldSysdynExperiment.this.experiment, SR.HasExperimentState);
                        Resource st = graph.newResource();
                        switch (state) {
                            case INITIALIZING: {
                                graph.claim(st, L0.InstanceOf, SR.ExperimentState_Initializing);
                                break;
                            }
                            case RUNNING: {
                                graph.claim(st, L0.InstanceOf, SR.ExperimentState_Running);
                                break;
                            }
                            case STOPPED: {
                                graph.claim(st, L0.InstanceOf, SR.ExperimentState_Stopped);
                                break;
                            }
                            case DISPOSED: {
                                graph.claim(st, L0.InstanceOf, SR.ExperimentState_Disposed);
                            }
                        }
                        graph.claim(OldSysdynExperiment.this.model, SR.HasExperimentState, st);
                        graph.claim(OldSysdynExperiment.this.experiment, SR.HasExperimentState, st);
                    }
                });
            }
        });
    }

    @Override
    protected void onExperimentDisposed() {
        this.cancelSimulation();
        this.sysdynModel.removeModificationListener(this.modificationListener);
        this.modificationListener = null;
        this.session.asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                OldSysdynExperiment.this.toggleActivation(graph, false);
            }
        });
    }

    @Override
    protected void toggleActivation(ReadGraph graph, final boolean activate) {
        VirtualGraphSupport support = (VirtualGraphSupport)graph.getService(VirtualGraphSupport.class);
        final Session session = graph.getSession();
        session.asyncRequest((Write)new WriteRequest(support.getWorkspacePersistent("experiments")){

            public void perform(WriteGraph graph) throws DatabaseException {
                VirtualGraph runtime = (VirtualGraph)graph.getService(VirtualGraph.class);
                session.asyncRequest((Write)new WriteRequest(runtime){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
                        if (activate) {
                            graph.claim(OldSysdynExperiment.this.experiment, SIMU.IsActive, OldSysdynExperiment.this.experiment);
                        } else {
                            graph.denyStatement(OldSysdynExperiment.this.experiment, SIMU.IsActive, OldSysdynExperiment.this.experiment);
                        }
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addVariableValueSubscription(VariableValueSubscription subscription) {
        assert (subscription != null);
        THashSet<VariableValueSubscription> tHashSet = this.variableValueSubscriptions;
        synchronized (tHashSet) {
            this.variableValueSubscriptions.add((Object)subscription);
            this.variableValueSubscriptionsSnapshot = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeVariableValueSubscription(VariableValueSubscription subscription) {
        assert (subscription != null);
        THashSet<VariableValueSubscription> tHashSet = this.variableValueSubscriptions;
        synchronized (tHashSet) {
            this.variableValueSubscriptions.remove((Object)subscription);
            this.variableValueSubscriptionsSnapshot = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VariableValueSubscription[] getListenerSnapshot() {
        VariableValueSubscription[] snapshot = this.variableValueSubscriptionsSnapshot;
        if (snapshot == null) {
            THashSet<VariableValueSubscription> tHashSet = this.variableValueSubscriptions;
            synchronized (tHashSet) {
                snapshot = this.variableValueSubscriptionsSnapshot;
                if (snapshot == null) {
                    this.variableValueSubscriptionsSnapshot = (VariableValueSubscription[])this.variableValueSubscriptions.toArray((Object[])new VariableValueSubscription[this.variableValueSubscriptions.size()]);
                    snapshot = this.variableValueSubscriptionsSnapshot;
                }
            }
        }
        return snapshot;
    }

    @Override
    public void resultsChanged() {
        this.resultsChanged(false);
    }

    public void setPublishResults(boolean value) {
        this.publishResults = value;
        if (this.publishResults) {
            this.resultsChanged(true);
        }
    }

    public void resultsChanged(boolean force) {
        long time = System.nanoTime();
        long sinceLast = time - this.previousVariableUpdateTime;
        if (sinceLast > 100000000L || force) {
            this.updateSubscriptions();
            this.previousVariableUpdateTime = time;
        } else {
            this.skippedVariableUpdate = true;
        }
    }

    @Override
    public void updateSubscriptions() {
        if (!this.publishResults) {
            return;
        }
        VariableValueSubscription[] variableValueSubscriptionArray = this.getListenerSnapshot();
        int n = variableValueSubscriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            VariableValueSubscription subscription = variableValueSubscriptionArray[n2];
            subscription.update();
            ++n2;
        }
        this.skippedVariableUpdate = false;
    }

    public int numberOfSimulationRunSteps() {
        return 5;
    }

    @Override
    public Lock getDatasourceLock() {
        return null;
    }

    @Override
    public Datasource getDatasource() {
        return null;
    }

    @Override
    public void simulateDuration(double duration) {
        System.out.println("simulateDuartion");
    }

    @Override
    public void rewindTo(double time) {
        System.out.println("rewindTo");
    }
}

