/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.adapter;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.ExternalRead;
import org.simantics.db.request.Write;
import org.simantics.db.service.QueryControl;
import org.simantics.sysdyn.adapter.IndexVariable;
import org.simantics.utils.datastructures.Callback;

public class VariableValueSubscription<T> {
    public static final long SUBSCRIPTION_COLLECTION_INTERVAL = 2000L;
    protected ExternalRead<?> request;
    protected IndexVariable<T> variable;
    protected Listener<T> listener;
    protected AtomicBoolean excepted = new AtomicBoolean(false);

    public VariableValueSubscription(ExternalRead<?> request, IndexVariable<T> variable, Listener<T> listener) {
        this.request = request;
        this.variable = variable;
        this.listener = listener;
    }

    public ExternalRead<?> getRequest() {
        return this.request;
    }

    public void update() {
        try {
            T value = this.variable.getValue();
            this.fireValue(value);
        }
        catch (Throwable e) {
            this.fireException(e);
        }
    }

    void fireValue(T value) {
        if (this.listener != null) {
            this.listener.execute(value);
        }
    }

    void fireException(Throwable t) {
        if (this.listener != null && this.excepted.compareAndSet(false, true)) {
            this.listener.exception(t);
        } else {
            Logger.defaultLogError((Throwable)t);
        }
    }

    public void setListener(Listener<T> listener) {
        this.listener = listener;
    }

    public static void collectSubscriptions(Session session, final VariableValueSubscription[] subscriptions, final ExternalRead<?> ... extraReads) {
        if (subscriptions.length == 0 && extraReads.length == 0) {
            return;
        }
        session.asyncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                ArrayList<Object> requests = new ArrayList<Object>(subscriptions.length + extraReads.length);
                VariableValueSubscription[] variableValueSubscriptionArray = subscriptions;
                int n = subscriptions.length;
                int n2 = 0;
                while (n2 < n) {
                    VariableValueSubscription subscription = variableValueSubscriptionArray[n2];
                    requests.add(subscription.getRequest());
                    ++n2;
                }
                variableValueSubscriptionArray = extraReads;
                n = extraReads.length;
                n2 = 0;
                while (n2 < n) {
                    VariableValueSubscription read = variableValueSubscriptionArray[n2];
                    requests.add(read);
                    ++n2;
                }
                ((QueryControl)graph.getService(QueryControl.class)).gc(graph, requests);
            }
        }, (Callback)new Callback<DatabaseException>(){

            public void run(DatabaseException e) {
                if (e != null) {
                    e.printStackTrace();
                }
            }
        });
    }
}

