/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.adapter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.manager.SysdynDataSet;

public class VariableRVIUtils {
    private static void traverseIndexes(ReadGraph g, String rvi, HashMap<String, String> rvis, List<Resource> arrayIndexes) throws DatabaseException {
        VariableRVIUtils.traverseIndexes(g, rvi, rvis, arrayIndexes, 0, "", "");
    }

    private static void traverseIndexes(ReadGraph g, String rvi, HashMap<String, String> rvis, List<Resource> arrayIndexes, int currentIndex, String indexesSoFar, String indexNamesSoFar) throws DatabaseException {
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)g);
        Resource enumerationIndexes = g.getPossibleObject(arrayIndexes.get(currentIndex), sr.Enumeration_enumerationIndexList);
        if (enumerationIndexes == null) {
            return;
        }
        List indexes = ListUtils.toList((ReadGraph)g, (Resource)enumerationIndexes);
        int i = 0;
        while (i < indexes.size()) {
            Boolean b = (Boolean)g.getPossibleRelatedValue((Resource)indexes.get(i), sr.EnumerationIndex_showEnumerationIndexInCharts, (Binding)Bindings.BOOLEAN);
            if (Boolean.TRUE.equals(b)) {
                String name = (String)g.getRelatedValue((Resource)indexes.get(i), Layer0.getInstance((ReadGraph)g).HasName);
                if (currentIndex < arrayIndexes.size() - 1) {
                    VariableRVIUtils.traverseIndexes(g, rvi, rvis, arrayIndexes, currentIndex + 1, String.valueOf(indexesSoFar) + (i + 1) + ",", String.valueOf(indexNamesSoFar) + name + ",");
                } else {
                    rvis.put(String.valueOf(rvi) + "[" + indexesSoFar + (i + 1) + "]", String.valueOf(rvi) + "[" + indexNamesSoFar + name + "]");
                }
            }
            ++i;
        }
    }

    private static List<Resource> resolveActiveArrayIndexes(ReadGraph graph, Variable variable, List<Resource> enumerations) {
        try {
            Resource module;
            Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
            SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
            String uri = variable.getURI(graph);
            uri = uri.substring(0, uri.lastIndexOf("/"));
            Variable v = Variables.getPossibleVariable((ReadGraph)graph, (String)uri);
            if (v != null && (module = v.getRepresents(graph)) != null && graph.isInheritedFrom(graph.getSingleObject(module, l0.InstanceOf), sr.Module)) {
                boolean somethingIsReplaced = false;
                for (Resource redeclaration : (Collection)graph.syncRequest((Read)new ObjectsWithType(module, sr.Module_redeclaration, sr.Redeclaration))) {
                    Resource replaced = graph.getSingleObject(redeclaration, sr.Redeclaration_replacedEnumeration);
                    while (enumerations.contains(replaced)) {
                        enumerations.add(enumerations.indexOf(replaced), graph.getSingleObject(redeclaration, sr.Redeclaration_replacingEnumeration));
                        enumerations.remove(replaced);
                        somethingIsReplaced = true;
                    }
                }
                if (somethingIsReplaced) {
                    VariableRVIUtils.resolveActiveArrayIndexes(graph, v, enumerations);
                }
            }
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        return enumerations;
    }

    public static HashMap<String, String> getActiveRVIs(ReadGraph graph, Variable variable) throws DatabaseException {
        LinkedHashMap<String, String> rvis = new LinkedHashMap<String, String>();
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
        String rvi = Variables.getRVI((ReadGraph)graph, (Variable)variable);
        Resource r = variable.getRepresents(graph);
        Resource arrayIndexes = graph.getPossibleObject(r, sr.Variable_arrayIndexesList);
        if (arrayIndexes == null) {
            rvis.put(rvi, rvi);
        } else {
            List arrayIndexList = ListUtils.toList((ReadGraph)graph, (Resource)arrayIndexes);
            VariableRVIUtils.resolveActiveArrayIndexes(graph, variable, arrayIndexList);
            if (arrayIndexList.size() > 0) {
                VariableRVIUtils.traverseIndexes(graph, rvi, rvis, arrayIndexList);
            } else {
                rvis.put(rvi, rvi);
            }
        }
        return rvis;
    }

    public static ArrayList<SysdynDataSet> getDataset(ArrayList<SysdynDataSet> datasets, String[] filter) {
        boolean doFiltering = false;
        String[] stringArray = filter;
        int n = filter.length;
        int n2 = 0;
        while (n2 < n) {
            String f = stringArray[n2];
            if (!f.equalsIgnoreCase("All")) {
                doFiltering = true;
                break;
            }
            ++n2;
        }
        if (!doFiltering) {
            return datasets;
        }
        ArrayList<SysdynDataSet> result = datasets;
        int i = filter.length - 1;
        while (i >= 0) {
            String currentFilter = filter[i].trim();
            ArrayList<SysdynDataSet> tempResult = new ArrayList<SysdynDataSet>();
            HashMap<String, SysdynDataSet> sums = new HashMap<String, SysdynDataSet>();
            for (SysdynDataSet dataset : result) {
                String tempIndexes = dataset.name.substring(dataset.name.indexOf(91) + 1, dataset.name.indexOf(93));
                String[] indexes = tempIndexes.split(",");
                if (currentFilter.equals("All")) {
                    tempResult.add(dataset);
                    continue;
                }
                if (currentFilter.equals(indexes[i].trim())) {
                    tempResult.add(dataset);
                    continue;
                }
                if (!currentFilter.equals("Sum")) continue;
                String rangeBefore = "";
                int j = 0;
                while (j < i) {
                    rangeBefore = String.valueOf(rangeBefore) + indexes[j].trim();
                    ++j;
                }
                SysdynDataSet sum = (SysdynDataSet)((Object)sums.get(rangeBefore));
                if (sum != null) {
                    int j2 = 0;
                    while (j2 < sum.values.length) {
                        sum.values[j2] = sum.values[j2] + dataset.values[j2];
                        ++j2;
                    }
                    continue;
                }
                double[] times = new double[dataset.times.length];
                int j3 = 0;
                while (j3 < dataset.times.length) {
                    times[j3] = dataset.times[j3];
                    ++j3;
                }
                double[] values = new double[dataset.values.length];
                int j4 = 0;
                while (j4 < dataset.values.length) {
                    values[j4] = dataset.values[j4];
                    ++j4;
                }
                SysdynDataSet newDataset = new SysdynDataSet(dataset.name, dataset.result, times, values);
                tempResult.add(newDataset);
                sums.put(rangeBefore, newDataset);
                String name = newDataset.name.substring(0, newDataset.name.indexOf(91) + 1);
                int j5 = 0;
                while (j5 < indexes.length) {
                    if (j5 < i) {
                        name = String.valueOf(name) + indexes[j5].trim();
                    } else if (j5 >= i) {
                        name = String.valueOf(name) + filter[j5].trim();
                    }
                    if (j5 < indexes.length - 1) {
                        name = String.valueOf(name) + ", ";
                    }
                    ++j5;
                }
                newDataset.name = name = String.valueOf(name) + "]";
            }
            result.clear();
            for (SysdynDataSet dataset : tempResult) {
                result.add(dataset);
            }
            --i;
        }
        return result;
    }
}

