/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.adapter;

import java.util.ArrayList;
import java.util.Collection;
import org.simantics.db.ReadGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.sysdyn.adapter.IndexVariable;
import org.simantics.sysdyn.manager.SysdynDataSet;
import org.simantics.sysdyn.manager.SysdynGameExperimentBase;
import org.simantics.sysdyn.manager.SysdynResult;

public class ValuesIndexVariable
extends IndexVariable<double[][]> {
    public ValuesIndexVariable(ReadGraph graph, Variable parent, String indexes) throws DatabaseException {
        super(graph, parent, indexes);
    }

    @Override
    public double[][] getValue() {
        ArrayList<String> variableNames = this.getVariableNamesWithIndexNumbers();
        double[][] result = new double[variableNames.size()][];
        if (this.experiment != null) {
            Collection<SysdynResult> results = this.experiment.getActiveResults();
            int i = 0;
            while (i < variableNames.size()) {
                for (SysdynResult r : results) {
                    SysdynDataSet ds = r.getDataSet(variableNames.get(i));
                    if (ds != null && ds.values != null) {
                        double d;
                        result[i] = new double[ds.values.length];
                        int j = 0;
                        while (j < ds.values.length) {
                            result[i][j] = ds.values[j];
                            ++j;
                        }
                        if (!(this.experiment instanceof SysdynGameExperimentBase) || ds.result != null) break;
                        result[i][ds.values.length - 1] = d = ((SysdynGameExperimentBase)this.experiment).getCurrentValue(variableNames.get(i)).doubleValue();
                        break;
                    }
                    if (result[i] != null) continue;
                    result[i] = new double[0];
                }
                ++i;
            }
        }
        return result;
    }

    @Override
    public void setIndexedValue(WriteGraph graph, Object value) throws DatabaseException {
    }
}

