/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.adapter;

import java.util.ArrayList;
import java.util.Collection;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.simulation.experiment.ExperimentState;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.adapter.IndexVariable;
import org.simantics.sysdyn.manager.SysdynDataSet;
import org.simantics.sysdyn.manager.SysdynGameExperimentBase;
import org.simantics.sysdyn.manager.SysdynResult;
import org.simantics.sysdyn.solver.ISolver;

public abstract class ValueIndexVariableBase<T>
extends IndexVariable<T> {
    public static double[] UNRESOLVED = new double[0];

    public ValueIndexVariableBase(ReadGraph graph, Variable parent, String indexes) throws DatabaseException {
        super(graph, parent, indexes);
    }

    public double[] getValueFull() {
        if (this.experiment == null) {
            return UNRESOLVED;
        }
        Collection<SysdynResult> results = this.experiment.getActiveResults();
        ArrayList<String> variableNames = this.getVariableNamesWithIndexNumbers();
        double[] result = new double[variableNames.size()];
        int i = 0;
        while (i < variableNames.size()) {
            for (SysdynResult r : results) {
                if (this.experiment instanceof SysdynGameExperimentBase) {
                    Double d = ((SysdynGameExperimentBase)this.experiment).getCurrentValue(variableNames.get(i));
                    result[i] = d != null ? d : 0.0;
                    continue;
                }
                SysdynDataSet ds = r.getDataSet(variableNames.get(i));
                if (ds != null && ds.values != null && ds.values.length > 0) {
                    result[i] = ds.values[ds.values.length - 1];
                    continue;
                }
                return UNRESOLVED;
            }
            ++i;
        }
        return result;
    }

    @Override
    public void setIndexedValue(WriteGraph graph, Object value) throws DatabaseException {
        Variable var = this.parent.getParent((ReadGraph)graph);
        Resource resource = var.getRepresents((ReadGraph)graph);
        if (!(value instanceof Double) && !(value instanceof double[]) || resource == null) {
            return;
        }
        double[] values = null;
        if (value instanceof Double) {
            values = new double[]{(Double)value};
        } else if (value instanceof double[]) {
            values = (double[])value;
        }
        if (this.experiment instanceof SysdynGameExperimentBase) {
            SysdynGameExperimentBase exp = (SysdynGameExperimentBase)this.experiment;
            ExperimentState state = exp.getSysdynExperimentState();
            if (!ExperimentState.RUNNING.equals((Object)state) && !ExperimentState.STOPPED.equals((Object)state)) {
                return;
            }
            ISolver solver = exp.getSolver();
            try {
                ArrayList<String> variableNames = this.getVariableNamesWithIndexNumbers();
                int i = 0;
                while (i < variableNames.size() && i < values.length) {
                    if (values[i] != Double.NaN) {
                        String name = variableNames.get(i);
                        solver.setRealValue(name, values[i]);
                        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                        for (Resource dependency : graph.getObjects(resource, sr.Variable_isTailOf)) {
                            Resource head = graph.getPossibleObject(dependency, sr.Variable_HasHead);
                            Resource ref = graph.getPossibleObject(dependency, sr.Dependency_refersTo);
                            if (ref == null || head == null) continue;
                            String module = "";
                            if (name.indexOf(".") > 0) {
                                module = name.substring(0, name.lastIndexOf(".") + 1);
                            }
                            String refName = String.valueOf(module) + NameUtils.getSafeName((ReadGraph)graph, (Resource)head) + "." + NameUtils.getSafeName((ReadGraph)graph, (Resource)ref);
                            solver.setRealValue(refName, values[i]);
                        }
                    }
                    ++i;
                }
                exp.refresh();
                exp.updateSubscriptions();
            }
            catch (Exception e) {
                Logger.defaultLogError((Throwable)e);
            }
        }
    }
}

