/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.adapter;

import java.util.ArrayList;
import java.util.HashMap;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ParametrizedPrimitiveRead;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.AbstractPropertyVariable;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.ExternalRead;
import org.simantics.modeling.ModelingResources;
import org.simantics.project.IProject;
import org.simantics.simulation.experiment.IExperiment;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.simulation.project.IExperimentManager;
import org.simantics.sysdyn.adapter.VariableRVIUtils;
import org.simantics.sysdyn.adapter.VariableValueSubscription;
import org.simantics.sysdyn.manager.SysdynExperiment;
import org.simantics.sysdyn.manager.SysdynModel;
import org.simantics.sysdyn.manager.SysdynModelManager;
import org.simantics.sysdyn.manager.VariableSubscriptionManager;
import org.simantics.utils.datastructures.Pair;

public abstract class IndexVariable<T>
extends AbstractPropertyVariable {
    protected Variable parent;
    protected SysdynModel model;
    protected SysdynExperiment experiment;
    protected String rvi;
    protected HashMap<String, String> rvis;
    protected String indexes;
    protected VariableSubscriptionManager subscriptionManager;

    public IndexVariable(ReadGraph graph, Variable parent, String indexes) throws DatabaseException {
        this.parent = parent;
        this.indexes = indexes;
    }

    protected VariableSubscriptionManager getSubscriptionManager() {
        return this.experiment;
    }

    public String getIndexes() {
        return this.indexes;
    }

    protected VariableValueSubscription<T> registerSubscription(ExternalRead<?> request, Listener<T> procedure) {
        VariableValueSubscription<T> subscription = new VariableValueSubscription<T>(request, this, procedure);
        if (this.subscriptionManager != null) {
            this.subscriptionManager.addVariableValueSubscription(subscription);
        }
        subscription.update();
        return subscription;
    }

    protected void unregisterSubscription(VariableValueSubscription<T> subscription) {
        subscription.setListener(null);
        if (this.subscriptionManager != null) {
            this.subscriptionManager.removeVariableValueSubscription(subscription);
        }
    }

    public Resource getPropertyResource(ReadGraph graph) throws DatabaseException {
        return null;
    }

    public Resource getContainerResource(ReadGraph graph) throws DatabaseException {
        return null;
    }

    public Datatype getDatatype(ReadGraph graph) throws DatabaseException {
        return null;
    }

    public Variable getPredicate(ReadGraph graph) throws DatabaseException {
        return null;
    }

    public <U> U getValue(ReadGraph graph) throws DatabaseException {
        return this.getValue(graph, (Binding)Bindings.DOUBLE);
    }

    public <U> U getValue(ReadGraph graph, Binding binding) throws DatabaseException {
        this.ensureInformationAvailable(graph);
        this.beforeRequest(graph);
        return (U)graph.syncRequest((ExternalRead)new PropertyRequest((Variable)this));
    }

    protected void beforeRequest(ReadGraph graph) throws DatabaseException {
    }

    protected void ensureInformationAvailable(ReadGraph graph) throws DatabaseException {
        IExperimentManager expMan;
        IExperiment e;
        SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        if (this.model == null) {
            Resource modelResource = Variables.getModel((ReadGraph)graph, (Variable)this.parent);
            Resource configuration = graph.getPossibleObject(modelResource, SIMU.HasConfiguration);
            this.model = SysdynModelManager.getInstance(graph.getSession()).getModel(graph, configuration);
        }
        Variable var = this.parent.getParent(graph);
        Resource represents = var.getRepresents(graph);
        Resource activeRun = null;
        if (represents != null) {
            do {
                if (!graph.isInstanceOf(represents, SIMU.Run)) continue;
                activeRun = represents;
                break;
            } while ((represents = (var = var.getParent(graph)).getRepresents(graph)) != null && !graph.isInstanceOf(represents, MOD.StructuralModel));
        }
        IProject project = Simantics.peekProject();
        if (activeRun != null && project != null && (e = (expMan = (IExperimentManager)project.getHint(IExperimentManager.KEY_EXPERIMENT_MANAGER)).getExperiment(NameUtils.getSafeName((ReadGraph)graph, (Resource)activeRun))) instanceof SysdynExperiment) {
            this.experiment = (SysdynExperiment)e;
        }
        this.subscriptionManager = this.getSubscriptionManager();
        this.rvi = Variables.getPossibleRVI((ReadGraph)graph, (Variable)this);
        if (this.rvi != null) {
            this.rvis = VariableRVIUtils.getActiveRVIs(graph, this.parent.getParent(graph));
        }
    }

    private Pair<ArrayList<String>, ArrayList<String>> getVariableNameArrays() {
        Pair result = new Pair(new ArrayList(), new ArrayList());
        if (this.rvi == null || this.rvis == null) {
            return result;
        }
        if (this.rvi.indexOf(35) > 0) {
            this.rvi = this.rvi.substring(0, this.rvi.indexOf(35));
        }
        String test = this.rvi;
        if (this.indexes != null && !this.indexes.isEmpty()) {
            String regexIndexes = this.indexes.trim().replaceAll(":", "[a-zA-Z0-9_]*");
            test = String.valueOf(this.rvi) + "\\[" + regexIndexes + "\\]";
        } else {
            test = String.valueOf(this.rvi) + "(\\[.*\\])?";
        }
        for (String k : this.rvis.keySet()) {
            String value = this.rvis.get(k);
            if (!k.matches(test) && !value.matches(test)) continue;
            ((ArrayList)result.first).add(k.substring(1).replace("/", ".").replace("%20", "_"));
            ((ArrayList)result.second).add(value.substring(1).replace("/", ".").replace("%20", " "));
        }
        return result;
    }

    protected ArrayList<String> getVariableNames() {
        return (ArrayList)this.getVariableNameArrays().second;
    }

    protected ArrayList<String> getVariableNamesWithIndexNumbers() {
        return (ArrayList)this.getVariableNameArrays().first;
    }

    public abstract T getValue();

    public void setValue(WriteGraph graph, Object value, Binding binding) throws DatabaseException {
        this.setValue(graph, value);
    }

    public void setValue(WriteGraph graph, Object value) throws DatabaseException {
        this.ensureInformationAvailable((ReadGraph)graph);
        this.setIndexedValue(graph, value);
    }

    protected abstract void setIndexedValue(WriteGraph var1, Object var2) throws DatabaseException;

    public String getName(ReadGraph graph) throws DatabaseException {
        return this.indexes;
    }

    public Object getSerialized(ReadGraph graph) throws DatabaseException {
        return this.indexes;
    }

    public Variable getParent(ReadGraph graph) throws DatabaseException {
        return this.parent;
    }

    class PropertyRequest
    extends ParametrizedPrimitiveRead<Variable, T> {
        VariableValueSubscription<T> subscription;

        public PropertyRequest(Variable indexVariable2) {
            super((Object)indexVariable2);
        }

        public void register(ReadGraph graph, Listener<T> procedure) {
            this.subscription = IndexVariable.this.registerSubscription((ExternalRead<?>)this, procedure);
        }

        public void unregistered() {
            if (this.subscription != null) {
                IndexVariable.this.unregisterSubscription(this.subscription);
                this.subscription = null;
            }
        }

        public boolean equals(Object object) {
            if (object instanceof PropertyRequest && super.equals(object)) {
                return ((Variable)this.parameter).equals(((PropertyRequest)((Object)object)).parameter);
            }
            return super.equals(object);
        }
    }
}

