/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.ui.editor;

import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.simantics.scl.compiler.SCLCompiler;
import org.simantics.scl.compiler.SCLCompilerConfiguration;
import org.simantics.scl.compiler.StandardSCLCompilerConfiguration;
import org.simantics.scl.ui.editor.SCLTextEditor;

public class TestTextEditor {
    public static void main(String[] args) {
        Display display = new Display();
        final Shell shell = new Shell(display);
        shell.setText("SCL text widget example");
        shell.setLayout((Layout)new FillLayout());
        SashForm sashForm = new SashForm((Composite)shell, 512);
        final SCLTextEditor editor = new SCLTextEditor((Composite)sashForm, 0, StandardSCLCompilerConfiguration.INSTANCE);
        editor.setContent("// Difficulty: 0\n// Expected: [2.0, 3.0, 5.0, 7.0, 11.0, 13.0, 17.0, 19.0]\n\n// and : [Boolean] -> Boolean\nand = fold (&&) True\n\n// isPrime : Integer -> Boolean\nisPrime p = and (\n    d <- [2 .. sqrt p]\n    [p % d > 0]\n)\n\nx <- [2 .. 20]\nisPrime x\n[x]");
        final Text resultArea = new Text((Composite)sashForm, 578);
        resultArea.setText("Ctrl-S executes the code.");
        resultArea.setEditable(false);
        resultArea.setBackground(new Color((Device)shell.getDisplay(), 255, 255, 255));
        resultArea.setFont(new Font((Device)shell.getDisplay(), "Courier New", 10, 0));
        sashForm.setWeights(new int[]{5, 1});
        display.addFilter(1, new Listener(){

            public void handleEvent(Event event) {
                if (event.keyCode == 115 && event.stateMask == 262144) {
                    final String code = editor.getContent();
                    new Thread(){

                        @Override
                        public void run() {
                            try {
                                final String result = SCLCompiler.compileExpression((SCLCompilerConfiguration)StandardSCLCompilerConfiguration.INSTANCE, (String)code).execute().toString();
                                shell.getDisplay().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        resultArea.setText(result);
                                    }
                                });
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }.start();
                    event.doit = false;
                }
            }
        });
        shell.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                System.out.println(e);
            }
        });
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }
}

