/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.message.internal;

import java.io.File;
import java.util.Hashtable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.internal.adaptor.EclipseLogFactory;
import org.eclipse.core.runtime.internal.adaptor.EclipseLogWriter;
import org.eclipse.equinox.log.internal.LogServiceManager;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.log.LogListener;
import org.simantics.message.ILogListener;
import org.simantics.message.ILogger;
import org.simantics.message.IMessageSchemeManager;
import org.simantics.message.internal.LogWriter;
import org.simantics.message.internal.MessageSchemeManager;
import org.simantics.message.internal.Messages;

public class Activator
extends Plugin {
    private static final String DEFAULT_LOG_FILE_NAME = "messages.log";
    public static final String PLUGIN_ID = "org.simantics.message";
    private static final String LOGGER_NAME = "org.simantics.message.logger";
    private static Activator plugin;
    private BundleContext bundleContext;
    private Messages messagesService;
    private MessageSchemeManager messageSchemeManagerService;
    private ServiceRegistration messages = null;
    private ServiceRegistration messageSchemeManager = null;
    private LogWriter platformLog = null;
    private FrameworkLog frameworkLog = null;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.bundleContext = context;
        this.messagesService = new Messages();
        this.messageSchemeManagerService = new MessageSchemeManager();
        this.messages = this.bundleContext.registerService(ILogger.class.getName(), (Object)this.messagesService, new Hashtable());
        this.messageSchemeManager = this.bundleContext.registerService(IMessageSchemeManager.class.getName(), (Object)this.messageSchemeManagerService, new Hashtable());
        FrameworkLog log = this.getFrameworkLog();
        if (log != null) {
            this.platformLog = new LogWriter(this.getFrameworkLog());
            this.addLogListener(this.platformLog);
        } else {
            this.platformLog = null;
        }
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        if (this.platformLog != null) {
            this.removeLogListener(this.platformLog);
        }
        if (this.frameworkLog != null) {
            this.frameworkLog.close();
        }
        if (this.messageSchemeManager != null) {
            this.messageSchemeManager.unregister();
            this.messageSchemeManager = null;
            this.messageSchemeManagerService = null;
        }
        if (this.messages != null) {
            this.messages.unregister();
            this.messages = null;
            this.messagesService = null;
        }
        this.bundleContext = null;
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public ILogger getMessages() {
        return this.messagesService;
    }

    public void addLogListener(ILogListener listener) {
        this.getMessages().addLogListener(listener);
    }

    public void removeLogListener(ILogListener listener) {
        this.getMessages().removeLogListener(listener);
    }

    private FrameworkLog getFrameworkLog() {
        if (this.frameworkLog == null) {
            IPath logLocation = this.getStateLocation().append(DEFAULT_LOG_FILE_NAME);
            EclipseLogWriter logWriter = new EclipseLogWriter(logLocation.toFile(), LOGGER_NAME, true);
            LogServiceManager logServiceManager = new LogServiceManager(new LogListener[]{logWriter});
            EclipseLogFactory logFactory = new EclipseLogFactory(logWriter, logServiceManager);
            this.frameworkLog = logFactory.getService(this.getBundle(), null);
        }
        return this.frameworkLog;
    }

    public static File getLogFile() {
        return Activator.getDefault().getFrameworkLog().getFile();
    }

    public IMessageSchemeManager getMessageSchemeManager() {
        return this.messageSchemeManagerService;
    }
}

