/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.ui;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.ui.Activator;
import org.simantics.scenegraph.ui.NodeProxy;
import org.simantics.scenegraph.utils.NodeUtil;
import org.simantics.utils.datastructures.ValueUtils;

public class AttributeDialog
extends Dialog
implements ISelectionChangedListener {
    private static final String DIALOG = "AttributeDialog";
    private IDialogSettings dialogBoundsSettings;
    private ResourceManager resourceManager;
    private TableViewer viewer;
    private final ISelectionProvider selectionProvider;
    private final boolean showClass = true;
    private boolean showTransient = false;
    private boolean showStatic = false;
    private final ColorDescriptor staticColor = ColorDescriptor.createFrom((RGB)new RGB(224, 224, 224));
    private final ColorDescriptor transientColor = ColorDescriptor.createFrom((RGB)new RGB(192, 255, 255));

    protected AttributeDialog(Shell parentShell, ISelectionProvider selectionProvider) {
        super(parentShell);
        this.selectionProvider = selectionProvider;
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        this.dialogBoundsSettings = settings.getSection(DIALOG);
        if (this.dialogBoundsSettings == null) {
            this.dialogBoundsSettings = settings.addNewSection(DIALOG);
        }
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return this.dialogBoundsSettings;
    }

    protected int getShellStyle() {
        return 2160;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Scene Graph Node Attributes");
    }

    protected Control createButtonBar(Composite parent) {
        return parent;
    }

    protected void createButtonsForButtonBar(Composite parent) {
    }

    protected Point getInitialSize() {
        Point result;
        Point defaultSize = this.getShell().computeSize(-1, -1, true);
        if (defaultSize.equals((Object)(result = super.getInitialSize()))) {
            return new Point(500, 300);
        }
        return result;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources());
        composite.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                AttributeDialog.this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)AttributeDialog.this);
                AttributeDialog.this.resourceManager.dispose();
                AttributeDialog.this.resourceManager = null;
            }
        });
        GridLayoutFactory.fillDefaults().margins(0, 0).spacing(0, 0).applyTo(composite);
        ToolBar toolbar = new ToolBar(composite, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)toolbar);
        final ToolItem showStaticItem = new ToolItem(toolbar, 32);
        showStaticItem.setText("Show &Static");
        showStaticItem.setToolTipText("Show Static Fields of Selected Object");
        final ToolItem showTransientItem = new ToolItem(toolbar, 32);
        showTransientItem.setText("Show &Transient");
        showTransientItem.setToolTipText("Show Transient Fields of Selected Object");
        ToolItem refresh = new ToolItem(toolbar, 8);
        refresh.setText("&Refresh");
        refresh.setToolTipText("Refresh Values");
        Composite tableComposite = new Composite(composite, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tableComposite);
        this.viewer = new TableViewer(tableComposite, 68356);
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer.setContentProvider((IContentProvider)new FieldContentProvider());
        this.viewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x100000E) {
                    AttributeDialog.this.refresh();
                }
            }
        });
        TableColumnLayout ad = new TableColumnLayout();
        tableComposite.setLayout((Layout)ad);
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        this.viewer.setUseHashlookup(true);
        TableViewerColumn nameColumn = new TableViewerColumn(this.viewer, 16384);
        nameColumn.setLabelProvider((CellLabelProvider)new FieldName());
        TableViewerColumn typeColumn = new TableViewerColumn(this.viewer, 16384);
        typeColumn.setLabelProvider((CellLabelProvider)new FieldType());
        TableViewerColumn valueColumn = new TableViewerColumn(this.viewer, 16384);
        valueColumn.setLabelProvider((CellLabelProvider)new FieldValue());
        typeColumn.getColumn().setText("Type");
        typeColumn.getColumn().setWidth(20);
        ad.setColumnData((Widget)typeColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(10, 140));
        nameColumn.getColumn().setText("Name");
        nameColumn.getColumn().setWidth(20);
        ad.setColumnData((Widget)nameColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(10, 140));
        valueColumn.getColumn().setText("Value");
        valueColumn.getColumn().setWidth(20);
        ad.setColumnData((Widget)valueColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(90, 200));
        this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
        showStaticItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AttributeDialog.this.showStatic = showStaticItem.getSelection();
                AttributeDialog.this.refresh();
            }
        });
        showTransientItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AttributeDialog.this.showTransient = showTransientItem.getSelection();
                AttributeDialog.this.refresh();
            }
        });
        refresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AttributeDialog.this.refresh();
            }
        });
        this.refresh();
        AttributeDialog.applyDialogFont((Control)composite);
        return composite;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.selectionChanged(event.getSelection());
    }

    public void selectionChanged(ISelection selection) {
        IStructuredSelection ss = (IStructuredSelection)selection;
        Object obj = ss.getFirstElement();
        if (ss.size() == 1 || obj instanceof NodeProxy) {
            this.viewer.setInput(obj);
        } else {
            this.viewer.setInput(new Object());
        }
    }

    public void refresh() {
        this.selectionChanged(this.selectionProvider.getSelection());
    }

    static class Attr {
        Object object;
        Field field;

        public Attr(Object obj, Field f) {
            this.object = obj;
            this.field = f;
        }

        public Object getObject() {
            return this.object;
        }

        public <T> T getObject(Class<T> clazz) {
            return clazz.cast(this.object);
        }

        public Field getField() {
            return this.field;
        }

        public String toString() {
            return this.field.getName();
        }
    }

    static class ComputedAttr {
        public String name;
        public Object object;
        public String stringValue;

        public ComputedAttr(String name, Object object) {
            this(name, object, object != null ? object.toString() : "null");
        }

        public ComputedAttr(String name, Object object, String stringValue) {
            this.name = name;
            this.object = object;
            this.stringValue = stringValue;
        }

        public String toString() {
            return this.stringValue;
        }
    }

    class FieldContentProvider
    implements ITreeContentProvider {
        FieldContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof NodeProxy) {
                NodeProxy np = (NodeProxy)inputElement;
                INode node = np.getNode();
                if (node == null) {
                    return new Object[0];
                }
                ArrayList<Object> result = new ArrayList<Object>();
                if (node instanceof IG2DNode) {
                    IG2DNode g2dnode = (IG2DNode)node;
                    result.add(new Header("Computational IG2DNode properties"));
                    result.add(new ComputedAttr("local bounds", g2dnode.getBoundsInLocal()));
                    result.add(new ComputedAttr("world bounds", g2dnode.getBounds()));
                    result.add(new ComputedAttr("local to world transform", NodeUtil.getLocalToGlobalTransform((IG2DNode)g2dnode)));
                }
                Class<?> clazz = node.getClass();
                while (clazz != null && clazz != Object.class) {
                    result.add(clazz);
                    Field[] fields = clazz.getDeclaredFields();
                    int i = 0;
                    while (i < fields.length) {
                        Field f = fields[i];
                        if (!(!AttributeDialog.this.showTransient && Modifier.isTransient(f.getModifiers()) || !AttributeDialog.this.showStatic && Modifier.isStatic(f.getModifiers()))) {
                            result.add(new Attr(np, fields[i]));
                        }
                        ++i;
                    }
                    clazz = clazz.getSuperclass();
                }
                return result.toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class FieldName
    extends NodeLabelProvider {
        FieldName() {
        }

        @Override
        public void update(ViewerCell cell, ComputedAttr attr) {
            cell.setText(attr.name);
        }

        @Override
        public void update(ViewerCell cell, Attr attr, INode node) {
            Field f = attr.getField();
            cell.setText(f.getName());
        }

        @Override
        public void updateHeader(ViewerCell cell, String header) {
            super.updateHeader(cell, header);
            cell.setText(header);
        }
    }

    class FieldType
    extends NodeLabelProvider {
        FieldType() {
        }

        @Override
        public void update(ViewerCell cell, ComputedAttr attr) {
            cell.setText(attr.object != null ? attr.object.getClass().getSimpleName() : "null");
        }

        @Override
        public void update(ViewerCell cell, Attr attr, INode node) {
            Field f = attr.getField();
            cell.setText(f.getType().getSimpleName());
        }
    }

    class FieldValue
    extends NodeLabelProvider {
        FieldValue() {
        }

        @Override
        public void update(ViewerCell cell, ComputedAttr attr) {
            cell.setText(attr.stringValue);
        }

        @Override
        public void update(ViewerCell cell, Attr attr, INode node) {
            Field f = attr.getField();
            boolean accessible = f.isAccessible();
            try {
                try {
                    Object value;
                    if (!accessible) {
                        f.setAccessible(true);
                    }
                    String label = (value = f.get(node)) == null ? "null" : ValueUtils.toString((Object)value);
                    cell.setText(label);
                    if (Modifier.isStatic(f.getModifiers())) {
                        cell.setBackground((Color)AttributeDialog.this.resourceManager.get((DeviceResourceDescriptor)AttributeDialog.this.staticColor));
                    } else if (Modifier.isTransient(f.getModifiers())) {
                        cell.setBackground((Color)AttributeDialog.this.resourceManager.get((DeviceResourceDescriptor)AttributeDialog.this.transientColor));
                    }
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                    cell.setText(e.getMessage());
                    if (!accessible) {
                        f.setAccessible(false);
                    }
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    cell.setText(e.getMessage());
                    if (!accessible) {
                        f.setAccessible(false);
                    }
                }
            }
            finally {
                if (!accessible) {
                    f.setAccessible(false);
                }
            }
        }
    }

    static class Header {
        String name;

        public Header(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    abstract class NodeLabelProvider
    extends ColumnLabelProvider {
        NodeLabelProvider() {
        }

        public final void update(ViewerCell cell) {
            Object elem = cell.getElement();
            if (elem instanceof Attr) {
                Attr attr = (Attr)elem;
                NodeProxy np = attr.getObject(NodeProxy.class);
                INode node = np.getNode();
                this.update(cell, attr, node);
            } else if (elem instanceof ComputedAttr) {
                ComputedAttr attr = (ComputedAttr)elem;
                this.update(cell, attr);
            } else if (elem instanceof Header) {
                this.updateHeader(cell, ((Header)elem).name);
            } else if (elem instanceof Class) {
                Class clazz = (Class)elem;
                this.updateHeader(cell, clazz.getSimpleName());
            }
        }

        public abstract void update(ViewerCell var1, ComputedAttr var2);

        public abstract void update(ViewerCell var1, Attr var2, INode var3);

        public void updateHeader(ViewerCell cell, String header) {
            cell.setFont(AttributeDialog.this.resourceManager.createFont(FontDescriptor.createFrom((Font)cell.getFont()).withStyle(3)));
            cell.setForeground(cell.getControl().getDisplay().getSystemColor(28));
            cell.setBackground(cell.getControl().getDisplay().getSystemColor(29));
        }
    }
}

