/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.export;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.wikitext.core.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.mediawiki.core.MediaWikiLanguage;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.gui.HtmlPanel;
import org.lobobrowser.html.renderer.RBlock;
import org.osgi.service.prefs.Preferences;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.type.RecordType;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.Queries;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.request.WriteResultRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.WriteInterface;
import org.simantics.document.DocumentResource;
import org.simantics.document.function.WikiDocumentNodeImpl;
import org.simantics.document.node.Composite;
import org.simantics.export.core.ExportContext;
import org.simantics.export.core.error.ExportException;
import org.simantics.export.core.intf.ExportClass;
import org.simantics.export.core.manager.Content;
import org.simantics.export.core.pdf.ExportPdfWriter;
import org.simantics.export.core.util.ExportQueries;
import org.simantics.export.core.util.ExporterUtils;
import org.simantics.layer0.Layer0;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.loader.ScenegraphLoaderProcess;
import org.simantics.scenegraph.loader.ScenegraphLoaderUtils;
import org.simantics.scenegraph.loader.ScenegraphVariable;
import org.simantics.scenegraph.ontology.ScenegraphResources;
import org.simantics.utils.datastructures.MapList;
import org.simantics.utils.datastructures.ToStringComparator;
import org.simantics.utils.threads.AWTThread;
import org.simantics.wiki.ui.SimanticsDialect;
import org.simantics.wiki.ui.browser.PrintableHtmlPanel;
import org.simantics.wiki.ui.browser.SimanticsHtmlRendererContext;

public class ExportWikiPdf
implements ExportClass {
    static RecordType wikiOptions = new RecordType();
    MarkupParser markupParser = new MarkupParser();
    MediaWikiLanguage language = new MediaWikiLanguage();

    public ExportWikiPdf() {
        this.markupParser.setMarkupLanguage((MarkupLanguage)this.language);
    }

    public RecordType options(ExportContext ctx, Collection<String> contentUris) throws ExportException {
        return wikiOptions;
    }

    public List<String> validate(String contentUri, ExportContext context, Variant options) {
        return Collections.emptyList();
    }

    public void export(List<Content> contents, Object handle, ExportContext ctx, Variant options, IProgressMonitor monitor, MapList<Content, Content> attachmentMap) throws ExportException {
        final ExportPdfWriter writer = (ExportPdfWriter)handle;
        try {
            List uris = ExporterUtils.toUris(contents);
            Read docQuery = ExportQueries.instancesOf((Collection)uris, (String)"http://www.simantics.org/Document-1.2/Document");
            ArrayList<Doc> docs = new ArrayList<Doc>();
            for (String docUri : (Collection)ctx.session.syncRequest(docQuery)) {
                Doc doc = ExportWikiPdf.createDocObj(ctx, docUri);
                if (doc == null) continue;
                docs.add(doc);
            }
            if (docs.isEmpty()) {
                return;
            }
            Collections.sort(docs, new ToStringComparator());
            StringBuilder wikiSb = new StringBuilder();
            for (Doc doc : docs) {
                StringBuilder sb2 = new StringBuilder();
                Content c = this.findClosestContent(contents, doc.baseUri);
                if (c != null) {
                    if (c.url.equals(doc.baseUri)) {
                        sb2.append("= " + c.label + " =\n");
                    } else {
                        String endpart = doc.baseUri.substring(c.url.length() + 1);
                        sb2.append("= " + c.label + " / " + endpart + " =\n");
                    }
                } else {
                    sb2.append("= " + doc.baseUri + " =\n");
                }
                this.getDocumentWikiText(ctx.session, doc.baseRes, doc.docRes, sb2);
                wikiSb.append(sb2.toString());
                wikiSb.append("\n");
            }
            final String wiki = wikiSb.toString();
            final ExportException[] errors = new ExportException[1];
            AWTThread.getThreadAccess().syncExec(new Runnable(){

                @Override
                public void run() {
                    block19: {
                        ExportPdfWriter.Page page = null;
                        try {
                            try {
                                page = writer.createPage(null);
                                String htmlContent = ExportWikiPdf.this.markupParser.parseToHtml(wiki);
                                PrintableHtmlPanel component = new PrintableHtmlPanel();
                                component.setHtml(htmlContent, "http://localhost", (HtmlRendererContext)new SimanticsHtmlRendererContext((HtmlPanel)component, null));
                                RBlock rblock = (RBlock)component.getBlockRenderable();
                                double scale = 4.0;
                                double width = page.getWidth() * scale;
                                double height = page.getHeight() * scale;
                                rblock.layout((int)width, (int)height, false, true, 0, 0, false);
                                Rectangle bounds = rblock.getBounds();
                                double contentHeight = bounds.height;
                                int pages = (int)Math.floor(contentHeight / height + 0.99);
                                int pageNumber = 0;
                                while (pageNumber < pages) {
                                    if (pageNumber > 0) {
                                        page = writer.createPage(null);
                                    }
                                    Graphics2D g2d = page.createGraphics(true);
                                    try {
                                        g2d.scale(1.0 / scale, 1.0 / scale);
                                        g2d.setClip(0, 0, (int)width, (int)height);
                                        component.getBlockRenderable().setOrigin(0, (int)((double)(-pageNumber) * height));
                                        component.getBlockRenderable().paintTranslated((Graphics)g2d);
                                    }
                                    finally {
                                        g2d.dispose();
                                    }
                                    ++pageNumber;
                                }
                            }
                            catch (ExportException e) {
                                errors[0] = e;
                                if (page == null) break block19;
                                try {
                                    page.close();
                                }
                                catch (ExportException e2) {
                                    if (errors[0] == null) {
                                        errors[0] = e2;
                                    }
                                }
                            }
                        }
                        finally {
                            block20: {
                                if (page != null) {
                                    try {
                                        page.close();
                                    }
                                    catch (ExportException e) {
                                        if (errors[0] != null) break block20;
                                        errors[0] = e;
                                    }
                                }
                            }
                        }
                    }
                }
            });
            if (errors[0] != null) {
                throw errors[0];
            }
        }
        catch (DatabaseException e) {
            throw new ExportException((Throwable)e);
        }
    }

    static Doc createDocObj(ExportContext ctx, String docUri) throws DatabaseException {
        Doc result = new Doc();
        DocumentResource DOC = DocumentResource.getInstance((RequestProcessor)ctx.session);
        result.docRes = (Resource)ctx.session.syncRequest(Queries.resource((String)docUri));
        Collection baseReses = (Collection)ctx.session.syncRequest(Queries.objects((Resource)result.docRes, (Resource)DOC.HasDocument_Inverse));
        if (baseReses.isEmpty()) {
            return null;
        }
        Iterator iterator = baseReses.iterator();
        while (iterator.hasNext()) {
            Resource baseRes;
            result.baseRes = baseRes = (Resource)iterator.next();
            result.baseUri = (String)ctx.session.syncRequest(Queries.uri((Resource)baseRes));
            if (docUri.startsWith(result.baseUri)) break;
        }
        return result;
    }

    Content findClosestContent(List<Content> contents, String uri) {
        Content result = null;
        int match = -1;
        for (Content c : contents) {
            if (!uri.startsWith(c.url) || c.url.length() <= match) continue;
            match = c.url.length();
            result = c;
        }
        return result;
    }

    public void fillDefaultPrefs(ExportContext ctx, Variant options) throws ExportException {
    }

    public void savePref(Variant options, Preferences contentScopePrefs, Preferences workspaceScopePrefs) throws ExportException {
    }

    public void loadPref(Variant options, Preferences contentScopeNode, Preferences workspaceScopePrefs) throws ExportException {
    }

    public void getDocumentWikiText(Session session, final Resource baseRes, final Resource docRes, StringBuilder b) {
        try {
            final ScenegraphLoaderProcess loader = new ScenegraphLoaderProcess((INode)new Composite(), "CreatePDFAction");
            final Variable context = (Variable)session.sync((WriteInterface)new WriteResultRequest<Variable>((VirtualGraph)session.getService(VirtualGraph.class)){

                public Variable perform(WriteGraph graph) throws DatabaseException {
                    Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                    DocumentResource DOC = DocumentResource.getInstance((ReadGraph)graph);
                    ScenegraphResources SG = ScenegraphResources.getInstance((ReadGraph)graph);
                    Resource runtime = graph.newResource();
                    graph.claim(runtime, L0.InstanceOf, null, SG.Runtime);
                    Variable base = Variables.getVariable((ReadGraph)graph, (Resource)baseRes);
                    String uri = base.getURI((ReadGraph)graph);
                    graph.claimLiteral(runtime, SG.Runtime_HasVariable, (Object)uri, (Binding)Bindings.STRING);
                    return new ScenegraphVariable(base, docRes, runtime, loader.getRoot());
                }
            });
            if (context == null) {
                return;
            }
            String wiki = (String)session.sync((ReadInterface)new UniqueRead<String>(){

                public String perform(ReadGraph graph) throws DatabaseException {
                    DocumentResource DOC = DocumentResource.getInstance((ReadGraph)graph);
                    Resource scenegraph = graph.getSingleObject(docRes, DOC.ScenegraphDocument_scenegraph);
                    WikiDocumentNodeImpl node = (WikiDocumentNodeImpl)loader.load((RequestProcessor)graph, scenegraph, ScenegraphLoaderUtils.getRuntime((ReadGraph)graph, (Variable)context));
                    StringBuilder b = new StringBuilder();
                    node.create(b, true);
                    String text = b.toString();
                    return SimanticsDialect.INSTANCE.apply(graph, Variables.getVariable((ReadGraph)graph, (Resource)baseRes), text);
                }
            });
            loader.dispose();
            b.append(wiki);
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }

    static class Doc {
        String docUri;
        Resource docRes;
        String baseUri;
        Resource baseRes;

        Doc() {
        }

        public String toString() {
            return this.baseUri;
        }
    }
}

