/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.PageSize;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.gui.HtmlPanel;
import org.lobobrowser.html.renderer.RBlock;
import org.simantics.wiki.ui.browser.PrintableHtmlPanel;
import org.simantics.wiki.ui.browser.SimanticsHtmlRendererContext;
import org.simantics.wiki.ui.editor.IExportable;

public class Exportable
implements IExportable {
    private final String html;

    public Exportable(String html) {
        this.html = html;
    }

    public void export(Document document, PdfWriter writer) throws DocumentException {
        PdfContentByte cb = writer.getDirectContent();
        int marginLeft = 20;
        int marginRight = 20;
        int marginTop = 10;
        int marginBottom = 45;
        int contentWidth = (int)PageSize.A4.getWidth() - marginLeft - marginRight;
        int contentHeight = (int)PageSize.A4.getHeight() - marginTop - marginBottom;
        PrintableHtmlPanel component = new PrintableHtmlPanel();
        component.setHtml(this.html, "http://localhost", (HtmlRendererContext)new SimanticsHtmlRendererContext((HtmlPanel)component, null));
        ((RBlock)component.getBlockRenderable()).layout(contentWidth, contentHeight, false, true, 0, 0, false);
        Rectangle bounds = ((RBlock)component.getBlockRenderable()).getBounds();
        PdfTemplate template = null;
        int page = 0;
        while ((double)page < Math.floor((double)((float)bounds.height / (float)contentHeight) + 0.99)) {
            template = cb.createTemplate(PageSize.A4.getWidth(), PageSize.A4.getHeight());
            Graphics2D g2d = template.createGraphics(PageSize.A4.getWidth(), PageSize.A4.getHeight());
            g2d.translate(marginLeft, marginTop);
            g2d.setClip(0, 0, contentWidth, contentHeight);
            component.getBlockRenderable().setOrigin(0, -page * contentHeight);
            component.getBlockRenderable().paintTranslated((Graphics)g2d);
            g2d.dispose();
            document.setPageSize(PageSize.A4);
            document.newPage();
            cb.addTemplate(template, 0.0f, 0.0f);
            ++page;
        }
    }
}

