/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.PageSize;
import com.lowagie.text.pdf.PdfWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.eclipse.mylyn.wikitext.core.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.mediawiki.core.MediaWikiLanguage;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.gui.HtmlPanel;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.request.WriteResultRequest;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.WriteInterface;
import org.simantics.document.DocumentResource;
import org.simantics.document.Exportable;
import org.simantics.document.function.WikiDocumentNodeImpl;
import org.simantics.document.node.Composite;
import org.simantics.layer0.Layer0;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.loader.ScenegraphLoaderProcess;
import org.simantics.scenegraph.loader.ScenegraphLoaderUtils;
import org.simantics.scenegraph.loader.ScenegraphVariable;
import org.simantics.scenegraph.ontology.ScenegraphResources;
import org.simantics.utils.threads.AWTThread;
import org.simantics.wiki.ui.SimanticsDialect;
import org.simantics.wiki.ui.browser.PrintableHtmlPanel;
import org.simantics.wiki.ui.browser.SimanticsHtmlRendererContext;

public class DocumentUtils {
    public void getDocumentWikiText(Session session, final Resource resource, StringBuilder b) {
        try {
            final ScenegraphLoaderProcess loader = new ScenegraphLoaderProcess((INode)new Composite(), "CreatePDFAction");
            final Variable context = (Variable)session.sync((WriteInterface)new WriteResultRequest<Variable>((VirtualGraph)session.getService(VirtualGraph.class)){

                public Variable perform(WriteGraph graph) throws DatabaseException {
                    Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                    DocumentResource DOC = DocumentResource.getInstance((ReadGraph)graph);
                    ScenegraphResources SG = ScenegraphResources.getInstance((ReadGraph)graph);
                    Resource runtime = graph.newResource();
                    graph.claim(runtime, L0.InstanceOf, null, SG.Runtime);
                    Resource doc = graph.getPossibleObject(resource, DOC.HasDocument);
                    if (doc == null) {
                        return null;
                    }
                    Variable base = Variables.getVariable((ReadGraph)graph, (Resource)resource);
                    String uri = base.getURI((ReadGraph)graph);
                    graph.claimLiteral(runtime, SG.Runtime_HasVariable, (Object)uri, (Binding)Bindings.STRING);
                    return new ScenegraphVariable(base, doc, runtime, loader.getRoot());
                }
            });
            if (context == null) {
                return;
            }
            String wiki = (String)session.sync((ReadInterface)new UniqueRead<String>(){

                public String perform(ReadGraph graph) throws DatabaseException {
                    DocumentResource DOC = DocumentResource.getInstance((ReadGraph)graph);
                    Resource doc = graph.getSingleObject(resource, DOC.HasDocumentation);
                    Resource scenegraph = graph.getSingleObject(doc, DOC.ScenegraphDocument_scenegraph);
                    WikiDocumentNodeImpl node = (WikiDocumentNodeImpl)loader.load((RequestProcessor)graph, scenegraph, ScenegraphLoaderUtils.getRuntime((ReadGraph)graph, (Variable)context));
                    StringBuilder b = new StringBuilder();
                    node.create(b, true);
                    String text = b.toString();
                    return SimanticsDialect.INSTANCE.apply(graph, Variables.getVariable((ReadGraph)graph, (Resource)resource), text);
                }
            });
            loader.dispose();
            b.append(wiki);
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }

    public void print(String wiki, final PdfWriter writer, final Document document) throws DocumentException {
        MarkupParser markupParser = new MarkupParser();
        MediaWikiLanguage language = new MediaWikiLanguage();
        markupParser.setMarkupLanguage((MarkupLanguage)language);
        final String htmlContent = markupParser.parseToHtml(wiki);
        AWTThread.getThreadAccess().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    PrintableHtmlPanel component = new PrintableHtmlPanel();
                    component.setHtml(htmlContent, "http://localhost", (HtmlRendererContext)new SimanticsHtmlRendererContext((HtmlPanel)component, null));
                    new Exportable(htmlContent).export(document, writer);
                }
                catch (DocumentException e) {
                    Logger.defaultLogError((Throwable)e);
                }
            }
        });
    }

    public void print(String wiki, final File file) {
        MarkupParser markupParser = new MarkupParser();
        MediaWikiLanguage language = new MediaWikiLanguage();
        markupParser.setMarkupLanguage((MarkupLanguage)language);
        final String htmlContent = markupParser.parseToHtml(wiki);
        AWTThread.getThreadAccess().asyncExec(new Runnable(){

            @Override
            public void run() {
                PrintableHtmlPanel component = new PrintableHtmlPanel();
                component.setHtml(htmlContent, "http://localhost", (HtmlRendererContext)new SimanticsHtmlRendererContext((HtmlPanel)component, null));
                Document document = new Document(PageSize.A4, 36.0f, 36.0f, 36.0f, 36.0f);
                try {
                    try {
                        PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(file));
                        document.open();
                        new Exportable(htmlContent).export(document, writer);
                    }
                    catch (FileNotFoundException e) {
                        Logger.defaultLogError((Throwable)e);
                        document.close();
                    }
                    catch (DocumentException e) {
                        Logger.defaultLogError((Throwable)e);
                        document.close();
                    }
                }
                finally {
                    document.close();
                }
            }
        });
    }

    public void printDocumentation(Resource resource, File file) {
        StringBuilder b = new StringBuilder();
        this.getDocumentWikiText(Simantics.getSession(), resource, b);
        this.print(b.toString(), file);
    }
}

