/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.action.ontology;

import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.service.QueryControl;

public class ActionResource {
    public final Resource Action;
    public final Resource DropAction;
    public final Resource TemplateCreationAction;

    public static Resource getResourceOrNull(ReadGraph graph, String uri) {
        try {
            return graph.getResource(uri);
        }
        catch (DatabaseException e) {
            System.err.println(e.getMessage());
            return null;
        }
    }

    public ActionResource(ReadGraph graph) {
        this.Action = ActionResource.getResourceOrNull(graph, "http://www.simantics.org/Action-1.1/Action");
        this.DropAction = ActionResource.getResourceOrNull(graph, "http://www.simantics.org/Action-1.1/DropAction");
        this.TemplateCreationAction = ActionResource.getResourceOrNull(graph, "http://www.simantics.org/Action-1.1/TemplateCreationAction");
    }

    public static ActionResource getInstance(ReadGraph graph) {
        Session session = graph.getSession();
        ActionResource ret = (ActionResource)session.peekService(ActionResource.class);
        if (ret == null) {
            QueryControl qc = (QueryControl)graph.getService(QueryControl.class);
            ret = new ActionResource(qc.getIndependentGraph(graph));
            session.registerService(ActionResource.class, (Object)ret);
        }
        return ret;
    }

    public static ActionResource getInstance(RequestProcessor session) throws DatabaseException {
        ActionResource ret = (ActionResource)session.peekService(ActionResource.class);
        if (ret == null) {
            ret = (ActionResource)session.syncRequest((Read)new Read<ActionResource>(){

                public ActionResource perform(ReadGraph graph) throws DatabaseException {
                    QueryControl qc = (QueryControl)graph.getService(QueryControl.class);
                    return new ActionResource(qc.getIndependentGraph(graph));
                }
            });
            session.registerService(ActionResource.class, (Object)ret);
        }
        return ret;
    }

    public static class URIs {
        public static final String Action = "http://www.simantics.org/Action-1.1/Action";
        public static final String DropAction = "http://www.simantics.org/Action-1.1/DropAction";
        public static final String TemplateCreationAction = "http://www.simantics.org/Action-1.1/TemplateCreationAction";
    }
}

