/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import org.apache.lucene.util.packed.PackedInts;

public class GrowableWriter
implements PackedInts.Mutable {
    private long currentMaxValue;
    private PackedInts.Mutable current;
    private final boolean roundFixedSize;

    public GrowableWriter(int startBitsPerValue, int valueCount, boolean roundFixedSize) {
        this.roundFixedSize = roundFixedSize;
        this.current = PackedInts.getMutable(valueCount, this.getSize(startBitsPerValue));
        this.currentMaxValue = PackedInts.maxValue(this.current.getBitsPerValue());
    }

    private final int getSize(int bpv) {
        if (this.roundFixedSize) {
            return PackedInts.getNextFixedSize(bpv);
        }
        return bpv;
    }

    @Override
    public long get(int index) {
        return this.current.get(index);
    }

    @Override
    public int size() {
        return this.current.size();
    }

    @Override
    public int getBitsPerValue() {
        return this.current.getBitsPerValue();
    }

    public PackedInts.Mutable getMutable() {
        return this.current;
    }

    @Override
    public Object getArray() {
        return this.current.getArray();
    }

    @Override
    public boolean hasArray() {
        return this.current.hasArray();
    }

    @Override
    public void set(int index, long value) {
        if (value >= this.currentMaxValue) {
            int bpv = this.getBitsPerValue();
            while (this.currentMaxValue <= value && this.currentMaxValue != Long.MAX_VALUE) {
                ++bpv;
                this.currentMaxValue *= 2L;
            }
            int valueCount = this.size();
            PackedInts.Mutable next = PackedInts.getMutable(valueCount, this.getSize(bpv));
            int i = 0;
            while (i < valueCount) {
                next.set(i, this.current.get(i));
                ++i;
            }
            this.current = next;
            this.currentMaxValue = PackedInts.maxValue(this.current.getBitsPerValue());
        }
        this.current.set(index, value);
    }

    @Override
    public void clear() {
        this.current.clear();
    }

    public GrowableWriter resize(int newSize) {
        GrowableWriter next = new GrowableWriter(this.getBitsPerValue(), newSize, this.roundFixedSize);
        int limit = Math.min(this.size(), newSize);
        int i = 0;
        while (i < limit) {
            next.set(i, this.get(i));
            ++i;
        }
        return next;
    }
}

