/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.PackedInts;

class Direct64
extends PackedInts.ReaderImpl
implements PackedInts.Mutable {
    private long[] values;
    private static final int BITS_PER_VALUE = 64;

    public Direct64(int valueCount) {
        super(valueCount, 64);
        this.values = new long[valueCount];
    }

    public Direct64(DataInput in, int valueCount) throws IOException {
        super(valueCount, 64);
        long[] values = new long[valueCount];
        int i = 0;
        while (i < valueCount) {
            values[i] = in.readLong();
            ++i;
        }
        this.values = values;
    }

    public Direct64(long[] values) {
        super(values.length, 64);
        this.values = values;
    }

    @Override
    public long get(int index) {
        return this.values[index];
    }

    @Override
    public void set(int index, long value) {
        this.values[index] = value;
    }

    public long ramBytesUsed() {
        return RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + this.values.length * 8;
    }

    @Override
    public void clear() {
        Arrays.fill(this.values, 0L);
    }

    public long[] getArray() {
        return this.values;
    }

    @Override
    public boolean hasArray() {
        return true;
    }
}

