/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Comparator;
import java.util.StringTokenizer;
import org.apache.lucene.util.SimpleStringInterner;
import org.apache.lucene.util.StringInterner;

public abstract class StringHelper {
    public static StringInterner interner = new SimpleStringInterner(1024, 8);
    private static Comparator<String> versionComparator = new Comparator<String>(){

        @Override
        public int compare(String a, String b) {
            StringTokenizer aTokens = new StringTokenizer(a, ".");
            StringTokenizer bTokens = new StringTokenizer(b, ".");
            while (aTokens.hasMoreTokens()) {
                int aToken = Integer.parseInt(aTokens.nextToken());
                if (bTokens.hasMoreTokens()) {
                    int bToken = Integer.parseInt(bTokens.nextToken());
                    if (aToken == bToken) continue;
                    return aToken < bToken ? -1 : 1;
                }
                if (aToken == 0) continue;
                return 1;
            }
            while (bTokens.hasMoreTokens()) {
                if (Integer.parseInt(bTokens.nextToken()) == 0) continue;
                return -1;
            }
            return 0;
        }
    };

    public static String intern(String s) {
        return interner.intern(s);
    }

    public static final int bytesDifference(byte[] bytes1, int len1, byte[] bytes2, int len2) {
        int len = len1 < len2 ? len1 : len2;
        int i = 0;
        while (i < len) {
            if (bytes1[i] != bytes2[i]) {
                return i;
            }
            ++i;
        }
        return len;
    }

    private StringHelper() {
    }

    public static Comparator<String> getVersionComparator() {
        return versionComparator;
    }
}

