/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.IndexReader;

public final class ReaderUtil {
    private ReaderUtil() {
    }

    public static void gatherSubReaders(List<IndexReader> allSubReaders, IndexReader reader) {
        IndexReader[] subReaders = reader.getSequentialSubReaders();
        if (subReaders == null) {
            allSubReaders.add(reader);
        } else {
            int i = 0;
            while (i < subReaders.length) {
                ReaderUtil.gatherSubReaders(allSubReaders, subReaders[i]);
                ++i;
            }
        }
    }

    public static IndexReader subReader(int doc, IndexReader reader) {
        ArrayList<IndexReader> subReadersList = new ArrayList<IndexReader>();
        ReaderUtil.gatherSubReaders(subReadersList, reader);
        IndexReader[] subReaders = subReadersList.toArray(new IndexReader[subReadersList.size()]);
        int[] docStarts = new int[subReaders.length];
        int maxDoc = 0;
        int i = 0;
        while (i < subReaders.length) {
            docStarts[i] = maxDoc;
            maxDoc += subReaders[i].maxDoc();
            ++i;
        }
        return subReaders[ReaderUtil.subIndex(doc, docStarts)];
    }

    public static IndexReader subReader(IndexReader reader, int subIndex) {
        ArrayList<IndexReader> subReadersList = new ArrayList<IndexReader>();
        ReaderUtil.gatherSubReaders(subReadersList, reader);
        IndexReader[] subReaders = subReadersList.toArray(new IndexReader[subReadersList.size()]);
        return subReaders[subIndex];
    }

    /*
     * Unable to fully structure code
     */
    public static int subIndex(int n, int[] docStarts) {
        size = docStarts.length;
        lo = 0;
        hi = size - 1;
        while (hi >= lo) {
            mid = lo + hi >>> 1;
            midValue = docStarts[mid];
            if (n < midValue) {
                hi = mid - 1;
                continue;
            }
            if (n <= midValue) ** GOTO lbl14
            lo = mid + 1;
            continue;
lbl-1000:
            // 1 sources

            {
                ++mid;
lbl14:
                // 2 sources

                ** while (mid + 1 < size && docStarts[mid + 1] == midValue)
            }
lbl15:
            // 1 sources

            return mid;
        }
        return hi;
    }

    public static abstract class Gather {
        private final IndexReader topReader;

        public Gather(IndexReader r) {
            this.topReader = r;
        }

        public int run() throws IOException {
            return this.run(0, this.topReader);
        }

        public int run(int docBase) throws IOException {
            return this.run(docBase, this.topReader);
        }

        private int run(int base, IndexReader reader) throws IOException {
            IndexReader[] subReaders = reader.getSequentialSubReaders();
            if (subReaders == null) {
                this.add(base, reader);
                base += reader.maxDoc();
            } else {
                int i = 0;
                while (i < subReaders.length) {
                    base = this.run(base, subReaders[i]);
                    ++i;
                }
            }
            return base;
        }

        protected abstract void add(int var1, IndexReader var2) throws IOException;
    }
}

