/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.DecimalFormat;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.lucene.util.AverageGuessMemoryModel;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.MemoryModel;

public final class RamUsageEstimator {
    public static final int NUM_BYTES_SHORT = 2;
    public static final int NUM_BYTES_INT = 4;
    public static final int NUM_BYTES_LONG = 8;
    public static final int NUM_BYTES_FLOAT = 4;
    public static final int NUM_BYTES_DOUBLE = 8;
    public static final int NUM_BYTES_CHAR = 2;
    public static final int NUM_BYTES_OBJECT_HEADER = 8;
    public static final int NUM_BYTES_OBJECT_REF = Constants.JRE_IS_64BIT ? 8 : 4;
    public static final int NUM_BYTES_ARRAY_HEADER = 12 + NUM_BYTES_OBJECT_REF;
    private MemoryModel memoryModel;
    private final Map<Object, Object> seen;
    private int refSize;
    private int arraySize;
    private int classSize;
    private boolean checkInterned;
    private static final long ONE_KB = 1024L;
    private static final long ONE_MB = 0x100000L;
    private static final long ONE_GB = 0x40000000L;

    public RamUsageEstimator() {
        this(new AverageGuessMemoryModel());
    }

    public RamUsageEstimator(boolean checkInterned) {
        this(new AverageGuessMemoryModel(), checkInterned);
    }

    public RamUsageEstimator(MemoryModel memoryModel) {
        this(memoryModel, true);
    }

    public RamUsageEstimator(MemoryModel memoryModel, boolean checkInterned) {
        this.memoryModel = memoryModel;
        this.checkInterned = checkInterned;
        this.seen = new IdentityHashMap<Object, Object>(64);
        this.refSize = memoryModel.getReferenceSize();
        this.arraySize = memoryModel.getArraySize();
        this.classSize = memoryModel.getClassSize();
    }

    public long estimateRamUsage(Object obj) {
        long size = this.size(obj);
        this.seen.clear();
        return size;
    }

    private long size(Object obj) {
        if (obj == null) {
            return 0L;
        }
        if (this.checkInterned && obj instanceof String && obj == ((String)obj).intern()) {
            return 0L;
        }
        if (this.seen.containsKey(obj)) {
            return 0L;
        }
        this.seen.put(obj, null);
        Class<?> clazz = obj.getClass();
        if (clazz.isArray()) {
            return this.sizeOfArray(obj);
        }
        long size = 0L;
        while (clazz != null) {
            Field[] fields = clazz.getDeclaredFields();
            int i = 0;
            while (i < fields.length) {
                if (!Modifier.isStatic(fields[i].getModifiers())) {
                    if (fields[i].getType().isPrimitive()) {
                        size += (long)this.memoryModel.getPrimitiveSize(fields[i].getType());
                    } else {
                        size += (long)this.refSize;
                        fields[i].setAccessible(true);
                        try {
                            Object value = fields[i].get(obj);
                            if (value != null) {
                                size += this.size(value);
                            }
                        }
                        catch (IllegalAccessException illegalAccessException) {}
                    }
                }
                ++i;
            }
            clazz = clazz.getSuperclass();
        }
        return size += (long)this.classSize;
    }

    private long sizeOfArray(Object obj) {
        int len = Array.getLength(obj);
        if (len == 0) {
            return 0L;
        }
        long size = this.arraySize;
        Class<?> arrayElementClazz = obj.getClass().getComponentType();
        if (arrayElementClazz.isPrimitive()) {
            size += (long)(len * this.memoryModel.getPrimitiveSize(arrayElementClazz));
        } else {
            int i = 0;
            while (i < len) {
                size += (long)this.refSize + this.size(Array.get(obj, i));
                ++i;
            }
        }
        return size;
    }

    public static String humanReadableUnits(long bytes, DecimalFormat df) {
        String newSizeAndUnits = bytes / 0x40000000L > 0L ? String.valueOf(String.valueOf(df.format((float)bytes / 1.0737418E9f))) + " GB" : (bytes / 0x100000L > 0L ? String.valueOf(String.valueOf(df.format((float)bytes / 1048576.0f))) + " MB" : (bytes / 1024L > 0L ? String.valueOf(String.valueOf(df.format((float)bytes / 1024.0f))) + " KB" : String.valueOf(String.valueOf(bytes)) + " bytes"));
        return newSizeAndUnits;
    }
}

