/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.Closeable;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class CloseableThreadLocal<T>
implements Closeable {
    private ThreadLocal<WeakReference<T>> t = new ThreadLocal();
    private Map<Thread, T> hardRefs = new HashMap<Thread, T>();

    protected T initialValue() {
        return null;
    }

    public T get() {
        WeakReference<T> weakRef = this.t.get();
        if (weakRef == null) {
            T iv = this.initialValue();
            if (iv != null) {
                this.set(iv);
                return iv;
            }
            return null;
        }
        return weakRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(T object) {
        this.t.set(new WeakReference<T>(object));
        Map<Thread, T> map = this.hardRefs;
        synchronized (map) {
            this.hardRefs.put(Thread.currentThread(), object);
            Iterator<Thread> it = this.hardRefs.keySet().iterator();
            while (it.hasNext()) {
                Thread t = it.next();
                if (t.isAlive()) continue;
                it.remove();
            }
        }
    }

    @Override
    public void close() {
        this.hardRefs = null;
        if (this.t != null) {
            this.t.remove();
        }
        this.t = null;
    }
}

