/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.util.Constants;

public class MMapDirectory
extends FSDirectory {
    private boolean useUnmapHack = UNMAP_SUPPORTED;
    public static final int DEFAULT_MAX_BUFF;
    private int chunkSizePower;
    public static final boolean UNMAP_SUPPORTED;

    static {
        boolean v;
        DEFAULT_MAX_BUFF = Constants.JRE_IS_64BIT ? 0x40000000 : 0x10000000;
        try {
            Class.forName("sun.misc.Cleaner");
            Class.forName("java.nio.DirectByteBuffer").getMethod("cleaner", new Class[0]);
            v = true;
        }
        catch (Exception exception) {
            v = false;
        }
        UNMAP_SUPPORTED = v;
    }

    public MMapDirectory(File path, LockFactory lockFactory) throws IOException {
        super(path, lockFactory);
        this.setMaxChunkSize(DEFAULT_MAX_BUFF);
    }

    public MMapDirectory(File path) throws IOException {
        super(path, null);
        this.setMaxChunkSize(DEFAULT_MAX_BUFF);
    }

    public void setUseUnmap(boolean useUnmapHack) {
        if (useUnmapHack && !UNMAP_SUPPORTED) {
            throw new IllegalArgumentException("Unmap hack not supported on this platform!");
        }
        this.useUnmapHack = useUnmapHack;
    }

    public boolean getUseUnmap() {
        return this.useUnmapHack;
    }

    final void cleanMapping(final ByteBuffer buffer) throws IOException {
        if (this.useUnmapHack) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        Method getCleanerMethod = buffer.getClass().getMethod("cleaner", new Class[0]);
                        getCleanerMethod.setAccessible(true);
                        Object cleaner = getCleanerMethod.invoke((Object)buffer, new Object[0]);
                        if (cleaner != null) {
                            cleaner.getClass().getMethod("clean", new Class[0]).invoke(cleaner, new Object[0]);
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                IOException ioe = new IOException("unable to unmap the mapped buffer");
                ioe.initCause(e.getCause());
                throw ioe;
            }
        }
    }

    public final void setMaxChunkSize(int maxChunkSize) {
        if (maxChunkSize <= 0) {
            throw new IllegalArgumentException("Maximum chunk size for mmap must be >0");
        }
        this.chunkSizePower = 31 - Integer.numberOfLeadingZeros(maxChunkSize);
        assert (this.chunkSizePower >= 0 && this.chunkSizePower <= 30);
    }

    public final int getMaxChunkSize() {
        return 1 << this.chunkSizePower;
    }

    @Override
    public IndexInput openInput(String name, int bufferSize) throws IOException {
        this.ensureOpen();
        File f = new File(this.getDirectory(), name);
        RandomAccessFile raf = new RandomAccessFile(f, "r");
        try {
            MMapIndexInput mMapIndexInput = new MMapIndexInput("MMapIndexInput(path=\"" + f + "\")", raf, this.chunkSizePower);
            return mMapIndexInput;
        }
        finally {
            raf.close();
        }
    }

    private final class MMapIndexInput
    extends IndexInput {
        private ByteBuffer[] buffers;
        private final long length;
        private final long chunkSizeMask;
        private final long chunkSize;
        private final int chunkSizePower;
        private int curBufIndex;
        private ByteBuffer curBuf;
        private boolean isClone;

        MMapIndexInput(String resourceDescription, RandomAccessFile raf, int chunkSizePower) throws IOException {
            super(resourceDescription);
            this.isClone = false;
            this.length = raf.length();
            this.chunkSizePower = chunkSizePower;
            this.chunkSize = 1L << chunkSizePower;
            this.chunkSizeMask = this.chunkSize - 1L;
            if (chunkSizePower < 0 || chunkSizePower > 30) {
                throw new IllegalArgumentException("Invalid chunkSizePower used for ByteBuffer size: " + chunkSizePower);
            }
            if (this.length >>> chunkSizePower >= Integer.MAX_VALUE) {
                throw new IllegalArgumentException("RandomAccessFile too big for chunk size: " + raf.toString());
            }
            int nrBuffers = (int)(this.length >>> chunkSizePower) + 1;
            this.buffers = new ByteBuffer[nrBuffers];
            long bufferStart = 0L;
            FileChannel rafc = raf.getChannel();
            int bufNr = 0;
            while (bufNr < nrBuffers) {
                int bufSize = (int)(this.length > bufferStart + this.chunkSize ? this.chunkSize : this.length - bufferStart);
                this.buffers[bufNr] = rafc.map(FileChannel.MapMode.READ_ONLY, bufferStart, bufSize);
                bufferStart += (long)bufSize;
                ++bufNr;
            }
            this.seek(0L);
        }

        @Override
        public byte readByte() throws IOException {
            try {
                return this.curBuf.get();
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                do {
                    ++this.curBufIndex;
                    if (this.curBufIndex >= this.buffers.length) {
                        throw new IOException("read past EOF: " + this);
                    }
                    this.curBuf = this.buffers[this.curBufIndex];
                    this.curBuf.position(0);
                } while (!this.curBuf.hasRemaining());
                return this.curBuf.get();
            }
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void readBytes(byte[] b, int offset, int len) throws IOException {
            block4: {
                try {
                    this.curBuf.get(b, offset, len);
                    break block4;
                }
                catch (BufferUnderflowException v0) {
                    curAvail = this.curBuf.remaining();
                    ** while (len > curAvail)
                }
lbl-1000:
                // 1 sources

                {
                    this.curBuf.get(b, offset, curAvail);
                    len -= curAvail;
                    offset += curAvail;
                    ++this.curBufIndex;
                    if (this.curBufIndex >= this.buffers.length) {
                        throw new IOException("read past EOF: " + this);
                    }
                    this.curBuf = this.buffers[this.curBufIndex];
                    this.curBuf.position(0);
                    curAvail = this.curBuf.remaining();
                    continue;
                }
lbl20:
                // 1 sources

                this.curBuf.get(b, offset, len);
            }
        }

        @Override
        public int readInt() throws IOException {
            try {
                return this.curBuf.getInt();
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                return super.readInt();
            }
        }

        @Override
        public long readLong() throws IOException {
            try {
                return this.curBuf.getLong();
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                return super.readLong();
            }
        }

        @Override
        public long getFilePointer() {
            return ((long)this.curBufIndex << this.chunkSizePower) + (long)this.curBuf.position();
        }

        @Override
        public void seek(long pos) throws IOException {
            int bi = (int)(pos >> this.chunkSizePower);
            try {
                ByteBuffer b = this.buffers[bi];
                b.position((int)(pos & this.chunkSizeMask));
                this.curBufIndex = bi;
                this.curBuf = b;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (pos < 0L) {
                    throw new IllegalArgumentException("Seeking to negative position: " + this);
                }
                throw new IOException("seek past EOF");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (pos < 0L) {
                    throw new IllegalArgumentException("Seeking to negative position: " + this);
                }
                throw new IOException("seek past EOF: " + this);
            }
        }

        @Override
        public long length() {
            return this.length;
        }

        @Override
        public Object clone() {
            if (this.buffers == null) {
                throw new AlreadyClosedException("MMapIndexInput already closed: " + this);
            }
            MMapIndexInput clone = (MMapIndexInput)super.clone();
            clone.isClone = true;
            clone.buffers = new ByteBuffer[this.buffers.length];
            int bufNr = 0;
            while (bufNr < this.buffers.length) {
                clone.buffers[bufNr] = this.buffers[bufNr].duplicate();
                ++bufNr;
            }
            try {
                clone.seek(this.getFilePointer());
            }
            catch (IOException ioe) {
                throw new RuntimeException("Should never happen: " + this, ioe);
            }
            return clone;
        }

        @Override
        public void close() throws IOException {
            try {
                if (this.isClone || this.buffers == null) {
                    return;
                }
                int bufNr = 0;
                while (bufNr < this.buffers.length) {
                    try {
                        MMapDirectory.this.cleanMapping(this.buffers[bufNr]);
                    }
                    finally {
                        this.buffers[bufNr] = null;
                    }
                    ++bufNr;
                }
            }
            finally {
                this.buffers = null;
            }
        }
    }
}

