/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.index.IndexFileNameFilter;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.util.IOUtils;

public abstract class Directory
implements Closeable {
    protected volatile boolean isOpen = true;
    protected LockFactory lockFactory;

    public abstract String[] listAll() throws IOException;

    public abstract boolean fileExists(String var1) throws IOException;

    public abstract long fileModified(String var1) throws IOException;

    @Deprecated
    public abstract void touchFile(String var1) throws IOException;

    public abstract void deleteFile(String var1) throws IOException;

    public abstract long fileLength(String var1) throws IOException;

    public abstract IndexOutput createOutput(String var1) throws IOException;

    @Deprecated
    public void sync(String name) throws IOException {
    }

    public void sync(Collection<String> names) throws IOException {
        for (String name : names) {
            this.sync(name);
        }
    }

    public abstract IndexInput openInput(String var1) throws IOException;

    public IndexInput openInput(String name, int bufferSize) throws IOException {
        return this.openInput(name);
    }

    public Lock makeLock(String name) {
        return this.lockFactory.makeLock(name);
    }

    public void clearLock(String name) throws IOException {
        if (this.lockFactory != null) {
            this.lockFactory.clearLock(name);
        }
    }

    @Override
    public abstract void close() throws IOException;

    public void setLockFactory(LockFactory lockFactory) throws IOException {
        assert (lockFactory != null);
        this.lockFactory = lockFactory;
        lockFactory.setLockPrefix(this.getLockID());
    }

    public LockFactory getLockFactory() {
        return this.lockFactory;
    }

    public String getLockID() {
        return this.toString();
    }

    public String toString() {
        return String.valueOf(super.toString()) + " lockFactory=" + this.getLockFactory();
    }

    public void copy(Directory to, String src, String dest) throws IOException {
        block5: {
            IndexOutput os = null;
            IndexInput is = null;
            IOException priorException = null;
            try {
                try {
                    os = to.createOutput(dest);
                    is = this.openInput(src);
                    is.copyBytes(os, is.length());
                }
                catch (IOException ioe) {
                    priorException = ioe;
                    IOUtils.closeWhileHandlingException(priorException, os, is);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeWhileHandlingException(priorException, os, is);
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(priorException, os, is);
        }
    }

    @Deprecated
    public static void copy(Directory src, Directory dest, boolean closeDirSrc) throws IOException {
        IndexFileNameFilter filter = IndexFileNameFilter.getFilter();
        String[] stringArray = src.listAll();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            if (filter.accept(null, file)) {
                src.copy(dest, file, file);
            }
            ++n2;
        }
        if (closeDirSrc) {
            src.close();
        }
    }

    protected final void ensureOpen() throws AlreadyClosedException {
        if (!this.isOpen) {
            throw new AlreadyClosedException("this Directory is closed");
        }
    }
}

