/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.payloads;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanOrQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.lucene.search.spans.Spans;

public class PayloadSpanUtil {
    private IndexReader reader;

    public PayloadSpanUtil(IndexReader reader) {
        this.reader = reader;
    }

    public Collection<byte[]> getPayloadsForQuery(Query query) throws IOException {
        ArrayList<byte[]> payloads = new ArrayList<byte[]>();
        this.queryToSpanQuery(query, payloads);
        return payloads;
    }

    private void queryToSpanQuery(Query query, Collection<byte[]> payloads) throws IOException {
        if (query instanceof BooleanQuery) {
            BooleanClause[] queryClauses = ((BooleanQuery)query).getClauses();
            int i = 0;
            while (i < queryClauses.length) {
                if (!queryClauses[i].isProhibited()) {
                    this.queryToSpanQuery(queryClauses[i].getQuery(), payloads);
                }
                ++i;
            }
        } else if (query instanceof PhraseQuery) {
            Term[] phraseQueryTerms = ((PhraseQuery)query).getTerms();
            SpanQuery[] clauses = new SpanQuery[phraseQueryTerms.length];
            int i = 0;
            while (i < phraseQueryTerms.length) {
                clauses[i] = new SpanTermQuery(phraseQueryTerms[i]);
                ++i;
            }
            int slop = ((PhraseQuery)query).getSlop();
            boolean inorder = false;
            if (slop == 0) {
                inorder = true;
            }
            SpanNearQuery sp = new SpanNearQuery(clauses, slop, inorder);
            sp.setBoost(query.getBoost());
            this.getPayloads(payloads, sp);
        } else if (query instanceof TermQuery) {
            SpanTermQuery stq = new SpanTermQuery(((TermQuery)query).getTerm());
            stq.setBoost(query.getBoost());
            this.getPayloads(payloads, stq);
        } else if (query instanceof SpanQuery) {
            this.getPayloads(payloads, (SpanQuery)query);
        } else if (query instanceof FilteredQuery) {
            this.queryToSpanQuery(((FilteredQuery)query).getQuery(), payloads);
        } else if (query instanceof DisjunctionMaxQuery) {
            Iterator<Query> iterator = ((DisjunctionMaxQuery)query).iterator();
            while (iterator.hasNext()) {
                this.queryToSpanQuery(iterator.next(), payloads);
            }
        } else if (query instanceof MultiPhraseQuery) {
            MultiPhraseQuery mpq = (MultiPhraseQuery)query;
            List<Term[]> termArrays = mpq.getTermArrays();
            int[] positions = mpq.getPositions();
            if (positions.length > 0) {
                int maxPosition = positions[positions.length - 1];
                int i = 0;
                while (i < positions.length - 1) {
                    if (positions[i] > maxPosition) {
                        maxPosition = positions[i];
                    }
                    ++i;
                }
                List[] disjunctLists = new List[maxPosition + 1];
                int distinctPositions = 0;
                int i2 = 0;
                while (i2 < termArrays.size()) {
                    Term[] termArray = termArrays.get(i2);
                    ArrayList<SpanTermQuery> disjuncts = disjunctLists[positions[i2]];
                    if (disjuncts == null) {
                        ArrayList<SpanTermQuery> arrayList = new ArrayList<SpanTermQuery>(termArray.length);
                        disjunctLists[positions[i2]] = arrayList;
                        disjuncts = arrayList;
                        ++distinctPositions;
                    }
                    Term[] termArray2 = termArray;
                    int n = termArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Term term = termArray2[n2];
                        disjuncts.add(new SpanTermQuery(term));
                        ++n2;
                    }
                    ++i2;
                }
                int positionGaps = 0;
                int position = 0;
                SpanQuery[] clauses = new SpanQuery[distinctPositions];
                int i3 = 0;
                while (i3 < disjunctLists.length) {
                    List disjuncts = disjunctLists[i3];
                    if (disjuncts != null) {
                        clauses[position++] = new SpanOrQuery(disjuncts.toArray(new SpanQuery[disjuncts.size()]));
                    } else {
                        ++positionGaps;
                    }
                    ++i3;
                }
                int slop = mpq.getSlop();
                boolean inorder = slop == 0;
                SpanNearQuery sp = new SpanNearQuery(clauses, slop + positionGaps, inorder);
                sp.setBoost(query.getBoost());
                this.getPayloads(payloads, sp);
            }
        }
    }

    private void getPayloads(Collection<byte[]> payloads, SpanQuery query) throws IOException {
        Spans spans = query.getSpans(this.reader);
        while (spans.next()) {
            if (!spans.isPayloadAvailable()) continue;
            Collection<byte[]> payload = spans.getPayload();
            for (byte[] bytes : payload) {
                payloads.add(bytes);
            }
        }
    }
}

