/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.function;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.function.DocValues;
import org.apache.lucene.search.function.ValueSource;

public class ReverseOrdFieldSource
extends ValueSource {
    public String field;
    private static final int hcode = ReverseOrdFieldSource.class.hashCode();

    public ReverseOrdFieldSource(String field) {
        this.field = field;
    }

    @Override
    public String description() {
        return "rord(" + this.field + ')';
    }

    @Override
    public DocValues getValues(IndexReader reader) throws IOException {
        FieldCache.StringIndex sindex = FieldCache.DEFAULT.getStringIndex(reader, this.field);
        final int[] arr = sindex.order;
        final int end = sindex.lookup.length;
        return new DocValues(){

            @Override
            public float floatVal(int doc) {
                return end - arr[doc];
            }

            @Override
            public int intVal(int doc) {
                return end - arr[doc];
            }

            @Override
            public String strVal(int doc) {
                return Integer.toString(this.intVal(doc));
            }

            @Override
            public String toString(int doc) {
                return String.valueOf(ReverseOrdFieldSource.this.description()) + '=' + this.strVal(doc);
            }

            @Override
            Object getInnerArray() {
                return arr;
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != ReverseOrdFieldSource.class) {
            return false;
        }
        ReverseOrdFieldSource other = (ReverseOrdFieldSource)o;
        return this.field.equals(other.field);
    }

    @Override
    public int hashCode() {
        return hcode + this.field.hashCode();
    }
}

