/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.function;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.function.DocValues;
import org.apache.lucene.search.function.FieldCacheSource;

public class IntFieldSource
extends FieldCacheSource {
    private FieldCache.IntParser parser;

    public IntFieldSource(String field) {
        this(field, null);
    }

    public IntFieldSource(String field, FieldCache.IntParser parser) {
        super(field);
        this.parser = parser;
    }

    @Override
    public String description() {
        return "int(" + super.description() + ')';
    }

    @Override
    public DocValues getCachedFieldValues(FieldCache cache, String field, IndexReader reader) throws IOException {
        final int[] arr = cache.getInts(reader, field, this.parser);
        return new DocValues(){

            @Override
            public float floatVal(int doc) {
                return arr[doc];
            }

            @Override
            public int intVal(int doc) {
                return arr[doc];
            }

            @Override
            public String toString(int doc) {
                return String.valueOf(IntFieldSource.this.description()) + '=' + this.intVal(doc);
            }

            @Override
            Object getInnerArray() {
                return arr;
            }
        };
    }

    @Override
    public boolean cachedFieldSourceEquals(FieldCacheSource o) {
        if (o.getClass() != IntFieldSource.class) {
            return false;
        }
        IntFieldSource other = (IntFieldSource)o;
        return this.parser == null ? other.parser == null : this.parser.getClass() == other.parser.getClass();
    }

    @Override
    public int cachedFieldSourceHashCode() {
        return this.parser == null ? Integer.class.hashCode() : this.parser.getClass().hashCode();
    }
}

