/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.function;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Explanation;

public class CustomScoreProvider {
    protected final IndexReader reader;

    public CustomScoreProvider(IndexReader reader) {
        this.reader = reader;
    }

    public float customScore(int doc, float subQueryScore, float[] valSrcScores) throws IOException {
        if (valSrcScores.length == 1) {
            return this.customScore(doc, subQueryScore, valSrcScores[0]);
        }
        if (valSrcScores.length == 0) {
            return this.customScore(doc, subQueryScore, 1.0f);
        }
        float score = subQueryScore;
        int i = 0;
        while (i < valSrcScores.length) {
            score *= valSrcScores[i];
            ++i;
        }
        return score;
    }

    public float customScore(int doc, float subQueryScore, float valSrcScore) throws IOException {
        return subQueryScore * valSrcScore;
    }

    public Explanation customExplain(int doc, Explanation subQueryExpl, Explanation[] valSrcExpls) throws IOException {
        if (valSrcExpls.length == 1) {
            return this.customExplain(doc, subQueryExpl, valSrcExpls[0]);
        }
        if (valSrcExpls.length == 0) {
            return subQueryExpl;
        }
        float valSrcScore = 1.0f;
        int i = 0;
        while (i < valSrcExpls.length) {
            valSrcScore *= valSrcExpls[i].getValue();
            ++i;
        }
        Explanation exp = new Explanation(valSrcScore * subQueryExpl.getValue(), "custom score: product of:");
        exp.addDetail(subQueryExpl);
        int i2 = 0;
        while (i2 < valSrcExpls.length) {
            exp.addDetail(valSrcExpls[i2]);
            ++i2;
        }
        return exp;
    }

    public Explanation customExplain(int doc, Explanation subQueryExpl, Explanation valSrcExpl) throws IOException {
        float valSrcScore = 1.0f;
        if (valSrcExpl != null) {
            valSrcScore *= valSrcExpl.getValue();
        }
        Explanation exp = new Explanation(valSrcScore * subQueryExpl.getValue(), "custom score: product of:");
        exp.addDetail(subQueryExpl);
        exp.addDetail(valSrcExpl);
        return exp;
    }
}

