/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;

final class TermScorer
extends Scorer {
    private final TermDocs termDocs;
    private final byte[] norms;
    private float weightValue;
    private int doc = -1;
    private int freq;
    private final int[] docs = new int[32];
    private final int[] freqs = new int[32];
    private int pointer;
    private int pointerMax;
    private static final int SCORE_CACHE_SIZE = 32;
    private final float[] scoreCache = new float[32];

    TermScorer(Weight weight, TermDocs td, Similarity similarity, byte[] norms) {
        super(similarity, weight);
        this.termDocs = td;
        this.norms = norms;
        this.weightValue = weight.getValue();
        int i = 0;
        while (i < 32) {
            this.scoreCache[i] = this.getSimilarity().tf(i) * this.weightValue;
            ++i;
        }
    }

    @Override
    public void score(Collector c) throws IOException {
        this.score(c, Integer.MAX_VALUE, this.nextDoc());
    }

    @Override
    protected boolean score(Collector c, int end, int firstDocID) throws IOException {
        c.setScorer(this);
        while (this.doc < end) {
            c.collect(this.doc);
            if (++this.pointer >= this.pointerMax) {
                this.pointerMax = this.termDocs.read(this.docs, this.freqs);
                if (this.pointerMax != 0) {
                    this.pointer = 0;
                } else {
                    this.termDocs.close();
                    this.doc = Integer.MAX_VALUE;
                    return false;
                }
            }
            this.doc = this.docs[this.pointer];
            this.freq = this.freqs[this.pointer];
        }
        return true;
    }

    @Override
    public int docID() {
        return this.doc;
    }

    @Override
    public float freq() {
        return this.freq;
    }

    @Override
    public int nextDoc() throws IOException {
        ++this.pointer;
        if (this.pointer >= this.pointerMax) {
            this.pointerMax = this.termDocs.read(this.docs, this.freqs);
            if (this.pointerMax != 0) {
                this.pointer = 0;
            } else {
                this.termDocs.close();
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
        }
        this.doc = this.docs[this.pointer];
        this.freq = this.freqs[this.pointer];
        return this.doc;
    }

    @Override
    public float score() {
        assert (this.doc != -1);
        float raw = this.freq < 32 ? this.scoreCache[this.freq] : this.getSimilarity().tf(this.freq) * this.weightValue;
        return this.norms == null ? raw : raw * this.getSimilarity().decodeNormValue(this.norms[this.doc]);
    }

    @Override
    public int advance(int target) throws IOException {
        ++this.pointer;
        while (this.pointer < this.pointerMax) {
            if (this.docs[this.pointer] >= target) {
                this.freq = this.freqs[this.pointer];
                this.doc = this.docs[this.pointer];
                return this.doc;
            }
            ++this.pointer;
        }
        boolean result = this.termDocs.skipTo(target);
        if (result) {
            this.pointerMax = 1;
            this.pointer = 0;
            this.docs[this.pointer] = this.doc = this.termDocs.doc();
            this.freqs[this.pointer] = this.freq = this.termDocs.freq();
        } else {
            this.doc = Integer.MAX_VALUE;
        }
        return this.doc;
    }

    public String toString() {
        return "scorer(" + this.weight + ")";
    }
}

