/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.util.ArrayUtil;

public class QueryTermVector
implements TermFreqVector {
    private String[] terms = new String[0];
    private int[] termFreqs = new int[0];

    @Override
    public String getField() {
        return null;
    }

    public QueryTermVector(String[] queryTerms) {
        this.processTerms(queryTerms);
    }

    public QueryTermVector(String queryString, Analyzer analyzer) {
        if (analyzer != null) {
            TokenStream stream;
            try {
                stream = analyzer.reusableTokenStream("", new StringReader(queryString));
            }
            catch (IOException iOException) {
                stream = null;
            }
            if (stream != null) {
                ArrayList<String> terms = new ArrayList<String>();
                try {
                    boolean hasMoreTokens = false;
                    stream.reset();
                    CharTermAttribute termAtt = stream.addAttribute(CharTermAttribute.class);
                    hasMoreTokens = stream.incrementToken();
                    while (hasMoreTokens) {
                        terms.add(termAtt.toString());
                        hasMoreTokens = stream.incrementToken();
                    }
                    this.processTerms(terms.toArray(new String[terms.size()]));
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void processTerms(String[] queryTerms) {
        if (queryTerms != null) {
            ArrayUtil.quickSort((Comparable[])queryTerms);
            HashMap<String, Integer> tmpSet = new HashMap<String, Integer>(queryTerms.length);
            ArrayList<String> tmpList = new ArrayList<String>(queryTerms.length);
            ArrayList<Integer> tmpFreqs = new ArrayList<Integer>(queryTerms.length);
            int j = 0;
            int i = 0;
            while (i < queryTerms.length) {
                String term = queryTerms[i];
                Integer position = (Integer)tmpSet.get(term);
                if (position == null) {
                    tmpSet.put(term, j++);
                    tmpList.add(term);
                    tmpFreqs.add(1);
                } else {
                    Integer integer = (Integer)tmpFreqs.get(position);
                    tmpFreqs.set(position, integer + 1);
                }
                ++i;
            }
            this.terms = tmpList.toArray(this.terms);
            this.termFreqs = new int[tmpFreqs.size()];
            i = 0;
            for (Integer integer : tmpFreqs) {
                this.termFreqs[i++] = integer;
            }
        }
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        int i = 0;
        while (i < this.terms.length) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.terms[i]).append('/').append(this.termFreqs[i]);
            ++i;
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public int size() {
        return this.terms.length;
    }

    @Override
    public String[] getTerms() {
        return this.terms;
    }

    @Override
    public int[] getTermFrequencies() {
        return this.termFreqs;
    }

    @Override
    public int indexOf(String term) {
        int res = Arrays.binarySearch(this.terms, term);
        return res >= 0 ? res : -1;
    }

    @Override
    public int[] indexesOf(String[] terms, int start, int len) {
        int[] res = new int[len];
        int i = 0;
        while (i < len) {
            res[i] = this.indexOf(terms[i]);
            ++i;
        }
        return res;
    }
}

