/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;

public abstract class Query
implements Serializable,
Cloneable {
    private float boost = 1.0f;

    public void setBoost(float b) {
        this.boost = b;
    }

    public float getBoost() {
        return this.boost;
    }

    public abstract String toString(String var1);

    public String toString() {
        return this.toString("");
    }

    public Weight createWeight(Searcher searcher) throws IOException {
        throw new UnsupportedOperationException("Query " + this + " does not implement createWeight");
    }

    @Deprecated
    public final Weight weight(Searcher searcher) throws IOException {
        return searcher.createNormalizedWeight(this);
    }

    public Query rewrite(IndexReader reader) throws IOException {
        return this;
    }

    public Query combine(Query[] queries) {
        HashSet<Query> uniques = new HashSet<Query>();
        int i = 0;
        while (i < queries.length) {
            Query query = queries[i];
            BooleanClause[] clauses = null;
            boolean splittable = query instanceof BooleanQuery;
            if (splittable) {
                BooleanQuery bq = (BooleanQuery)query;
                splittable = bq.isCoordDisabled();
                clauses = bq.getClauses();
                int j = 0;
                while (splittable && j < clauses.length) {
                    splittable = clauses[j].getOccur() == BooleanClause.Occur.SHOULD;
                    ++j;
                }
            }
            if (splittable) {
                int j = 0;
                while (j < clauses.length) {
                    uniques.add(clauses[j].getQuery());
                    ++j;
                }
            } else {
                uniques.add(query);
            }
            ++i;
        }
        if (uniques.size() == 1) {
            return (Query)uniques.iterator().next();
        }
        BooleanQuery result = new BooleanQuery(true);
        for (Query query : uniques) {
            result.add(query, BooleanClause.Occur.SHOULD);
        }
        return result;
    }

    public void extractTerms(Set<Term> terms) {
        throw new UnsupportedOperationException();
    }

    public static Query mergeBooleanQueries(BooleanQuery ... queries) {
        HashSet<BooleanClause> allClauses = new HashSet<BooleanClause>();
        BooleanQuery[] booleanQueryArray = queries;
        int n = queries.length;
        int n2 = 0;
        while (n2 < n) {
            BooleanQuery booleanQuery = booleanQueryArray[n2];
            for (BooleanClause clause : booleanQuery) {
                allClauses.add(clause);
            }
            ++n2;
        }
        boolean coordDisabled = queries.length == 0 ? false : queries[0].isCoordDisabled();
        BooleanQuery result = new BooleanQuery(coordDisabled);
        for (BooleanClause clause2 : allClauses) {
            result.add(clause2);
        }
        return result;
    }

    @Deprecated
    public Similarity getSimilarity(Searcher searcher) {
        return searcher.getSimilarity();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Clone not supported: " + e.getMessage());
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.boost);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Query other = (Query)obj;
        return Float.floatToIntBits(this.boost) == Float.floatToIntBits(other.boost);
    }
}

